/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.gson.reflect.TypeToken;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.data.ItemGroupData;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public class ItemGroupRegistry {
    public static final Object2ObjectLinkedOpenHashMap<class_2960, List<class_1792>> TAB_GROUP_ITEMS = new Object2ObjectLinkedOpenHashMap();
    public static final Object2ObjectLinkedOpenHashMap<class_2960, class_1761> TAB_GROUPS = new Object2ObjectLinkedOpenHashMap();

    public static void register(InputStream inputStream) throws IOException {
        List data = (List)Json.GSON.fromJson((Reader)new InputStreamReader(inputStream), TypeToken.getParameterized(List.class, (Type[])new Type[]{ItemGroupData.class}).getType());
        for (ItemGroupData datum : data) {
            ItemGroupRegistry.register(datum);
        }
    }

    public static void register(ItemGroupData data) {
        if (TAB_GROUPS.containsKey((Object)data.id())) {
            return;
        }
        class_1761 group = new class_1761.class_7913(null, -1).method_47321((class_2561)(data.literal() == null ? class_2561.method_43471((String)(data.id().method_12836() + ".itemGroup." + data.id().method_12832())) : data.literal())).method_47320(() -> ((class_1792)class_7923.field_41178.method_63535(data.item())).method_7854()).method_47317((parameters, output) -> ((List)TAB_GROUP_ITEMS.get((Object)data.id())).forEach(arg_0 -> ((class_1761.class_7704)output).method_45421(arg_0))).method_47324();
        TAB_GROUPS.put((Object)data.id(), (Object)group);
        TAB_GROUP_ITEMS.putIfAbsent((Object)data.id(), (Object)new ObjectArrayList());
        if (!PolymerItemGroupUtils.contains((class_2960)data.id()).booleanValue() && !((List)TAB_GROUP_ITEMS.get((Object)data.id())).isEmpty()) {
            PolymerItemGroupUtils.registerPolymerItemGroup((class_2960)data.id(), (class_1761)group);
        }
    }

    public static void addItem(class_2960 identifier, class_1792 item) {
        TAB_GROUP_ITEMS.putIfAbsent((Object)identifier, (Object)new ObjectArrayList());
        ((List)TAB_GROUP_ITEMS.get((Object)identifier)).add(item);
        if (!PolymerItemGroupUtils.contains((class_2960)identifier).booleanValue() && TAB_GROUPS.containsKey((Object)identifier)) {
            PolymerItemGroupUtils.registerPolymerItemGroup((class_2960)identifier, (class_1761)((class_1761)TAB_GROUPS.get((Object)identifier)));
        }
    }

    public static class ItemGroupDataReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"item_groups");
        }

        public void method_14491(class_3300 resourceManager) {
            this.load("filament", "item-groups", resourceManager, (id, inputStream) -> {
                try {
                    ItemGroupRegistry.register(inputStream);
                }
                catch (IOException e) {
                    Filament.LOGGER.error("Failed to load item group config \"{}\".", id);
                }
            });
        }
    }
}

