/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.mixin.accessor.FireBlockInvoker;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.impl.BlockExtBlockMapper;
import eu.pb4.polymer.blocks.impl.DefaultModelData;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateMultiPartDefinition;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_10776;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fire
implements BlockBehaviour<Config> {
    private static final List<FireModelEntry> FIRE_MODELS = ObjectArrayList.of((Object[])new FireModelEntry[]{FireModelEntry.DEFAULT});
    private static final class_2358 FIRE_BLOCK = (class_2358)class_2246.field_10036;
    private static final Map<class_2248, JsonArray> holderData = new Reference2ObjectArrayMap();
    public static Map<class_2248, class_2248> MATERIAL_BLOCKS;
    private final Config config;

    public Fire(Config config) {
        this.config = config;
    }

    public static class_2248 getMaterialFire(class_2680 blockState) {
        if (MATERIAL_BLOCKS == null) {
            Codec setCodec = class_6895.method_40340((class_5321)class_7924.field_41254);
            Reference2ReferenceArrayMap map = new Reference2ReferenceArrayMap();
            for (Map.Entry<class_2248, JsonArray> entry : holderData.entrySet()) {
                JsonArray arr = entry.getValue();
                for (JsonElement element : arr) {
                    DataResult holderSet = setCodec.decode((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)Filament.REGISTRY_ACCESS.method_45926()), (Object)element);
                    holderSet.ifSuccess(x -> {
                        for (class_6880 holder : (class_6885)x.getFirst()) {
                            map.put((Object)((class_2248)holder.comp_349()), (Object)((class_2248)entry.getKey()));
                        }
                    });
                }
            }
            MATERIAL_BLOCKS = map;
        }
        return MATERIAL_BLOCKS.get(blockState.method_26204());
    }

    @Override
    public void init(class_1792 item, class_2248 block, BehaviourHolder behaviourHolder) {
        JsonArray arr = new JsonArray();
        if (this.config.blocks != null) {
            for (class_2960 location : this.config.blocks) {
                arr.add(location.toString());
            }
        }
        if (this.config.blockTags != null) {
            for (class_2960 location : this.config.blockTags) {
                arr.add("#" + location.toString());
            }
        }
        holderData.put(block, arr);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)class_2358.field_11096, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2358.field_11094, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2358.field_11089, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2358.field_11088, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2358.field_11093, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(0));
    }

    @Override
    public void playerWillDestroy(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        FIRE_BLOCK.method_9576(level, blockPos, blockState, player);
    }

    @Override
    public void entityInside(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity, class_10774 insideBlockEffectApplier) {
        if (this.config.hurt) {
            insideBlockEffectApplier.method_67638(class_10776.field_56643);
            insideBlockEffectApplier.method_67640(class_10776.field_56643, e -> e.method_64419(e.method_37908().method_48963().method_48794(), this.config.damage));
        }
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        return blockState.method_26204().method_34725(((FireBlockInvoker)FIRE_BLOCK).invokeUpdateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource));
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 blockState, class_1750 blockPlaceContext) {
        return blockState.method_26204().method_34725(((FireBlockInvoker)FIRE_BLOCK).invokeGetStateForPlacement((class_1922)blockPlaceContext.method_8045(), blockPlaceContext.method_8037()));
    }

    @Override
    public boolean canSurvive(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return ((FireBlockInvoker)FIRE_BLOCK).invokeCanSurvive(blockState, levelReader, blockPos);
    }

    @Override
    public void tick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        ((FireBlockInvoker)FIRE_BLOCK).invokeTick(blockState, serverLevel, blockPos, randomSource);
    }

    @Override
    public void onPlace(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        ((FireBlockInvoker)FIRE_BLOCK).invokeOnPlace(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        ((FireBlockInvoker)FIRE_BLOCK).invokeCreateBlockStateDefinition(builder);
    }

    @Override
    public class_2680 modifyPolymerBlockState(class_2680 originalBlockState, class_2680 blockState) {
        return (class_2680)blockState.method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(0));
    }

    @Override
    public boolean modifyStateMap(Map<class_2680, BlockData.BlockStateMeta> map, AbstractBlockData<? extends BlockProperties> data) {
        Map<String, PolymerBlockModel> m = data.blockResource().models();
        List<class_2960> l1 = m.entrySet().stream().map(entry -> ((String)entry.getKey()).startsWith("up") ? ((PolymerBlockModel)entry.getValue()).model() : null).filter(Objects::nonNull).toList();
        List<class_2960> l2 = m.entrySet().stream().map(entry -> ((String)entry.getKey()).startsWith("side") ? ((PolymerBlockModel)entry.getValue()).model() : null).filter(Objects::nonNull).toList();
        List<class_2960> l3 = m.entrySet().stream().map(entry -> ((String)entry.getKey()).startsWith("floor") ? ((PolymerBlockModel)entry.getValue()).model() : null).filter(Objects::nonNull).toList();
        int id = FIRE_MODELS.size();
        FIRE_MODELS.add(new FireModelEntry(data.id(), FIRE_MODELS.size(), l1, l2, l3));
        class_2248 customBlock = (class_2248)class_7923.field_41175.method_63535(data.id());
        for (class_2680 possibleState : customBlock.method_9595().method_11662()) {
            if ((Integer)possibleState.method_11654((class_2769)class_2358.field_11092) != 0) continue;
            map.put(possibleState, BlockData.BlockStateMeta.of((class_2680)FIRE_BLOCK.method_34725(possibleState).method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(id)), null));
        }
        return true;
    }

    public static void addRemap() {
        for (class_2680 possibleState : class_2246.field_10036.method_9595().method_11662()) {
            if ((Integer)possibleState.method_11654((class_2769)class_2358.field_11092) <= 0) continue;
            DefaultModelData.SPECIAL_REMAPS.put(possibleState, (class_2680)possibleState.method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(0)));
            BlockExtBlockMapper.INSTANCE.stateMap.put(possibleState, (class_2680)possibleState.method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(0)));
        }
    }

    public static void init(ResourcePackBuilder resourcePackBuilder) {
        if (FIRE_MODELS.size() <= 1) {
            return;
        }
        String firepath = "assets/minecraft/blockstates/fire.json";
        String data = resourcePackBuilder.getStringDataOrSource(firepath);
        if (data == null) {
            Filament.LOGGER.error("Could not load fire block state definition!");
            return;
        }
        DataResult dec = BlockStateAsset.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data));
        dec.ifSuccess(pair -> {
            BlockStateAsset blockStateAsset = (BlockStateAsset)pair.getFirst();
            if (blockStateAsset.multipart().isPresent()) {
                ObjectArrayList list = new ObjectArrayList();
                for (FireModelEntry model : FIRE_MODELS) {
                    list.addAll(Fire.fireSelection(blockStateAsset, model));
                }
                BlockStateAsset newAsset = new BlockStateAsset(Optional.empty(), Optional.of(list));
                resourcePackBuilder.addStringData(firepath, ((JsonElement)BlockStateAsset.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)newAsset).getOrThrow()).toString());
            }
        });
    }

    private static List<StateMultiPartDefinition> fireSelection(BlockStateAsset fireAsset, FireModelEntry modelEntry) {
        ObjectArrayList list = new ObjectArrayList();
        if (fireAsset.multipart().isPresent()) {
            for (StateMultiPartDefinition partDefinition : (List)fireAsset.multipart().get()) {
                StateModelVariant currVar = (StateModelVariant)partDefinition.apply().getFirst();
                List<class_2960> models = currVar.model().method_12832().contains("block/fire_floor") ? modelEntry.floor : (currVar.model().method_12832().contains("block/fire_side") ? modelEntry.side : modelEntry.up);
                ObjectArrayList newVariants = new ObjectArrayList();
                for (class_2960 model : models) {
                    newVariants.add(new StateModelVariant(model, currVar.x(), currVar.y(), currVar.uvlock(), currVar.weigth()));
                }
                StateMultiPartDefinition.When when = partDefinition.when();
                Object2ObjectArrayMap base = null;
                if (when.base().isPresent()) {
                    base = new Object2ObjectArrayMap();
                    base.put("age", String.valueOf(modelEntry.age));
                    base.putAll((Map)when.base().get());
                }
                ObjectArrayList or = null;
                if (when.or().isPresent()) {
                    or = new ObjectArrayList();
                    for (Map stringMap : (List)when.or().get()) {
                        Object2ObjectArrayMap orMap = new Object2ObjectArrayMap(stringMap);
                        orMap.put((Object)"age", (Object)String.valueOf(modelEntry.age));
                        or.add(orMap);
                    }
                }
                StateMultiPartDefinition.When newWhen = new StateMultiPartDefinition.When(Optional.ofNullable(or), Optional.empty(), Optional.ofNullable(base));
                list.add(new StateMultiPartDefinition(newWhen, (List)newVariants));
            }
        }
        return list;
    }

    public static class Config {
        public boolean hurt = true;
        public boolean tick = true;
        public boolean lightPortal = true;
        public float damage = 1.0f;
        public List<class_2960> blocks;
        public List<class_2960> blockTags;
    }

    record FireModelEntry(@Nullable class_2960 id, int age, List<class_2960> up, List<class_2960> side, List<class_2960> floor) {
        public static FireModelEntry DEFAULT = new FireModelEntry(null, 0, List.of(class_2960.method_60656((String)"block/fire_up0"), class_2960.method_60656((String)"block/fire_up1"), class_2960.method_60656((String)"block/fire_up_alt0"), class_2960.method_60656((String)"block/fire_up_alt1")), List.of(class_2960.method_60656((String)"block/fire_side0"), class_2960.method_60656((String)"block/fire_side1"), class_2960.method_60656((String)"block/fire_side_alt0"), class_2960.method_60656((String)"block/fire_side_alt1")), List.of(class_2960.method_60656((String)"block/fire_floor0"), class_2960.method_60656((String)"block/fire_floor1")));
    }
}

