/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.mixin.accessor.PrimedTntAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tnt
implements BlockBehaviour<Config> {
    private final Config config;

    public Tnt(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(class_1792 item, final class_2248 block, BehaviourHolder behaviourHolder) {
        class_2315.method_10009((class_1935)block, (class_2357)new class_2347(){

            @NotNull
            protected class_1799 method_10135(class_2342 blockSource, class_1799 itemStack) {
                class_3218 serverLevel = blockSource.comp_1967();
                class_2338 blockPos = blockSource.comp_1968().method_10093((class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918));
                Tnt.this.explode((class_1937)serverLevel, blockPos, null, block.method_9564());
                serverLevel.method_33596(null, (class_6880)class_5712.field_28738, blockPos);
                itemStack.method_7934(1);
                return itemStack;
            }
        });
    }

    @Override
    public void onPlace(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState2.method_27852(blockState.method_26204()) && level.method_49803(blockPos)) {
            this.explode(level, blockPos, null, blockState);
            level.method_8650(blockPos, false);
        }
    }

    @Override
    public void neighborChanged(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, @Nullable class_9904 orientation, boolean bl) {
        if (level.method_49803(blockPos)) {
            this.explode(level, blockPos, null, blockState);
            level.method_8650(blockPos, false);
        }
    }

    @Override
    public void playerWillDestroy(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        if (!level.method_8608() && !player.method_68878() && this.config.unstable.getValue(blockState).booleanValue()) {
            this.explode(level, blockPos, null, blockState);
        }
    }

    @Override
    public void wasExploded(class_3218 serverLevel, class_2338 blockPos, class_1927 explosion) {
        class_2680 bs = serverLevel.method_8320(blockPos);
        Integer i = this.config.fuseTime.getValue(bs);
        this.explode((class_1937)serverLevel, blockPos, null, serverLevel.method_8320(blockPos), serverLevel.field_9229.method_43048(i / 4) + i / 8);
    }

    @Override
    public class_1269 useItemOn(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (!itemStack.method_31574(class_1802.field_8884) && !itemStack.method_31574(class_1802.field_8814)) {
            return null;
        }
        this.explode(level, blockPos, (class_1309)player, blockState);
        level.method_8652(blockPos, class_2246.field_10124.method_9564(), 11);
        class_1792 item = itemStack.method_7909();
        if (!itemStack.method_7963()) {
            itemStack.method_57008(1, (class_1309)player);
        } else {
            itemStack.method_71012(1, (class_1309)player, interactionHand);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        return class_1269.field_5812;
    }

    @Override
    public void onProjectileHit(class_1937 level, class_2680 blockState, class_3965 blockHitResult, class_1676 projectile) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2338 blockPos = blockHitResult.method_17777();
            class_1297 entity = projectile.method_24921();
            if (projectile.method_5809() && projectile.method_36971(serverLevel, blockPos)) {
                this.explode(level, blockPos, entity instanceof class_1309 ? (class_1309)entity : null, blockState);
                level.method_8650(blockPos, false);
            }
        }
    }

    @Override
    public boolean dropFromExplosion(class_1927 explosion) {
        return false;
    }

    public void explode(class_1937 level, class_2338 blockPos, @Nullable class_1309 livingEntity, class_2680 bs, int fuse) {
        if (!level.method_8608()) {
            bs = bs == null ? level.method_8320(blockPos) : bs;
            class_1541 tntEntity = new class_1541(level, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, livingEntity);
            tntEntity.method_6967(fuse);
            ((PrimedTntAccessor)tntEntity).setExplosionPower(this.config.explosionPower.getValue(bs).floatValue());
            tntEntity.method_54455(bs);
            level.method_8649((class_1297)tntEntity);
            level.method_43128(null, tntEntity.method_23317(), tntEntity.method_23318(), tntEntity.method_23321(), class_3414.method_47908((class_2960)this.config.primeSound.getValue(bs)), class_3419.field_15245, 1.0f, 1.0f);
            level.method_33596((class_1297)livingEntity, (class_6880)class_5712.field_28727, blockPos);
        }
    }

    public void explode(class_1937 level, class_2338 blockPos, @Nullable class_1309 livingEntity, class_2680 bs) {
        this.explode(level, blockPos, livingEntity, bs, this.config.fuseTime.getValue(bs == null ? level.method_8320(blockPos) : bs));
    }

    public static class Config {
        public BlockStateMappedProperty<Boolean> unstable = BlockStateMappedProperty.of(false);
        public BlockStateMappedProperty<Float> explosionPower = BlockStateMappedProperty.of(Float.valueOf(4.0f));
        public BlockStateMappedProperty<Integer> fuseTime = BlockStateMappedProperty.of(80);
        public BlockStateMappedProperty<class_2960> primeSound = BlockStateMappedProperty.of(class_3417.field_15079.comp_3319());
    }
}

