/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import com.google.common.collect.BiMap;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.api.behaviour.ContainerLike;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.block.AbstractHorizontalFacing;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.mixin.accessor.ChestBlockInvoker;
import de.tomalbrc.filament.registry.OxidizableRegistry;
import de.tomalbrc.filament.registry.StrippableRegistry;
import de.tomalbrc.filament.util.FilamentContainer;
import de.tomalbrc.filament.util.TextUtil;
import de.tomalbrc.filament.util.Util;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_10225;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1258;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4838;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5953;
import net.minecraft.class_7923;
import net.minecraft.class_9288;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedChest
extends AbstractHorizontalFacing<Config>
implements BlockBehaviour<Config>,
DecorationBehaviour<Config>,
ContainerLike {
    private final Config config;
    public FilamentContainer container;
    public class_5321<class_52> lootTable;
    public long lootTableSeed;
    class_2591<DecorationBlockEntity> TYPE;
    public static class_4732.class_3923<DecorationBlockEntity, Optional<class_1263>> CONTAINER_COMBINER = new class_4732.class_3923<DecorationBlockEntity, Optional<class_1263>>(){

        @NotNull
        public Optional<class_1263> acceptDouble(DecorationBlockEntity container, DecorationBlockEntity container2) {
            return Optional.of(new class_1258((class_1263)((AnimatedChest)container.getOrThrow(Behaviours.ANIMATED_CHEST)).container, (class_1263)((AnimatedChest)container2.getOrThrow(Behaviours.ANIMATED_CHEST)).container));
        }

        @NotNull
        public Optional<class_1263> acceptSingle(DecorationBlockEntity container) {
            return Optional.of(((AnimatedChest)container.getOrThrow(Behaviours.ANIMATED_CHEST)).container);
        }

        @NotNull
        public Optional<class_1263> acceptNone() {
            return Optional.empty();
        }
    };
    public static class_4732.class_3923<DecorationBlockEntity, Optional<class_3908>> MENU_PROVIDER_COMBINER = new class_4732.class_3923<DecorationBlockEntity, Optional<class_3908>>(){

        @NotNull
        public Optional<class_3908> acceptDouble(DecorationBlockEntity chestBlockEntity, DecorationBlockEntity chestBlockEntity2) {
            final AnimatedChest c1 = (AnimatedChest)chestBlockEntity.getOrThrow(Behaviours.ANIMATED_CHEST);
            final AnimatedChest c2 = (AnimatedChest)chestBlockEntity2.getOrThrow(Behaviours.ANIMATED_CHEST);
            class_1258 container = new class_1258((class_1263)c1.container, (class_1263)c2.container);
            return Optional.of(new class_3908(){
                final /* synthetic */ class_1263 val$container;
                {
                    this.val$container = class_12632;
                }

                @Nullable
                public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                    c1.container.method_54873(inventory.field_7546);
                    c2.container.method_54873(inventory.field_7546);
                    if (c1.canOpen(player) && c2.canOpen(player)) {
                        return Util.createMenu(this.val$container, id, inventory, player);
                    }
                    return null;
                }

                @NotNull
                public class_2561 method_5476() {
                    class_2561 cname = c1.customName();
                    return cname != null && c1.showCustomName() ? cname : TextUtil.formatText(c1.config.nameDouble);
                }
            });
        }

        @NotNull
        public Optional<class_3908> acceptSingle(DecorationBlockEntity chestBlockEntity) {
            final AnimatedChest c1 = (AnimatedChest)chestBlockEntity.getOrThrow(Behaviours.ANIMATED_CHEST);
            final FilamentContainer container = c1.container;
            class_3908 menuProvider = new class_3908(){

                @Nullable
                public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                    if (c1.canOpen(player)) {
                        return Util.createMenu((class_1263)container, id, inventory, player);
                    }
                    return null;
                }

                @NotNull
                public class_2561 method_5476() {
                    class_2561 cname = c1.customName();
                    return cname != null && c1.showCustomName() ? cname : TextUtil.formatText(c1.config.name);
                }
            };
            return Optional.of(menuProvider);
        }

        @NotNull
        public Optional<class_3908> acceptNone() {
            return Optional.empty();
        }
    };

    public AnimatedChest(Config config) {
        super(null);
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(class_1792 item, class_2248 block, BehaviourHolder behaviourHolder) {
        class_2960 id = block.method_40142().method_40237().method_29177();
        this.TYPE = (class_2591)class_7923.field_41181.method_63535(id);
    }

    @Override
    public void init(DecorationBlockEntity blockEntity) {
        DecorationBehaviour.super.init(blockEntity);
        this.TYPE = blockEntity.method_11017();
        this.container = new FilamentContainer(blockEntity, this.config.size, this.config.purge);
        class_1799 item = blockEntity.getItem();
        if (item.method_57826(class_9334.field_49622)) {
            Objects.requireNonNull((class_9288)blockEntity.getItem().method_58694(class_9334.field_49622)).method_57492(this.container.field_5828);
        }
        if (this.config.openAnimation != null) {
            this.container.setOpenCallback(() -> blockEntity.getOrCreateHolder().playAnimation(this.config.openAnimation, 2));
        }
        if (this.config.closeAnimation != null) {
            this.container.setCloseCallback(() -> blockEntity.getOrCreateHolder().playAnimation(this.config.closeAnimation, 2));
        }
    }

    @Override
    public void destroy(DecorationBlockEntity decorationBlockEntity, boolean dropItem) {
        this.container.setValid(false);
        if (!this.config.canPickup) {
            class_1264.method_5451((class_1937)decorationBlockEntity.method_10997(), (class_2338)decorationBlockEntity.method_11016(), (class_1263)this.container);
        }
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        super.createBlockStateDefinition(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12506});
    }

    protected class_2680 updateShapeSimple(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2680 blockState2) {
        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        if (AnimatedChest.canConnectTo(blockState, blockState2) && direction.method_10166().method_10179()) {
            class_2745 chestType = (class_2745)blockState2.method_11654((class_2769)class_2281.field_10770);
            if (blockState.method_11654((class_2769)class_2281.field_10770) == class_2745.field_12569 && chestType != class_2745.field_12569 && blockState.method_11654((class_2769)class_2281.field_10768) == blockState2.method_11654((class_2769)class_2281.field_10768) && class_2281.method_9758((class_2680)blockState2) == direction.method_10153()) {
                return (class_2680)blockState.method_11657((class_2769)class_2281.field_10770, (Comparable)chestType.method_11824());
            }
        } else if (class_2281.method_9758((class_2680)blockState) == direction) {
            return (class_2680)blockState.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12569);
        }
        return blockState;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        class_2680 blockState3 = this.updateShapeSimple(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockState2);
        if (AnimatedChest.canConnectTo(blockState, blockState2) && !((class_2745)blockState3.method_11654((class_2769)class_2281.field_10770)).equals((Object)class_2745.field_12569) && class_2281.method_9758((class_2680)blockState3) == direction) {
            return blockState2.method_26204().method_34725(blockState3);
        }
        return blockState3;
    }

    public static boolean canConnectTo(class_2680 state1, class_2680 state2) {
        return state1.method_27852(state2.method_26204()) || OxidizableRegistry.sameOxidizable(state1.method_26204(), state2.method_26204()) || StrippableRegistry.get(state1.method_26204()) == state2.method_26204() || StrippableRegistry.get(state2.method_26204()) == state1.method_26204();
    }

    @NotNull
    protected class_2680 getStateForPlacementSimple(class_2680 state, class_1750 blockPlaceContext) {
        class_2350 direction3;
        class_2745 chestType = class_2745.field_12569;
        class_2350 direction = blockPlaceContext.method_8042().method_10153();
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPlaceContext.method_8037());
        boolean bl = blockPlaceContext.method_8046();
        class_2350 direction2 = blockPlaceContext.method_8038();
        if (direction2.method_10166().method_10179() && bl && (direction3 = this.candidatePartnerFacing(state, blockPlaceContext, direction2.method_10153())) != null && direction3.method_10166() != direction2.method_10166()) {
            direction = direction3;
            class_2745 class_27452 = chestType = direction3.method_10160() == direction2.method_10153() ? class_2745.field_12571 : class_2745.field_12574;
        }
        if (chestType == class_2745.field_12569 && !bl) {
            if (direction == this.candidatePartnerFacing(state, blockPlaceContext, direction.method_10170())) {
                chestType = class_2745.field_12574;
            } else if (direction == this.candidatePartnerFacing(state, blockPlaceContext, direction.method_10160())) {
                chestType = class_2745.field_12571;
            }
        }
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2281.field_10768, (Comparable)direction)).method_11657((class_2769)class_2281.field_10770, (Comparable)chestType)).method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 state, class_1750 blockPlaceContext) {
        class_2680 blockState2;
        class_2680 blockState = this.getStateForPlacementSimple(state, blockPlaceContext);
        if (((BehaviourHolder)state.method_26204()).has(Behaviours.OXIDIZABLE) && !(blockState2 = blockPlaceContext.method_8045().method_8320(blockPlaceContext.method_8037().method_10093(class_2281.method_9758((class_2680)blockState)))).method_26215() && blockState2.method_26204() instanceof DecorationBlock && !((class_2745)blockState2.method_11654((class_2769)class_2281.field_10770)).equals((Object)class_2745.field_12569)) {
            BehaviourHolder placed = (BehaviourHolder)blockState.method_26204();
            BehaviourHolder other = (BehaviourHolder)blockState2.method_26204();
            class_2680 maybeFinal = blockState;
            class_2680 blockStateOther = blockState2;
            if (placed.has(Behaviours.STRIPPABLE) != other.has(Behaviours.STRIPPABLE)) {
                blockStateOther = this.unwaxed(placed, blockState).orElse(blockState2);
                maybeFinal = this.unwaxed(other, blockState2).orElse(maybeFinal);
            }
            class_2248 block = maybeFinal.method_26204();
            if (placed.has(Behaviours.OXIDIZABLE) && other.has(Behaviours.OXIDIZABLE) && placed.getOrThrow(Behaviours.OXIDIZABLE).getConfig().weatherState.ordinal() <= other.getOrThrow(Behaviours.OXIDIZABLE).getConfig().weatherState.ordinal()) {
                block = blockStateOther.method_26204();
            }
            return block.method_34725(blockState2);
        }
        return blockState;
    }

    private Optional<class_2680> unwaxed(BehaviourHolder copperChestBlock, class_2680 blockState) {
        if (!copperChestBlock.has(Behaviours.STRIPPABLE)) {
            return Optional.of(blockState);
        }
        return Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)blockState.method_26204())).map(block -> block.method_34725(blockState));
    }

    @Nullable
    private class_2350 candidatePartnerFacing(class_2680 state, class_1750 blockPlaceContext, class_2350 direction) {
        class_2680 blockState = blockPlaceContext.method_8045().method_8320(blockPlaceContext.method_8037().method_10093(direction));
        return blockState.method_27852(state.method_26204()) && blockState.method_11654((class_2769)class_2281.field_10770) == class_2745.field_12569 ? (class_2350)blockState.method_11654((class_2769)class_2281.field_10768) : null;
    }

    @Override
    public void write(class_11372 output, DecorationBlockEntity decorationBlockEntity) {
        if (!this.container.method_54872(output)) {
            class_1262.method_5426((class_11372)output.method_71461("Container"), (class_2371)this.container.field_5828);
        }
    }

    @Override
    public void read(class_11368 input, DecorationBlockEntity decorationBlockEntity) {
        if (!this.container.method_54871(input)) {
            input.method_71420("Container").ifPresent(x -> class_1262.method_5429((class_11368)x, (class_2371)this.container.field_5828));
        }
    }

    @Override
    public Optional<Boolean> hasAnalogOutputSignal(class_2680 blockState) {
        return Optional.of(Boolean.TRUE);
    }

    @Override
    public int getAnalogOutputSignal(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        return class_1703.method_7618((class_1263)this.getContainer(blockState, level, blockPos, this.config.ignoreBlock));
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_3908 menuProvider = this.getMenuProvider(blockState, level, blockPos);
            if (menuProvider != null) {
                player.method_17355(menuProvider);
                player.method_7259(class_3468.field_15419.method_14956((Object)class_3468.field_15395));
                if (this.config.angerPiglins) {
                    class_4838.method_24733((class_3218)serverLevel, (class_1657)player, (boolean)true);
                }
            }
        }
        return class_1269.field_5812;
    }

    @Nullable
    protected class_3908 getMenuProvider(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        return ((Optional)this.combine(blockState, level, blockPos, this.config.ignoreBlock).apply(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    @Override
    public void affectNeighborsAfterRemoval(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, boolean bl) {
        class_1264.method_66221((class_2680)blockState, (class_1937)serverLevel, (class_2338)blockPos);
    }

    @Override
    public class_1799 getCloneItemStack(class_1799 itemStack, class_4538 levelReader, class_2338 blockPos, class_2680 blockState, boolean includeData) {
        return itemStack;
    }

    @Override
    public void applyImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_9473 dataComponentGetter) {
        ((class_9288)dataComponentGetter.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.container.field_5828);
        class_9297 seededContainerLoot = (class_9297)dataComponentGetter.method_58694(class_9334.field_49626);
        if (seededContainerLoot != null) {
            this.lootTable = seededContainerLoot.comp_2414();
            this.lootTableSeed = seededContainerLoot.comp_2415();
        }
    }

    @Override
    public void collectImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493((List)this.container.field_5828));
        if (this.lootTable != null) {
            builder.method_57840(class_9334.field_49626, (Object)new class_9297(this.lootTable, this.lootTableSeed));
        }
    }

    @Override
    public void removeComponentsFromTag(DecorationBlockEntity decorationBlockEntity, class_11372 valueOutput) {
        valueOutput.method_71478("LootTable");
        valueOutput.method_71478("LootTableSeed");
    }

    @Override
    public void modifyDrop(DecorationBlockEntity blockEntity, class_1799 itemStack) {
        if (this.config.canPickup) {
            itemStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(this.container.method_54454()));
        }
    }

    @Override
    public class_2561 customName() {
        return (class_2561)this.container.getBlockEntity().method_58693().method_58694(class_9334.field_49631);
    }

    @Override
    @Nullable
    public class_1263 container() {
        return this.getContainer(this.container.getBlockEntity().method_11010(), this.container.getBlockEntity().method_10997(), this.container.getBlockEntity().method_11016(), this.config.ignoreBlock);
    }

    @Override
    public boolean showCustomName() {
        return this.config.showCustomName;
    }

    @Override
    public boolean hopperDropperSupport() {
        return this.config.hopperDropperSupport;
    }

    @Override
    public boolean canPickUp() {
        return this.config.canPickup;
    }

    @Override
    public void setLootTable(@Nullable class_5321<class_52> resourceKey) {
        this.lootTable = resourceKey;
    }

    @Override
    @Nullable
    public class_5321<class_52> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public class_1263 getContainer(class_2680 blockState, class_1937 level, class_2338 blockPos, boolean ignoreBlock) {
        return ((Optional)this.combine(blockState, level, blockPos, ignoreBlock).apply(CONTAINER_COMBINER)).orElse(null);
    }

    public boolean isBlockedAt(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState) {
        class_2350 dir = this.config.blockDirection;
        if (dir.method_10166().method_10179()) {
            float localRot = dir.method_10144();
            float facing = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            dir = class_2350.method_10150((double)(facing - localRot));
        }
        return levelAccessor.method_8320(blockPos.method_10093(dir)).method_26212((class_1922)levelAccessor, blockPos) || dir == class_2350.field_11036 && ChestBlockInvoker.isCatSittingOnChest(levelAccessor, blockPos);
    }

    public class_4732.class_4734<DecorationBlockEntity> combine(class_2680 blockState, class_1937 level, class_2338 blockPos, boolean ignoreBlock) {
        BiPredicate<class_1936, class_2338> biPredicate = ignoreBlock ? (levelAccessor, blockPosx) -> false : (levelAccessor, pos) -> this.isBlockedAt((class_1936)levelAccessor, (class_2338)pos, blockState);
        return class_4732.method_24173(this.TYPE, class_2281::method_24169, class_2281::method_9758, (class_2769)class_2281.field_10768, (class_2680)blockState, (class_1936)level, (class_2338)blockPos, biPredicate);
    }

    public boolean canOpen(class_1657 player) {
        return !player.method_7325();
    }

    public static class Config {
        public String name = "Chest";
        public String nameDouble = "Double Chest";
        public int size = 9;
        public boolean purge = false;
        public String openAnimation = null;
        public String closeAnimation = null;
        public boolean canPickup = false;
        public boolean hopperDropperSupport = true;
        public boolean showCustomName = true;
        public boolean ignoreBlock = false;
        public class_2350 blockDirection = class_2350.field_11036;
        public boolean angerPiglins = true;
    }
}

