/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.entity.goal;

import de.tomalbrc.filament.api.behaviour.EntityBehaviour;
import de.tomalbrc.filament.entity.FilamentMob;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4051;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookAtMobGoal
implements EntityBehaviour<Config> {
    private final Config config;

    public LookAtMobGoal(Config config) {
        this.config = config;
    }

    @Override
    public void registerGoals(FilamentMob mob) {
        EntityBehaviour.super.registerGoals(mob);
        mob.getGoalSelector().method_6277(this.config.priority, (class_1352)new LookAtMobGoalImpl((class_1308)mob, (class_1299)class_7923.field_41177.method_63535(this.config.target), this.config.lookDistance, this.config.probability, this.config.onlyHorizontal));
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        int priority;
        class_2960 target;
        float lookDistance;
        float probability;
        boolean onlyHorizontal;
    }

    public static class LookAtMobGoalImpl
    extends class_1352 {
        protected final class_1308 mob;
        @Nullable
        protected class_1297 lookAt;
        protected final float lookDistance;
        private int lookTime;
        protected final float probability;
        private final boolean onlyHorizontal;
        protected final class_1299<?> lookAtType;
        protected final class_4051 lookAtContext;

        public LookAtMobGoalImpl(class_1308 mob, class_1299<?> entityType, float f, float g, boolean bl) {
            this.mob = mob;
            this.lookAtType = entityType;
            this.lookDistance = f;
            this.probability = g;
            this.onlyHorizontal = bl;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
            if (entityType == class_1299.field_6097) {
                Predicate predicate = class_1301.method_5913((class_1297)mob);
                this.lookAtContext = class_4051.method_36626().method_18418((double)f).method_18420((livingEntity, serverLevel) -> predicate.test(livingEntity));
            } else {
                this.lookAtContext = class_4051.method_36626().method_18418((double)f);
            }
        }

        public boolean method_6264() {
            if (this.mob.method_59922().method_43057() >= this.probability) {
                return false;
            }
            if (this.mob.method_5968() != null) {
                this.lookAt = this.mob.method_5968();
            }
            class_3218 serverLevel = LookAtMobGoalImpl.method_64451((class_1297)this.mob);
            this.lookAt = this.lookAtType == class_1299.field_6097 ? serverLevel.method_64389(this.lookAtContext, (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321()) : serverLevel.method_64393(this.mob.method_37908().method_8390(class_1308.class, this.mob.method_5829().method_1009((double)this.lookDistance, 3.0, (double)this.lookDistance), livingEntity -> livingEntity.method_5864() == this.lookAtType), this.lookAtContext, (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321());
            return this.lookAt != null;
        }

        public boolean method_6266() {
            if (!this.lookAt.method_5805()) {
                return false;
            }
            if (this.mob.method_5858(this.lookAt) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0;
        }

        public void method_6269() {
            this.lookTime = this.method_38847(40 + this.mob.method_59922().method_43048(40));
        }

        public void method_6270() {
            this.lookAt = null;
        }

        public void method_6268() {
            if (this.lookAt.method_5805()) {
                double d = this.onlyHorizontal ? this.mob.method_23320() : this.lookAt.method_23320();
                this.mob.method_5988().method_20248(this.lookAt.method_23317(), d, this.lookAt.method_23321());
                --this.lookTime;
            }
        }
    }
}

