/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.ItemPredicateModelProvider;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.generator.ItemAssetGenerator;
import de.tomalbrc.filament.item.FilamentItem;
import de.tomalbrc.filament.mixin.accessor.CrossbowItemInvoker;
import de.tomalbrc.filament.mixin.accessor.ProjectileWeaponItemInvoker;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1744;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9278;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Crossbow
implements ItemBehaviour<Config>,
ItemPredicateModelProvider {
    private final class_1764.class_9693 sounds;
    private final Config config;
    private boolean startSoundPlayed;
    private boolean midLoadSoundPlayed;

    public Crossbow(Config config) {
        this.config = config;
        this.sounds = new class_1764.class_9693(Optional.of(class_7923.field_41172.method_47983((Object)class_3414.method_47908((class_2960)config.loadingStartSound))), Optional.of(class_7923.field_41172.method_47983((Object)class_3414.method_47908((class_2960)config.loadingMiddleSound))), Optional.of(class_7923.field_41172.method_47983((Object)class_3414.method_47908((class_2960)config.loadingEndSound))));
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void modifyPolymerItemStack(Map<String, class_2960> models, class_1799 original, class_1799 itemStack, class_1836 tooltipType, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        itemStack.method_57379(class_9334.field_49649, (Object)((class_9278)original.method_58694(class_9334.field_49649)));
    }

    @Override
    public class_1269 use(class_1792 item, class_1937 level, class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        class_9278 chargedProjectiles = (class_9278)itemStack.method_58694(class_9334.field_49649);
        if (chargedProjectiles != null && !chargedProjectiles.method_57442()) {
            this.performShooting(level, (class_1309)player, interactionHand, itemStack, Crossbow.getShootingPower(chargedProjectiles) * this.config.powerMultiplier, 1.0f, null);
            return class_1269.field_21466;
        }
        if (!this.getProjectile(player).method_7960()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            player.method_6019(interactionHand);
            return class_1269.field_21466;
        }
        return class_1269.field_5814;
    }

    private static float getShootingPower(class_9278 chargedProjectiles) {
        return chargedProjectiles.method_57438(class_1802.field_8639) ? 1.6f : 3.15f;
    }

    @Override
    public boolean releaseUsing(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int i) {
        class_3222 serverPlayer;
        int j = this.getUseDuration(itemStack, livingEntity).orElseThrow() - i;
        float f = CrossbowItemInvoker.invokeGetPowerForTime(j, itemStack, livingEntity);
        if (f >= 1.0f && !class_1764.method_7781((class_1799)itemStack) && livingEntity instanceof class_3222 && this.tryLoadProjectiles((class_1657)(serverPlayer = (class_3222)livingEntity), itemStack)) {
            class_1764.class_9693 chargingSounds = this.getChargingSounds(itemStack);
            chargingSounds.comp_2675().ifPresent(holder -> level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), (class_3414)holder.comp_349(), livingEntity.method_5634(), 1.0f, 1.0f / (level.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f));
            return true;
        }
        return false;
    }

    private boolean tryLoadProjectiles(class_1657 shooter, class_1799 weapon) {
        List<class_1799> list = ProjectileWeaponItemInvoker.invokeDraw(weapon, this.getProjectile(shooter), (class_1309)shooter);
        if (!list.isEmpty()) {
            weapon.method_57379(class_9334.field_49649, (Object)class_9278.method_57441(list));
            return true;
        }
        return false;
    }

    protected void shootProjectile(class_1309 livingEntity, class_1676 projectile, int i, float f, float g, float h, @Nullable class_1309 livingEntity2) {
        Vector3f vector3f;
        if (livingEntity2 != null) {
            double d = livingEntity2.method_23317() - livingEntity.method_23317();
            double e = livingEntity2.method_23321() - livingEntity.method_23321();
            double j = Math.sqrt(d * d + e * e);
            double k = livingEntity2.method_23323(0.3333333333333333) - projectile.method_23318() + j * 0.2;
            vector3f = Crossbow.getProjectileShotVector(livingEntity, new class_243(d, k, e), h);
        } else {
            class_243 vec3 = livingEntity.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(h * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_243 vec32 = livingEntity.method_5828(1.0f);
            vector3f = vec32.method_46409().rotate((Quaternionfc)quaternionf);
        }
        projectile.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), f, g);
        float l = Crossbow.getShotPitch(livingEntity.method_59922(), i);
        livingEntity.method_37908().method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3414.method_47908((class_2960)this.config.shootSound), livingEntity.method_5634(), 1.0f, l);
    }

    private static Vector3f getProjectileShotVector(class_1309 livingEntity, class_243 vec3, float f) {
        Vector3f vector3f = vec3.method_46409().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            class_243 vec32 = livingEntity.method_18864(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec32.method_46409());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(f * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    protected class_1676 createArrow(class_1937 level, class_1309 livingEntity, class_1799 itemStack, class_1799 itemStack2, boolean crit) {
        class_1792 item = itemStack2.method_7909();
        class_1744 arrowItem = item instanceof class_1744 ? (class_1744)item : (class_1744)class_1802.field_8107;
        class_1665 abstractArrow = arrowItem.method_7702(level, itemStack2, livingEntity, itemStack);
        if (crit) {
            abstractArrow.method_7439(true);
        }
        return abstractArrow;
    }

    protected class_1676 createProjectile(class_1937 level, class_1309 livingEntity, class_1799 itemStack, class_1799 itemStack2, boolean bl) {
        if (itemStack2.method_31574(class_1802.field_8639)) {
            return new class_1671(level, itemStack2, (class_1297)livingEntity, livingEntity.method_23317(), livingEntity.method_23320() - (double)0.15f, livingEntity.method_23321(), true);
        }
        class_1676 projectile = this.createArrow(level, livingEntity, itemStack, itemStack2, bl);
        if (projectile instanceof class_1665) {
            class_1665 abstractArrow = (class_1665)projectile;
            abstractArrow.method_7444(class_3417.field_14636);
        }
        return projectile;
    }

    protected int getDurabilityUse(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8639) ? 3 : 1;
    }

    public void performShooting(class_1937 level, class_1309 livingEntity, class_1268 interactionHand, class_1799 itemStack, float f, float g, @Nullable class_1309 livingEntity2) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_9278 chargedProjectiles = (class_9278)itemStack.method_57379(class_9334.field_49649, (Object)class_9278.field_49298);
            if (chargedProjectiles != null && !chargedProjectiles.method_57442()) {
                this.shoot(serverLevel, livingEntity, interactionHand, itemStack, chargedProjectiles.method_57437(), f, g, livingEntity instanceof class_1657, livingEntity2);
                if (livingEntity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)livingEntity;
                    class_174.field_1196.method_9115(serverPlayer, itemStack);
                    serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                }
            }
        }
    }

    protected void shoot(class_3218 serverLevel, class_1309 livingEntity, class_1268 interactionHand, class_1799 itemStack, List<class_1799> list, float f, float g, boolean bl, @Nullable class_1309 livingEntity2) {
        float h = class_1890.method_60118((class_3218)serverLevel, (class_1799)itemStack, (class_1297)livingEntity, (float)0.0f);
        float i = list.size() == 1 ? 0.0f : 2.0f * h / (float)(list.size() - 1);
        float j = (float)((list.size() - 1) % 2) * i / 2.0f;
        float k = 1.0f;
        for (int l = 0; l < list.size(); ++l) {
            class_1799 itemStack2 = list.get(l);
            if (itemStack2.method_7960()) continue;
            float m = j + k * (float)((l + 1) / 2) * i;
            k = -k;
            class_1676 projectile = this.createProjectile((class_1937)serverLevel, livingEntity, itemStack, itemStack2, bl);
            this.shootProjectile(livingEntity, projectile, l, f, g, m, livingEntity2);
            serverLevel.method_8649((class_1297)projectile);
            itemStack.method_7970(this.getDurabilityUse(itemStack2), livingEntity, class_1309.method_56079((class_1268)interactionHand));
            if (itemStack.method_7960()) break;
        }
    }

    private static float getShotPitch(class_5819 randomSource, int i) {
        return i == 0 ? 1.0f : Crossbow.getRandomShotPitch((i & 1) == 1, randomSource);
    }

    private static float getRandomShotPitch(boolean bl, class_5819 randomSource) {
        float f = bl ? 0.63f : 0.43f;
        return 1.0f / (randomSource.method_43057() * 0.5f + 1.8f) + f;
    }

    @Override
    public void onUseTick(class_1937 level, class_1309 livingEntity, class_1799 itemStack, int i) {
        if (!level.method_8608()) {
            class_1764.class_9693 chargingSounds = this.getChargingSounds(itemStack);
            float f = (float)(itemStack.method_7935(livingEntity) - i) / (float)Crossbow.getChargeDuration(itemStack, livingEntity);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                chargingSounds.comp_2673().ifPresent(holder -> level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), (class_3414)holder.comp_349(), class_3419.field_15248, 0.5f, 1.0f));
            }
            if (f >= 0.5f && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                chargingSounds.comp_2674().ifPresent(holder -> level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), (class_3414)holder.comp_349(), class_3419.field_15248, 0.5f, 1.0f));
            }
        }
    }

    @Override
    public Optional<Integer> getUseDuration(class_1799 itemStack, class_1309 livingEntity) {
        return Optional.of(Crossbow.getChargeDuration(itemStack, livingEntity) + 3);
    }

    @Override
    public class_1839 getUseAnimation(class_1799 itemStack) {
        return class_1839.field_8947;
    }

    public static int getChargeDuration(class_1799 itemStack, class_1309 livingEntity) {
        float f = class_1890.method_60159((class_1799)itemStack, (class_1309)livingEntity, (float)1.25f);
        return class_3532.method_15375((float)(f * 20.0f));
    }

    class_1764.class_9693 getChargingSounds(class_1799 itemStack) {
        return class_1890.method_60165((class_1799)itemStack, (class_9331)class_9701.field_51653).orElse(this.sounds);
    }

    @Override
    public boolean useOnRelease(class_1799 itemStack) {
        FilamentItem filamentItem;
        class_1792 class_17922 = itemStack.method_7909();
        return class_17922 instanceof FilamentItem && (filamentItem = (FilamentItem)class_17922).has(Behaviours.CROSSBOW);
    }

    public Predicate<class_1799> supportedProjectiles() {
        return itemStack -> {
            for (class_2960 itemId : this.config.supportedProjectiles) {
                if (!itemStack.method_41406((class_6880)class_7923.field_41178.method_10223(itemId).orElseThrow())) continue;
                return true;
            }
            return false;
        };
    }

    public Predicate<class_1799> supportedHeldProjectiles() {
        return itemStack -> {
            for (class_2960 itemId : this.config.supportedHeldProjectiles) {
                if (!itemStack.method_41406((class_6880)class_7923.field_41178.method_10223(itemId).orElseThrow())) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public void generate(Data<?> data) {
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(resourcePackBuilder -> ItemAssetGenerator.createCrossbow(resourcePackBuilder, data.id(), Objects.requireNonNull(data.itemResource()), data.components().method_57832(class_9334.field_49644) || data.vanillaItem().method_57347().method_57832(class_9334.field_49644)));
    }

    @Override
    public List<String> requiredModels() {
        return List.of("pulling_0", "pulling_1", "pulling_2", "rocket", "arrow");
    }

    public class_1799 getProjectile(class_1657 shooter) {
        Predicate<class_1799> predicate = this.supportedHeldProjectiles();
        class_1799 itemStack = class_1811.method_18815((class_1309)shooter, predicate);
        if (!itemStack.method_7960()) {
            return itemStack;
        }
        predicate = this.supportedProjectiles();
        for (int i = 0; i < shooter.method_31548().method_5439(); ++i) {
            class_1799 itemStack2 = shooter.method_31548().method_5438(i);
            if (!predicate.test(itemStack2)) continue;
            return itemStack2;
        }
        return shooter.method_56992() ? new class_1799((class_1935)class_1802.field_8107) : class_1799.field_8037;
    }

    public static class Config {
        public float powerMultiplier = 1.0f;
        public List<class_2960> supportedProjectiles = ImmutableList.of((Object)class_2960.method_60656((String)"arrow"), (Object)class_2960.method_60656((String)"spectral_arrow"), (Object)class_2960.method_60656((String)"firework_rocket"));
        public List<class_2960> supportedHeldProjectiles = ImmutableList.of((Object)class_2960.method_60656((String)"arrow"), (Object)class_2960.method_60656((String)"spectral_arrow"), (Object)class_2960.method_60656((String)"firework_rocket"));
        public class_2960 shootSound = class_3417.field_15187.comp_3319();
        public class_2960 loadingStartSound = ((class_3414)class_3417.field_14765.comp_349()).comp_3319();
        public class_2960 loadingMiddleSound = ((class_3414)class_3417.field_14860.comp_349()).comp_3319();
        public class_2960 loadingEndSound = ((class_3414)class_3417.field_14626.comp_349()).comp_3319();
    }
}

