/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data.properties;

import java.util.Map;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class BlockStateMappedProperty<T> {
    private T value;
    private Map<String, T> valueMap;

    public BlockStateMappedProperty(T value) {
        this.value = value;
    }

    public BlockStateMappedProperty(Map<String, T> valueMap) {
        this.valueMap = valueMap;
    }

    public static <T> BlockStateMappedProperty<T> of(T value) {
        return new BlockStateMappedProperty<T>(value);
    }

    public static <T> BlockStateMappedProperty<T> empty() {
        return new BlockStateMappedProperty<T>(null);
    }

    public T getValue(class_2680 blockState) {
        if (this.isMap()) {
            for (Map.Entry<String, T> entry : this.valueMap.entrySet()) {
                String[] props = entry.getKey().split(",");
                boolean missmatch = false;
                for (class_2769 property : blockState.method_28501()) {
                    for (String propWithValue : props) {
                        String[] pair = propWithValue.split("=");
                        assert (pair.length == 2);
                        if (!property.method_11899().equals(pair[0]) || property.method_11901(blockState.method_11654(property)).equalsIgnoreCase(pair[1])) continue;
                        missmatch = true;
                    }
                }
                if (missmatch) continue;
                return entry.getValue();
            }
        }
        return this.value;
    }

    public T getOrDefault(class_2680 key, T def) {
        T val = this.getValue(key);
        return val == null ? def : val;
    }

    public boolean isMap() {
        return this.valueMap != null && !this.valueMap.isEmpty();
    }

    public T getRawValue() {
        return this.value;
    }
}

