/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.block.SimpleBlockItem;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.properties.DecorationProperties;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.util.DecorationUtil;
import eu.pb4.polymer.core.api.item.PolymerItem;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class DecorationItem
extends SimpleBlockItem
implements PolymerItem,
BehaviourHolder {
    private final DecorationData decorationData;

    public DecorationItem(class_2248 block, DecorationData decorationData, class_1792.class_1793 properties) {
        super(properties, block, decorationData);
        this.initBehaviours(decorationData.behaviour());
        this.decorationData = decorationData;
    }

    public DecorationData getDecorationData() {
        return this.decorationData;
    }

    @Override
    public void method_67187(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        if (this.decorationData.vanillaItem().method_57347().method_57832(class_9334.field_49644) || this.decorationData.components().method_57832(class_9334.field_49644)) {
            consumer.accept((class_2561)class_2561.method_43470((String)"\u00a79Dyeable"));
        }
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
    }

    @Override
    @NotNull
    public class_1269 method_7884(class_1838 useOnContext) {
        if (this.decorationData == null) {
            Filament.LOGGER.warn("Can't use decoration Item: Missing decoration data!");
            return class_1269.field_5814;
        }
        DecorationProperties properties = this.decorationData.properties();
        boolean replaceable = useOnContext.method_8045().method_8320(useOnContext.method_8037()).method_45474();
        class_2338 blockPos = useOnContext.method_8037();
        class_2350 direction = replaceable ? class_2350.field_11036 : useOnContext.method_8038();
        class_2350 actualDir = direction;
        class_2338 relativeBlockPos = replaceable ? blockPos : blockPos.method_10093(direction);
        class_1657 player = useOnContext.method_8036();
        class_1799 itemStack = useOnContext.method_8041();
        class_1937 level = useOnContext.method_8045();
        boolean propertyPlaceCheck = properties.placement.canPlace(direction);
        if (!propertyPlaceCheck && properties.placement.floor()) {
            direction = class_2350.field_11036;
            propertyPlaceCheck = properties.placement.canPlace(direction);
        }
        if (!propertyPlaceCheck && properties.placement.ceiling()) {
            direction = class_2350.field_11033;
            propertyPlaceCheck = properties.placement.canPlace(direction);
        }
        DecorationBlock block = DecorationRegistry.getDecorationBlock(this.decorationData.id());
        class_2680 blockState = block.method_9605(new class_1750(useOnContext));
        assert (blockState != null);
        float angle = block.getVisualRotationYInDegrees(blockState);
        if (!(this.method_7711().method_45382(level.method_45162()) && player != null && this.mayPlace(player, direction, itemStack, relativeBlockPos) && propertyPlaceCheck)) {
            return class_1269.field_5814;
        }
        if (this.canPlaceAt(level, relativeBlockPos, angle) && itemStack.method_7909() instanceof DecorationItem) {
            DecorationItem.place(itemStack, level, blockState, relativeBlockPos, actualDir, direction, useOnContext);
            player.method_6019(useOnContext.method_20287());
            itemStack.method_57008(1, (class_1309)player);
            class_3414 placeSound = properties.blockBase.method_9564().method_26231().method_10598();
            level.method_8396(null, blockPos, placeSound, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_52422;
        }
        return class_1269.field_5814;
    }

    protected boolean mayPlace(class_1657 player, class_2350 direction, class_1799 itemStack, class_2338 blockPos) {
        return !player.method_37908().method_31606(blockPos) && player.method_7343(blockPos, direction, itemStack);
    }

    private boolean canPlaceAt(class_1937 level, class_2338 blockPos, float angle) {
        if (!level.method_8320(blockPos).method_45474()) {
            return false;
        }
        if (this.decorationData.hasBlocks()) {
            boolean[] canPlace = new boolean[]{true};
            DecorationUtil.forEachRotated(this.decorationData.blocks(), blockPos, angle, blockPos2 -> {
                if (!level.method_8320(blockPos2).method_45474()) {
                    canPlace[0] = false;
                }
            });
            return canPlace[0];
        }
        return true;
    }

    public static void place(class_1799 itemStack, class_1937 level, class_2680 blockState, class_2338 blockPos, class_2350 direction, class_1838 useOnContext) {
        DecorationItem.place(itemStack, level, blockState, blockPos, direction, direction, useOnContext);
    }

    public static void place(class_1799 itemStack, class_1937 level, class_2680 blockState, class_2338 blockPos, class_2350 placeDirection, class_2350 direction, class_1838 useOnContext) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof DecorationItem)) {
            Filament.LOGGER.error("Tried to place non-decoration item as decoration! Item: {}", (Object)itemStack.method_7909().method_40131().method_40237().method_29177());
            return;
        }
        DecorationItem decorationItem = (DecorationItem)class_17922;
        DecorationData decorationData = decorationItem.decorationData;
        if (decorationData.hasBlocks() && decorationData.countBlocks() == 0) {
            Filament.LOGGER.warn("Found block data with potentially invalid blocks for {} while trying to place", (Object)decorationData.id());
        }
        DecorationBlock block = (DecorationBlock)blockState.method_26204();
        if (decorationData.hasBlocks() && decorationData.countBlocks() > 1) {
            DecorationUtil.forEachRotated(decorationData.blocks(), blockPos, block.getVisualRotationYInDegrees(blockState), blockPos2 -> {
                class_2586 patt0$temp;
                level.method_22352(blockPos2, false);
                class_2680 offsetState = block.method_9605(class_1750.method_16355((class_1750)new class_1750(useOnContext), (class_2338)blockPos2, (class_2350)placeDirection));
                level.method_8501(blockPos2, offsetState);
                if (offsetState != null) {
                    offsetState.method_26204().method_9567(level, blockPos2, offsetState, (class_1309)useOnContext.method_8036(), itemStack);
                    if (useOnContext.method_8036() != null) {
                        class_174.field_1191.method_23889((class_3222)useOnContext.method_8036(), blockPos, itemStack);
                    }
                }
                if (decorationData.requiresEntityBlock() && (patt0$temp = level.method_8321(blockPos2)) instanceof DecorationBlockEntity) {
                    DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)patt0$temp;
                    decorationBlockEntity.setMain(new class_2338((class_2382)blockPos2).method_10059((class_2382)blockPos));
                    decorationBlockEntity.setDirection(direction);
                    if (decorationBlockEntity.isMain()) {
                        DecorationItem.updateComponents(decorationBlockEntity, itemStack);
                    }
                    decorationBlockEntity.attach(level.method_8500(blockPos));
                }
            });
        } else {
            class_2586 class_25862;
            level.method_8501(blockPos, blockState);
            blockState.method_26204().method_9567(level, blockPos, blockState, (class_1309)useOnContext.method_8036(), itemStack);
            if (useOnContext.method_8036() != null) {
                class_174.field_1191.method_23889((class_3222)useOnContext.method_8036(), blockPos, itemStack);
            }
            if (decorationData.requiresEntityBlock() && (class_25862 = level.method_8321(blockPos)) instanceof DecorationBlockEntity) {
                DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)class_25862;
                decorationBlockEntity.setMain(class_2338.field_10980);
                decorationBlockEntity.setDirection(direction);
                DecorationItem.updateComponents(decorationBlockEntity, itemStack);
                decorationBlockEntity.attach(level.method_8500(blockPos));
            }
        }
    }

    public static void updateComponents(DecorationBlockEntity blockEntity, class_1799 itemStack) {
        blockEntity.method_58683(itemStack);
        blockEntity.method_5431();
    }
}

