/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.holder;

import de.tomalbrc.filament.decoration.block.DecorationBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.GenericEntityElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public interface FilamentDecorationHolder {
    public <T extends VirtualElement> T addElement(T var1);

    public void removeElement(VirtualElement var1);

    public void tick();

    public class_243 getPos();

    @Nullable
    public HolderAttachment getAttachment();

    public boolean isAnimated();

    public class_1799 getPickResult();

    default public void updateVisualItem(class_1799 newItem) {
    }

    public void playAnimation(class_3222 var1, String var2, int var3, Consumer<class_3222> var4);

    default public void playAnimation(class_3222 serverPlayer, String animation, int priority) {
        this.playAnimation(null, animation, priority, null);
    }

    default public void playAnimation(String animation, int priority) {
        this.playAnimation(null, animation, priority, null);
    }

    default public void playAnimation(class_3222 serverPlayer, String animation) {
        this.playAnimation(serverPlayer, animation, 0, null);
    }

    default public void playAnimation(String animation) {
        this.playAnimation(null, animation, 0, null);
    }

    default public void setYaw(float rotation) {
        for (VirtualElement element : this.asPolymerHolder().getElements()) {
            if (!(element instanceof GenericEntityElement)) continue;
            GenericEntityElement displayElement = (GenericEntityElement)element;
            displayElement.setYaw(rotation - 180.0f);
        }
        if (!this.isAnimated()) {
            this.tick();
        }
    }

    default public ElementHolder asPolymerHolder() {
        return (ElementHolder)this;
    }

    default public void update(class_2680 blockState) {
        HolderAttachment attachment = this.getAttachment();
        if (attachment instanceof BlockAwareAttachment) {
            BlockAwareAttachment blockBoundAttachment = (BlockAwareAttachment)attachment;
            class_2680 attachmentBlockState = blockBoundAttachment.getBlockState();
            DecorationBlock decorationBlock = (DecorationBlock)attachmentBlockState.method_26204();
            this.updateVisualItem(decorationBlock.visualItemStack((class_4538)blockBoundAttachment.getWorld(), blockBoundAttachment.getBlockPos(), blockState));
            this.setYaw(decorationBlock.getVisualRotationYInDegrees(blockState));
            this.tick();
        }
    }
}

