/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.generator;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.data.resource.ResourceProvider;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ConditionItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.RangeDispatchItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.SelectItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.SpecialItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.BooleanProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.FishingRodCastProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.UsingItemProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.numeric.NumericProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.numeric.UseDurationProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.ChargeTypeProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.CustomModelDataStringProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.SelectProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.special.ShieldSpecialModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.special.SpecialModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.DyeTintSource;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1764;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class ItemAssetGenerator {
    public static void createDefault(ResourcePackBuilder builder, class_2960 id, ResourceProvider resourceProvider, boolean tint) {
        class_2960 def = resourceProvider.getModels().get("default");
        BasicItemModel defaultModel = new BasicItemModel(def == null ? resourceProvider.getModels().values().iterator().next() : def, !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        if (resourceProvider.getModels().size() > 1) {
            ObjectArrayList<SelectItemModel.Case<String>> list = ItemAssetGenerator.getCases(resourceProvider, tint);
            builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new SelectItemModel(new SelectItemModel.Switch((SelectProperty)new CustomModelDataStringProperty(0), list), Optional.of(defaultModel)), ItemAsset.Properties.DEFAULT).toBytes());
        } else {
            builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)defaultModel, ItemAsset.Properties.DEFAULT).toBytes());
        }
    }

    @NotNull
    private static ObjectArrayList<SelectItemModel.Case<String>> getCases(ResourceProvider itemResource, boolean tint) {
        ObjectArrayList list = new ObjectArrayList();
        for (Map.Entry<String, class_2960> modelPathEntry : itemResource.getModels().entrySet()) {
            if (modelPathEntry.getKey().equals("default")) continue;
            class_2960 modelId = modelPathEntry.getValue();
            BasicItemModel model = new BasicItemModel(modelId, !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
            list.add((Object)new SelectItemModel.Case(List.of(modelPathEntry.getKey()), (ItemModel)model));
        }
        return list;
    }

    public static void createBow(ResourcePackBuilder builder, class_2960 id, ResourceProvider itemResource, boolean tint) {
        BasicItemModel defaultModel = new BasicItemModel(itemResource.getModels().get("default"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel pulling_0 = new BasicItemModel(itemResource.getModels().get("pulling_0"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel pulling_1 = new BasicItemModel(itemResource.getModels().get("pulling_1"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel pulling_2 = new BasicItemModel(itemResource.getModels().get("pulling_2"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        RangeDispatchItemModel.Builder rangeModelBuilder = RangeDispatchItemModel.builder((NumericProperty)new UseDurationProperty(false)).scale(0.05f);
        rangeModelBuilder.entry(0.65f, (ItemModel)pulling_1);
        rangeModelBuilder.entry(0.9f, (ItemModel)pulling_2);
        rangeModelBuilder.fallback((ItemModel)pulling_0);
        builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new UsingItemProperty(), (ItemModel)rangeModelBuilder.build(), (ItemModel)defaultModel), ItemAsset.Properties.DEFAULT).toBytes());
    }

    public static void createCrossbow(ResourcePackBuilder builder, class_2960 id, ResourceProvider itemResource, boolean tint) {
        BasicItemModel defaultModel = new BasicItemModel(itemResource.getModels().get("default"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel rocket = new BasicItemModel(itemResource.getModels().get("rocket"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel arrow = new BasicItemModel(itemResource.getModels().get("arrow"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel pulling_0 = new BasicItemModel(itemResource.getModels().get("pulling_0"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel pulling_1 = new BasicItemModel(itemResource.getModels().get("pulling_1"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel pulling_2 = new BasicItemModel(itemResource.getModels().get("pulling_2"), !tint ? List.of() : List.of(new DyeTintSource(-1)));
        RangeDispatchItemModel.Builder rangeModelBuilder = RangeDispatchItemModel.builder((NumericProperty)new UseDurationProperty(false)).scale(0.05f);
        rangeModelBuilder.entry(0.58f, (ItemModel)pulling_1);
        rangeModelBuilder.entry(1.0f, (ItemModel)pulling_2);
        rangeModelBuilder.fallback((ItemModel)pulling_0);
        SelectItemModel.Builder notUsed = SelectItemModel.builder((SelectProperty)new ChargeTypeProperty());
        notUsed.withCase((Object)class_1764.class_10393.field_55207, (ItemModel)arrow);
        notUsed.withCase((Object)class_1764.class_10393.field_55208, (ItemModel)rocket);
        notUsed.fallback((ItemModel)defaultModel);
        builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new UsingItemProperty(), (ItemModel)rangeModelBuilder.build(), (ItemModel)notUsed.build()), ItemAsset.Properties.DEFAULT).toBytes());
    }

    public static void createShield(ResourcePackBuilder builder, class_2960 id, ResourceProvider itemResource) {
        SpecialItemModel defaultModel = new SpecialItemModel(itemResource.getModels().get("default"), (SpecialModel)new ShieldSpecialModel());
        SpecialItemModel blocking = new SpecialItemModel(itemResource.getModels().get("blocking"), (SpecialModel)new ShieldSpecialModel());
        builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new UsingItemProperty(), (ItemModel)blocking, (ItemModel)defaultModel), ItemAsset.Properties.DEFAULT).toBytes());
    }

    public static void createFishingRod(ResourcePackBuilder builder, class_2960 id, ResourceProvider itemResource, boolean tint) {
        BasicItemModel defaultModel = new BasicItemModel(itemResource.getModels().get("default"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel cast = new BasicItemModel(itemResource.getModels().get("cast"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new FishingRodCastProperty(), (ItemModel)cast, (ItemModel)defaultModel), ItemAsset.Properties.DEFAULT).toBytes());
    }

    public static void createTrident(ResourcePackBuilder builder, class_2960 id, ResourceProvider itemResource, boolean tint) {
        BasicItemModel defaultModel = new BasicItemModel(itemResource.getModels().get("default"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        BasicItemModel throwing = new BasicItemModel(itemResource.getModels().get("throwing"), !tint ? List.of() : List.of(new DyeTintSource(0xFFFFFF)));
        builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new UsingItemProperty(), (ItemModel)throwing, (ItemModel)defaultModel), ItemAsset.Properties.DEFAULT).toBytes());
    }

    public static void createTrimModels(ResourcePackBuilder builder, class_2960 id, ResourceProvider itemResource, boolean tint) {
        Gson gson = new Gson();
        JsonObject root = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("type", "select");
        JsonArray cases = new JsonArray();
        for (Map.Entry<String, class_2960> entry : itemResource.getModels().entrySet()) {
            if (entry.getKey().equals("default")) continue;
            JsonObject caseObj = new JsonObject();
            JsonObject caseModel = new JsonObject();
            caseModel.addProperty("type", "model");
            caseModel.addProperty("model", entry.getValue().method_45138("item/").toString());
            if (tint) {
                JsonArray tints = new JsonArray();
                JsonObject tintObj = new JsonObject();
                tintObj.addProperty("type", "dye");
                tintObj.addProperty("default", (Number)0xFFFFFF);
                tints.add((JsonElement)tintObj);
                caseModel.add("tints", (JsonElement)tints);
            }
            caseObj.add("model", (JsonElement)caseModel);
            caseObj.addProperty("when", entry.getKey());
            cases.add((JsonElement)caseObj);
        }
        model.add("cases", (JsonElement)cases);
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "model");
        fallback.addProperty("model", itemResource.getModels().get("default").toString());
        if (tint) {
            JsonArray tints = new JsonArray();
            JsonObject tintObj = new JsonObject();
            tintObj.addProperty("type", "dye");
            tintObj.addProperty("default", (Number)0xFFFFFF);
            tints.add((JsonElement)tintObj);
            fallback.add("tints", (JsonElement)tints);
        }
        model.add("fallback", (JsonElement)fallback);
        model.addProperty("property", "trim_material");
        root.add("model", (JsonElement)model);
        String jsonOutput = gson.toJson((JsonElement)root);
        builder.addData(AssetPaths.itemAsset((class_2960)id), jsonOutput.getBytes(StandardCharsets.UTF_8));
    }

    public static void createItemModels(class_2960 id, ItemResource itemResource) {
        if (itemResource.couldGenerate()) {
            for (Map.Entry<String, Map<String, class_2960>> entry : itemResource.textures().entrySet()) {
                class_2960 modelId = id.method_45138("item/").method_48331("_" + entry.getKey());
                PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(builder -> {
                    JsonObject object = new JsonObject();
                    object.add("parent", (JsonElement)new JsonPrimitive(itemResource.parent().method_12836().equals("minecraft") ? itemResource.parent().method_12832() : itemResource.parent().toString()));
                    JsonObject textures = new JsonObject();
                    for (Map.Entry texturesMapEntry : ((Map)entry.getValue()).entrySet()) {
                        textures.add((String)texturesMapEntry.getKey(), (JsonElement)new JsonPrimitive(((class_2960)texturesMapEntry.getValue()).method_12836().equals("minecraft") ? ((class_2960)texturesMapEntry.getValue()).method_12832() : ((class_2960)texturesMapEntry.getValue()).toString()));
                    }
                    object.add("textures", (JsonElement)textures);
                    builder.addData("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json", Json.GSON.toJson((JsonElement)object).getBytes(StandardCharsets.UTF_8));
                });
                itemResource.getModels().put(entry.getKey(), modelId);
            }
        }
    }
}

