/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7659;
import net.minecraft.class_7780;

public class BiomeModifications {
    public static final Map<class_2960, JsonObject> TO_REGISTER = new Object2ObjectOpenHashMap();
    private static boolean locked = false;

    public static void register(InputStream inputStream, class_2960 id) throws IOException {
        JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
        TO_REGISTER.put(id, json);
    }

    public static void addAll(class_7780<class_7659> server) {
        for (Map.Entry<class_2960, JsonObject> element : TO_REGISTER.entrySet()) {
            String type = element.getValue().get("type").getAsJsonPrimitive().getAsString();
            if (!class_2960.method_60654((String)type).equals((Object)AddFeaturesBiomeModifier.ID)) continue;
            DataResult dataResult = AddFeaturesBiomeModifier.CODEC.decoder().decode((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)server.method_45926()), (Object)((JsonElement)element.getValue()));
            AddFeaturesBiomeModifier modifier = (AddFeaturesBiomeModifier)((Pair)dataResult.getOrThrow()).getFirst();
            BiomeModifications.addFeatureModifier(modifier);
        }
        TO_REGISTER.clear();
        locked = true;
    }

    private static void addFeatureModifier(AddFeaturesBiomeModifier modifier) {
        for (class_6880 featureHolder : modifier.features) {
            featureHolder.method_40230().ifPresent(feature -> net.fabricmc.fabric.api.biome.v1.BiomeModifications.addFeature(x -> {
                for (class_6880 biomeHolder : modifier.biomes) {
                    if (!x.getBiomeRegistryEntry().method_55838(biomeHolder)) continue;
                    return true;
                }
                return false;
            }, (class_2893.class_2895)modifier.step, (class_5321)feature));
        }
    }

    public record AddFeaturesBiomeModifier(class_6885<class_1959> biomes, class_6885<class_6796> features, class_2893.class_2895 step) {
        public static final class_2960 ID = class_2960.method_60655((String)"filament", (String)"add_features");
        public static final MapCodec<AddFeaturesBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(AddFeaturesBiomeModifier::biomes), (App)class_6796.field_35731.fieldOf("features").forGetter(AddFeaturesBiomeModifier::features), (App)class_2893.class_2895.field_37680.fieldOf("step").forGetter(AddFeaturesBiomeModifier::step)).apply((Applicative)builder, AddFeaturesBiomeModifier::new));
    }

    public static class BiomeModificationsDataReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"biome_modifications");
        }

        public void method_14491(class_3300 resourceManager) {
            if (locked) {
                return;
            }
            this.load("worldgen/biome_modifications", null, resourceManager, (id, inputStream) -> {
                try {
                    BiomeModifications.register(inputStream, id);
                }
                catch (IOException e) {
                    Filament.LOGGER.error("Failed to load biome modifications \"{}\".", id);
                }
            });
        }
    }
}

