/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.behaviour.AsyncTickingBlockBehaviour;
import de.tomalbrc.filament.block.SimpleBlock;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.server.MinecraftServer;

public class AsyncBlockTicker {
    private static final Map<Long, TickData> TICKING = new ConcurrentHashMap<Long, TickData>();
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();

    public static void tick(MinecraftServer server) {
        CompletableFuture.runAsync(() -> {
            for (TickData entry : TICKING.values()) {
                AsyncBlockTicker.tick(entry);
            }
        }, EXECUTOR_SERVICE);
    }

    private static void tick(TickData tickData) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : tickData.block.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof AsyncTickingBlockBehaviour)) continue;
            AsyncTickingBlockBehaviour blockBehaviour = (AsyncTickingBlockBehaviour)((Object)behaviour2);
            class_2680 state = tickData.serverLevel.method_8320(tickData.blockPos);
            if (state.method_26204() != tickData.block) continue;
            blockBehaviour.tickAsync(tickData.serverLevel.method_8320(tickData.blockPos), tickData.serverLevel, tickData.blockPos, tickData.serverLevel.field_9229);
        }
    }

    public static void add(class_2338 pos, SimpleBlock block, class_3218 serverLevel) {
        TICKING.put(pos.method_10063(), new TickData(pos, block, serverLevel, (Map<DataKey, Object>)new Reference2ObjectOpenHashMap()));
    }

    public static void add(class_2338 pos, SimpleBlock block, class_3218 serverLevel, Map<DataKey, Object> userData) {
        TICKING.put(pos.method_10063(), new TickData(pos, block, serverLevel, userData));
    }

    public static void remove(class_2338 pos) {
        TICKING.remove(pos.method_10063());
    }

    public static void remove(class_3218 serverLevel, class_2818 chunk) {
        LongArraySet s = new LongArraySet();
        for (Map.Entry<Long, TickData> entry : TICKING.entrySet()) {
            if (entry.getValue().serverLevel != serverLevel || !class_4076.method_18682((class_2338)entry.getValue().blockPos).method_18692().equals((Object)chunk.method_12004())) continue;
            s.add(entry.getKey());
        }
        s.forEach(TICKING::remove);
    }

    public static TickData get(class_2338 pos) {
        return TICKING.get(pos.method_10063());
    }

    public static SimpleBlock getBlock(class_2338 pos) {
        TickData v = TICKING.get(pos.method_10063());
        if (v != null) {
            return v.block;
        }
        return null;
    }

    public record TickData(class_2338 blockPos, SimpleBlock block, class_3218 serverLevel, Map<DataKey, Object> userData) {
    }

    public record DataKey(String name) {
    }
}

