/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.AsyncTickingBlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.util.AsyncBlockTicker;
import de.tomalbrc.filament.util.ExecuteUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class AreaExecute
implements BlockBehaviour<Config>,
AsyncTickingBlockBehaviour {
    public static AsyncBlockTicker.DataKey PLAYERS = new AsyncBlockTicker.DataKey("players");
    private Config config;

    public AreaExecute(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void tickAsync(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        class_243 pos;
        List<String> cmds;
        if (!this.config.enabled.getValue(blockState).booleanValue()) {
            return;
        }
        int interval = this.config.interval.getValue(blockState);
        if (interval <= 0) {
            return;
        }
        if (serverLevel.method_8510() % (long)interval != 0L) {
            return;
        }
        class_238 aABB = new class_238(blockPos).method_1014((double)this.config.radius.getValue(blockState).intValue()).method_1012(0.0, this.config.ignoreHeight ? (double)serverLevel.method_31605() : 0.0, 0.0);
        ReferenceOpenHashSet playersInArea = new ReferenceOpenHashSet((Collection)serverLevel.method_18467(class_3222.class, aABB));
        AsyncBlockTicker.TickData tickData = AsyncBlockTicker.get(blockPos);
        Set set = (Set)tickData.userData().computeIfAbsent(PLAYERS, x -> ConcurrentHashMap.newKeySet());
        for (class_3222 user : playersInArea) {
            List<String> repeat;
            if (!set.contains(user)) {
                cmds = this.enterCommands();
                if (cmds != null && user.method_5682() != null && (this.config.permission == null || Permissions.check((class_1297)user, (String)this.config.permission))) {
                    class_243 class_2432 = pos = this.config.atBlock ? blockPos.method_46558() : null;
                    if (this.getConfig().console) {
                        ExecuteUtil.asConsole(user, pos, cmds.toArray(new String[0]));
                    } else {
                        ExecuteUtil.asPlayer(user, pos, cmds.toArray(new String[0]));
                    }
                }
                set.add(user);
            }
            if ((repeat = this.repeatCommands()) == null || user.method_5682() == null || this.config.permission != null && !Permissions.check((class_1297)user, (String)this.config.permission)) continue;
            class_243 class_2433 = pos = this.config.atBlock ? blockPos.method_46558() : null;
            if (this.getConfig().console) {
                ExecuteUtil.asConsole(user, pos, repeat.toArray(new String[0]));
                continue;
            }
            ExecuteUtil.asPlayer(user, pos, repeat.toArray(new String[0]));
        }
        for (class_3222 user : new ReferenceOpenHashSet((Collection)set)) {
            if (playersInArea.contains((Object)user) && !user.method_14239() && !user.method_29504()) continue;
            cmds = this.exitCommands();
            if (cmds != null && (this.config.permission == null || Permissions.check((class_1297)user, (String)this.config.permission))) {
                class_243 class_2434 = pos = this.config.atBlock ? blockPos.method_46558() : null;
                if (this.getConfig().console) {
                    ExecuteUtil.asConsole(user, pos, cmds.toArray(new String[0]));
                } else {
                    ExecuteUtil.asPlayer(user, pos, cmds.toArray(new String[0]));
                }
            }
            set.remove(user);
        }
    }

    private List<String> enterCommands() {
        return this.config.enterCommands == null ? (this.config.enterCommand == null ? null : List.of(this.config.enterCommand)) : this.config.enterCommands;
    }

    private List<String> exitCommands() {
        return this.config.exitCommands == null ? (this.config.exitCommand == null ? null : List.of(this.config.exitCommand)) : this.config.exitCommands;
    }

    private List<String> repeatCommands() {
        return this.config.repeatCommands == null ? (this.config.repeatCommand == null ? null : List.of(this.config.repeatCommand)) : this.config.repeatCommands;
    }

    public static class Config {
        public BlockStateMappedProperty<Integer> radius = BlockStateMappedProperty.of(16);
        public BlockStateMappedProperty<Boolean> enabled = BlockStateMappedProperty.of(true);
        public BlockStateMappedProperty<Integer> interval = BlockStateMappedProperty.of(40);
        public String repeatCommand;
        public List<String> repeatCommands;
        public String enterCommand;
        public List<String> enterCommands;
        public String exitCommand;
        public List<String> exitCommands;
        public boolean atBlock;
        public boolean ignoreHeight;
        public boolean console;
        public String permission;
    }
}

