/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.util.BlockUtil;
import java.util.Objects;
import net.fabricmc.fabric.api.registry.VillagerInteractionRegistries;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import xyz.nucleoid.packettweaker.PacketContext;

public class Crop
implements BlockBehaviour<Config>,
class_2256 {
    public static final class_2758[] AGES = new class_2758[]{class_2758.method_11867((String)"age", (int)0, (int)1), class_2758.method_11867((String)"age", (int)0, (int)2), class_2758.method_11867((String)"age", (int)0, (int)3), class_2758.method_11867((String)"age", (int)0, (int)4), class_2758.method_11867((String)"age", (int)0, (int)5), class_2758.method_11867((String)"age", (int)0, (int)6), class_2758.method_11867((String)"age", (int)0, (int)7), class_2758.method_11867((String)"age", (int)0, (int)8), class_2758.method_11867((String)"age", (int)0, (int)9), class_2758.method_11867((String)"age", (int)0, (int)10), class_2758.method_11867((String)"age", (int)0, (int)11), class_2758.method_11867((String)"age", (int)0, (int)12), class_2758.method_11867((String)"age", (int)0, (int)13), class_2758.method_11867((String)"age", (int)0, (int)14), class_2758.method_11867((String)"age", (int)0, (int)15)};
    private final Config config;

    public Crop(Config config) {
        this.config = config;
    }

    @Override
    public void init(class_1792 item, class_2248 block, BehaviourHolder behaviourHolder) {
        BlockBehaviour.super.init(item, block, behaviourHolder);
        if (this.config.villagerInteraction) {
            VillagerInteractionRegistries.registerCollectable((class_1935)item);
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGES[Math.max(0, this.config.maxAge - 1)]});
    }

    @Override
    public boolean canSurvive(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return this.hasSufficientLight(levelReader, blockPos);
    }

    @Override
    public boolean isRandomlyTicking(class_2680 blockState) {
        return (Integer)blockState.method_11654((class_2769)AGES[Math.max(0, this.config.maxAge - 1)]) < this.config.maxAge - 1;
    }

    @Override
    public void randomTick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        float f;
        int i;
        if (serverLevel.method_22335(blockPos, 0) >= 9 && (i = this.getAge(blockState)) < this.config.maxAge - 1 && randomSource.method_43048((int)(25.0f / (f = this.getGrowthSpeed(blockState.method_26204(), (class_1922)serverLevel, blockPos))) + 1) == 0) {
            serverLevel.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)AGES[Math.max(0, this.config.maxAge - 1)], (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    private int getAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGES[Math.max(0, this.config.maxAge - 1)]);
    }

    public void growCrops(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        int j;
        int i = this.getAge(blockState) + this.getBonemealAgeIncrease(level);
        if (i > (j = this.config.maxAge - 1)) {
            i = j;
        }
        level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)AGES[Math.max(0, this.config.maxAge - 1)], (Comparable)Integer.valueOf(i)), 2);
    }

    public class_2680 incrementedAge(class_2680 blockState) {
        class_2758 prop = AGES[Math.max(0, this.config.maxAge - 1)];
        return (class_2680)blockState.method_11657((class_2769)prop, (Comparable)((Integer)blockState.method_11654((class_2769)prop)));
    }

    public boolean isMaxAge(class_2680 blockState) {
        class_2758 prop = AGES[Math.max(0, this.config.maxAge - 1)];
        return (Integer)blockState.method_11654((class_2769)prop) == this.config.maxAge - 1;
    }

    protected int getBonemealAgeIncrease(class_1937 level) {
        return class_3532.method_15395((class_5819)level.field_9229, (int)2, (int)5);
    }

    protected float getGrowthSpeed(class_2248 block, class_1922 blockGetter, class_2338 blockPos) {
        boolean bl2;
        float bonus = 1.0f;
        class_2338 blockPos2 = blockPos.method_10074();
        for (int i = -this.config.bonusRadius; i <= this.config.bonusRadius; ++i) {
            for (int j = -this.config.bonusRadius; j <= this.config.bonusRadius; ++j) {
                float localBonus = 0.0f;
                class_2680 blockState = blockGetter.method_8320(blockPos2.method_10069(i, 0, j));
                if (blockState.method_27852(this.config.bonusBlock)) {
                    localBonus = 1.0f;
                    if (blockState.method_28498((class_2769)class_2344.field_11009) && (Integer)blockState.method_11654((class_2769)class_2344.field_11009) > 0) {
                        localBonus = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    localBonus /= 4.0f;
                }
                bonus += localBonus;
            }
        }
        class_2338 northed = blockPos.method_10095();
        class_2338 southed = blockPos.method_10072();
        class_2338 wested = blockPos.method_10067();
        class_2338 easted = blockPos.method_10078();
        boolean bl = this.isCrop(blockGetter.method_8320(wested).method_26204()) || this.isCrop(blockGetter.method_8320(easted).method_26204());
        boolean bl3 = bl2 = this.isCrop(blockGetter.method_8320(northed).method_26204()) || this.isCrop(blockGetter.method_8320(southed).method_26204());
        if (bl && bl2) {
            bonus /= 2.0f;
        } else {
            boolean bl32;
            boolean bl4 = bl32 = this.isCrop(blockGetter.method_8320(wested.method_10095()).method_26204()) || this.isCrop(blockGetter.method_8320(easted.method_10095()).method_26204()) || this.isCrop(blockGetter.method_8320(easted.method_10072()).method_26204()) || this.isCrop(blockGetter.method_8320(wested.method_10072()).method_26204());
            if (bl32) {
                bonus /= 2.0f;
            }
        }
        return bonus;
    }

    private boolean isCrop(class_2248 block1) {
        SimpleBlock simpleBlock;
        return block1 instanceof SimpleBlock && (simpleBlock = (SimpleBlock)block1).has(Behaviours.CROP) && Objects.requireNonNull((Crop)simpleBlock.get(Behaviours.CROP)).config == this.config;
    }

    protected boolean hasSufficientLight(class_4538 levelReader, class_2338 blockPos) {
        return levelReader.method_22335(blockPos, 0) >= this.config.minLightLevel;
    }

    public boolean method_9651(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        return this.getAge(blockState) < this.config.maxAge - 1;
    }

    public boolean method_9650(class_1937 level, class_5819 randomSource, class_2338 blockPos, class_2680 blockState) {
        return true;
    }

    public void method_9652(class_3218 serverLevel, class_5819 randomSource, class_2338 blockPos, class_2680 blockState) {
        SimpleBlock polymerBlock;
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof SimpleBlock && !((polymerBlock = (SimpleBlock)class_22482).getPolymerBlockState(blockState, PacketContext.create()).method_26204() instanceof class_2256)) {
            BlockUtil.handleBoneMealEffects(serverLevel, blockPos);
        }
        this.growCrops((class_1937)serverLevel, blockPos, blockState);
    }

    public static class Config {
        public int maxAge = 4;
        public int minLightLevel = 8;
        public int bonusRadius = 1;
        public class_2248 bonusBlock = class_2246.field_10362;
        public boolean villagerInteraction = true;
        public boolean beeInteraction = true;
    }
}

