/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.mixin.accessor.PlayerAccessor;
import de.tomalbrc.filament.util.DecorationUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3902;
import org.jetbrains.annotations.NotNull;

public class Bed
implements DecorationBehaviour<Config> {
    private final Config config;

    public Bed(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        return this.startSleeping(player, decorationBlockEntity, decorationBlockEntity.method_11016());
    }

    private class_1269 startSleeping(class_3222 player, DecorationBlockEntity decorationBlockEntity, class_2338 blockPos) {
        Either<class_1657.class_1658, class_3902> res = this.startSleepInBed(player, decorationBlockEntity, blockPos);
        res.ifLeft(bedSleepingProblem -> {
            if (bedSleepingProblem.method_19206() != null) {
                player.method_7353(bedSleepingProblem.method_19206(), true);
            }
        });
        return res.right().isPresent() ? class_1269.field_5811 : class_1269.field_5812;
    }

    Pair<Boolean, Boolean> inRangeOrBlocked(class_3222 serverPlayer, DecorationBlockEntity decorationBlockEntity) {
        AtomicBoolean range = new AtomicBoolean(false);
        AtomicBoolean blocked = new AtomicBoolean(false);
        DecorationUtil.forEachRotated(decorationBlockEntity.getDecorationData().blocks(), decorationBlockEntity.mainPosition(), decorationBlockEntity.getBlock().getVisualRotationYInDegrees(decorationBlockEntity.method_11010()), blockPos -> {
            if (serverPlayer.method_51469().method_8320(blockPos.method_10084()).method_26228((class_1922)serverPlayer.method_51469(), blockPos)) {
                blocked.set(true);
            }
            if (this.isReachableBedBlock(serverPlayer, (class_2338)blockPos)) {
                range.set(true);
            }
        });
        return Pair.of((Object)range.get(), (Object)blocked.get());
    }

    private boolean isReachableBedBlock(class_3222 serverPlayer, class_2338 blockPos) {
        class_243 vec3 = class_243.method_24955((class_2382)blockPos);
        return Math.abs(serverPlayer.method_23317() - vec3.method_10216()) <= 3.0 && Math.abs(serverPlayer.method_23318() - vec3.method_10214()) <= 2.0 && Math.abs(serverPlayer.method_23321() - vec3.method_10215()) <= 3.0;
    }

    public Either<class_1657.class_1658, class_3902> startSleepInBed(class_3222 player, DecorationBlockEntity decorationBlockEntity, class_2338 blockPos) {
        if (!player.method_6113() && player.method_5805()) {
            Pair<Boolean, Boolean> testRes = this.inRangeOrBlocked(player, decorationBlockEntity);
            if (!player.method_51469().method_8597().comp_645()) {
                return Either.left((Object)class_1657.class_1658.field_7528);
            }
            if (!((Boolean)testRes.getFirst()).booleanValue()) {
                return Either.left((Object)class_1657.class_1658.field_7530);
            }
            if (((Boolean)testRes.getSecond()).booleanValue()) {
                return Either.left((Object)class_1657.class_1658.field_18592);
            }
            player.method_26284(new class_3222.class_10766(player.method_51469().method_27983(), blockPos, player.method_36454(), false), true);
            if (player.method_51469().method_8530()) {
                return Either.left((Object)class_1657.class_1658.field_7529);
            }
            if (!player.method_68878()) {
                double hRange = 8.0;
                double vRange = 5.0;
                class_243 vec3 = class_243.method_24955((class_2382)blockPos);
                List list = player.method_51469().method_8390(class_1588.class, new class_238(vec3.method_10216() - hRange, vec3.method_10214() - vRange, vec3.method_10215() - hRange, vec3.method_10216() + hRange, vec3.method_10214() + vRange, vec3.method_10215() + hRange), monster -> monster.method_7076(player.method_51469(), (class_1657)player));
                if (!list.isEmpty()) {
                    return Either.left((Object)class_1657.class_1658.field_7532);
                }
            }
            Either either = this.startSleepInBedDirect(player, blockPos).ifRight(unit -> {
                player.method_7281(class_3468.field_15381);
                class_174.field_1212.method_9141(player);
            });
            if (!player.method_51469().method_33144()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"sleep.not_possible"), true);
            }
            player.method_51469().method_8448();
            return either;
        }
        return Either.left((Object)class_1657.class_1658.field_7531);
    }

    public Either<class_1657.class_1658, class_3902> startSleepInBedDirect(class_3222 entity, class_2338 blockPos) {
        entity.method_18403(blockPos);
        ((PlayerAccessor)entity).setSleepCounter(0);
        return Either.right((Object)class_3902.field_17274);
    }

    public static class Config {
        boolean skipNight = false;
    }
}

