/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.api.behaviour.ContainerLike;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.decoration.DecorationItem;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.util.FilamentContainer;
import de.tomalbrc.filament.util.TextUtil;
import de.tomalbrc.filament.util.Util;
import eu.pb4.polymer.virtualentity.api.elements.BlockDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4538;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_747;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_9288;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Showcase
implements BlockBehaviour<Config>,
DecorationBehaviour<Config>,
ContainerLike {
    private static final String SHOWCASE_KEY = "Showcase";
    private static final String ITEM = "Item";
    private final Config config;
    private final Object2ObjectOpenHashMap<ShowcaseMeta, DisplayElement> showcases = new Object2ObjectOpenHashMap();
    private FilamentContainer container;
    public class_5321<class_52> lootTable;
    public long lootTableSeed;

    public Showcase(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(DecorationBlockEntity blockEntity) {
        this.container = new FilamentContainer(blockEntity, this.config.elements.size(), false){

            @Override
            public int getMaxStackSize(int slot) {
                return Showcase.this.config.elements.get((int)slot).maxStackSize;
            }
        };
        this.container.method_5489(x -> {
            for (int i = 0; i < x.method_5439(); ++i) {
                class_1799 stack = x.method_5438(i);
                this.setShowcaseItemStack(blockEntity, this.config.elements.get(i), stack);
            }
        });
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, DecorationBlockEntity decorationBlockEntity) {
        if (!player.method_21823() && decorationBlockEntity.getOrCreateHolder() != null) {
            if (this.config.useMenu) {
                class_2561 containerName = this.customName() != null && this.showCustomName() ? this.customName() : TextUtil.formatText(this.config.name);
                player.method_17355((class_3908)new class_747((id, inventory, p) -> Util.createMenu((class_1263)this.container, id, p), containerName));
                return class_1269.field_5812;
            }
            ShowcaseMeta showcase = this.getClosestShowcase(decorationBlockEntity, location);
            class_1799 itemStack = player.method_5998(hand);
            class_1799 showcaseStack = this.getShowcaseItemStack(showcase);
            if (this.canUseShowcaseItem(showcase, itemStack)) {
                boolean changed = false;
                if (!player.method_5998(hand).method_7960()) {
                    changed = true;
                    if (showcaseStack != null && !showcaseStack.method_7960()) {
                        Util.spawnAtLocation(decorationBlockEntity.method_10997(), location, showcaseStack);
                    }
                    int count = this.container.getMaxStackSize(0);
                    this.container.method_5447(this.config.elements.indexOf(showcase), itemStack.method_46651(count));
                    itemStack.method_7934(count);
                    player.method_51469().method_43128(null, location.method_10216(), location.method_10214(), location.method_10215(), class_3414.method_47908((class_2960)showcase.addItemSound), class_3419.field_15254, 1.0f, 1.0f);
                } else if (showcaseStack != null && !showcaseStack.method_7960()) {
                    changed = true;
                    player.method_6122(hand, showcaseStack);
                    this.container.method_5447(this.config.elements.indexOf(showcase), class_1799.field_8037);
                    player.method_51469().method_43128(null, location.method_10216(), location.method_10214(), location.method_10215(), class_3414.method_47908((class_2960)showcase.removeItemSound), class_3419.field_15254, 1.0f, 1.0f);
                }
                if (changed) {
                    decorationBlockEntity.method_5431();
                    return class_1269.field_21466;
                }
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public void read(class_11368 input, DecorationBlockEntity blockEntity) {
        Optional showcaseInput;
        if (!this.container.method_54871(input) && (showcaseInput = input.method_71420(SHOWCASE_KEY)).isPresent() && blockEntity.getOrCreateHolder() != null) {
            class_11368 showcaseTag = (class_11368)showcaseInput.orElseThrow();
            for (int i = 0; i < this.config.elements.size(); ++i) {
                String key = ITEM + i;
                if (!showcaseTag.method_71420(key).isPresent()) continue;
                this.container.field_5828.set(i, (Object)((class_1799)showcaseTag.method_71426(key, class_1799.field_24671).orElseThrow()));
            }
            this.container.method_5431();
        }
        this.container.method_54873(null);
    }

    @Override
    public void write(class_11372 output, DecorationBlockEntity blockEntity) {
        if (!this.container.method_54872(output) && blockEntity.getOrCreateHolder() != null) {
            class_11372 showcaseTag = output.method_71461(SHOWCASE_KEY);
            for (int i = 0; i < this.config.elements.size(); ++i) {
                ShowcaseMeta showcase = this.config.elements.get(i);
                if (showcase == null || this.getShowcaseItemStack(showcase).method_7960()) continue;
                showcaseTag.method_71468(ITEM + i, class_1799.field_24671, (Object)this.getShowcaseItemStack(showcase));
            }
        }
    }

    @Override
    public void destroy(DecorationBlockEntity decorationBlockEntity, boolean dropItem) {
        this.container.setValid(false);
        if (!this.config.canPickup) {
            class_1264.method_5451((class_1937)decorationBlockEntity.method_10997(), (class_2338)decorationBlockEntity.method_11016(), (class_1263)this.container);
        }
    }

    public ShowcaseMeta getClosestShowcase(DecorationBlockEntity decorationBlockEntity, class_243 location) {
        if (this.config.elements.size() == 1) {
            return this.config.elements.getFirst();
        }
        double dist = Double.MAX_VALUE;
        ShowcaseMeta nearest = null;
        for (ShowcaseMeta showcase : this.config.elements) {
            class_243 q = decorationBlockEntity.method_11016().method_46558().method_1019(new class_243(this.showcaseTranslation(showcase).rotateY((-decorationBlockEntity.getVisualRotationYInDegrees() + 180.0f) * ((float)Math.PI / 180))));
            double distance = q.method_1022(location);
            if (!(distance < dist)) continue;
            dist = distance;
            nearest = showcase;
        }
        return nearest;
    }

    private Vector3f showcaseTranslation(ShowcaseMeta showcase) {
        return new Vector3f((Vector3fc)showcase.offset).sub(0.0f, 0.475f, 0.0f).rotateY((float)Math.PI);
    }

    /*
     * Unable to fully structure code
     */
    public void setShowcaseItemStack(DecorationBlockEntity decorationBlockEntity, ShowcaseMeta showcase, class_1799 itemStack) {
        block6: {
            block5: {
                holder = decorationBlockEntity.getOrCreateHolder();
                if (holder == null) {
                    return;
                }
                var7_5 = itemStack.method_7909();
                isBlockItem = var7_5 instanceof class_1747 != false && (blockItem = (class_1747)var7_5).method_7711() instanceof DecorationBlock == false;
                element = (DisplayElement)this.showcases.get((Object)showcase);
                v0 = dynNeedsUpdate = showcase.type == ShowcaseType.dynamic && element != null && (element instanceof BlockDisplayElement == false || isBlockItem == false);
                if (element != null && !dynNeedsUpdate) break block5;
                if (element != null) {
                    decorationBlockEntity.getOrCreateHolder().removeElement((VirtualElement)element);
                    this.showcases.remove((Object)showcase);
                }
                newElement = this.createShowcase(decorationBlockEntity, showcase, itemStack);
                decorationBlockEntity.getOrCreateHolder().addElement(newElement);
                break block6;
            }
            if (!(element instanceof BlockDisplayElement)) ** GOTO lbl-1000
            blockDisplayElement = (BlockDisplayElement)element;
            var12_10 = itemStack.method_7909();
            if (var12_10 instanceof class_1747) {
                blockItem = (class_1747)var12_10;
                blockDisplayElement.getDataTracker().set(DisplayTrackedData.Block.BLOCK_STATE, (Object)blockItem.method_7711().method_9564(), true);
            } else if (element instanceof ItemDisplayElement) {
                itemDisplayElement = (ItemDisplayElement)element;
                itemDisplayElement.setItem(itemStack);
            }
            this.showcases.put((Object)showcase, (Object)element);
        }
        decorationBlockEntity.getOrCreateHolder().tick();
    }

    private BlockDisplayElement element(class_1747 blockItem) {
        BlockDisplayElement displayElement = new BlockDisplayElement();
        displayElement.setBlockState(blockItem.method_7711().method_9564());
        return displayElement;
    }

    private DisplayElement element(ShowcaseMeta showcase, class_1799 itemStack) {
        ItemDisplayElement displayElement = new ItemDisplayElement(itemStack.method_7972());
        displayElement.setItemDisplayContext(showcase.display);
        displayElement.setInvisible(true);
        return displayElement;
    }

    private DisplayElement createShowcase(DecorationBlockEntity decorationBlockEntity, ShowcaseMeta showcase, class_1799 itemStack) {
        Object element = null;
        switch (showcase.type.ordinal()) {
            case 0: {
                element = this.element(showcase, itemStack);
                break;
            }
            case 1: {
                class_1747 blockItem;
                class_1792 class_17922 = itemStack.method_7909().method_8389();
                if (!(class_17922 instanceof class_1747) || (blockItem = (class_1747)class_17922) instanceof DecorationItem) break;
                element = this.element(blockItem);
                break;
            }
            case 2: {
                class_1747 blockItem;
                class_1792 class_17923 = itemStack.method_7909().method_8389();
                element = class_17923 instanceof class_1747 && !((blockItem = (class_1747)class_17923) instanceof DecorationItem) ? this.element(blockItem) : this.element(showcase, itemStack);
            }
        }
        if (element != null) {
            this.transform(decorationBlockEntity, (DisplayElement)element, showcase);
            this.showcases.put((Object)showcase, element);
        } else {
            Filament.LOGGER.error("In valid showcase type for {}", (Object)itemStack.method_7909().method_7876());
        }
        return element;
    }

    private void transform(DecorationBlockEntity decorationBlockEntity, DisplayElement element, ShowcaseMeta showcase) {
        if (element != null) {
            element.setScale((Vector3fc)showcase.scale);
            element.setLeftRotation((Quaternionfc)showcase.rotation);
            element.setYaw(decorationBlockEntity.getVisualRotationYInDegrees() + 180.0f);
            if (element instanceof BlockDisplayElement) {
                element.setTranslation((Vector3fc)this.showcaseTranslation(showcase).add((Vector3fc)new Vector3f(-0.5f, -0.5f, -0.5f).mul((Vector3fc)showcase.scale)));
            } else {
                element.setTranslation((Vector3fc)this.showcaseTranslation(showcase));
            }
        }
    }

    public class_1799 getShowcaseItemStack(ShowcaseMeta showcase) {
        int i = this.config.elements.indexOf(showcase);
        return this.container.method_5438(i);
    }

    public boolean canUseShowcaseItem(ShowcaseMeta showcase, class_1799 item) {
        boolean hasFilterTags;
        boolean hasFilterItems = showcase.filterItems != null && !showcase.filterItems.isEmpty();
        boolean bl = hasFilterTags = showcase.filterTags != null && !showcase.filterTags.isEmpty();
        if (hasFilterTags) {
            for (class_2960 class_29602 : showcase.filterTags) {
                class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_29602);
                if (!item.method_31573(key)) continue;
                return true;
            }
        }
        if (hasFilterItems) {
            for (class_1792 class_17922 : showcase.filterItems) {
                if (!item.method_31574(class_17922)) continue;
                return true;
            }
        }
        return !hasFilterItems && !hasFilterTags;
    }

    @Override
    public void modifyDrop(DecorationBlockEntity decorationBlockEntity, class_1799 itemStack) {
        if (this.config.canPickup) {
            itemStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(this.container.method_54454()));
        }
    }

    @Override
    public class_1799 getCloneItemStack(class_1799 itemStack, class_4538 levelReader, class_2338 blockPos, class_2680 blockState, boolean includeData) {
        return itemStack;
    }

    @Override
    public void applyImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_9473 dataComponentGetter) {
        class_9297 seededContainerLoot = (class_9297)dataComponentGetter.method_58694(class_9334.field_49626);
        if (seededContainerLoot != null) {
            this.lootTable = seededContainerLoot.comp_2414();
            this.lootTableSeed = seededContainerLoot.comp_2415();
        }
        ((class_9288)dataComponentGetter.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.container.field_5828);
        this.container.method_5431();
        this.container.method_54873(null);
    }

    @Override
    public void collectImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493((List)this.container.field_5828));
        if (this.lootTable != null) {
            builder.method_57840(class_9334.field_49626, (Object)new class_9297(this.lootTable, this.lootTableSeed));
        }
    }

    @Override
    public class_2561 customName() {
        return (class_2561)this.container.getBlockEntity().method_58693().method_58694(class_9334.field_49631);
    }

    @Override
    @Nullable
    public class_1263 container() {
        return this.container;
    }

    @Override
    public boolean showCustomName() {
        return this.config.showCustomName;
    }

    @Override
    public boolean hopperDropperSupport() {
        return this.config.hopperDropperSupport;
    }

    @Override
    public boolean canPickUp() {
        return this.config.canPickup;
    }

    @Override
    public void removeComponentsFromTag(DecorationBlockEntity decorationBlockEntity, class_11372 valueOutput) {
        valueOutput.method_71478("LootTable");
        valueOutput.method_71478("LootTableSeed");
    }

    @Override
    public void setLootTable(@Nullable class_5321<class_52> resourceKey) {
        this.lootTable = resourceKey;
    }

    @Override
    @Nullable
    public class_5321<class_52> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTableSeed(long l) {
        this.lootTableSeed = l;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public static class Config {
        public boolean hopperDropperSupport = true;
        public boolean useMenu = false;
        public String name = "Showcase";
        public boolean showCustomName = true;
        public boolean canPickup = false;
        public List<ShowcaseMeta> elements;

        public static class ConfigDeserializer
        implements JsonDeserializer<Config> {
            public Config deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
                Config config = new Config();
                if (json.isJsonArray()) {
                    config.elements = new ObjectArrayList();
                    for (JsonElement elem : json.getAsJsonArray()) {
                        ShowcaseMeta meta = (ShowcaseMeta)ctx.deserialize(elem, ShowcaseMeta.class);
                        config.elements.add(meta);
                    }
                    return config;
                }
                if (json.isJsonObject()) {
                    JsonObject obj = json.getAsJsonObject();
                    if (obj.has("hopper_dropper_support")) {
                        config.hopperDropperSupport = obj.get("hopper_dropper_support").getAsBoolean();
                    }
                    if (obj.has("use_menu")) {
                        config.useMenu = obj.get("use_menu").getAsBoolean();
                    }
                    if (obj.has("name")) {
                        config.name = obj.get("name").getAsString();
                    }
                    if (obj.has("show_custom_name")) {
                        config.showCustomName = obj.get("show_custom_name").getAsBoolean();
                    }
                    if (obj.has("elements") && obj.get("elements").isJsonArray()) {
                        config.elements = new ObjectArrayList();
                        for (JsonElement elem : obj.getAsJsonArray("elements")) {
                            ShowcaseMeta meta = (ShowcaseMeta)ctx.deserialize(elem, ShowcaseMeta.class);
                            config.elements.add(meta);
                        }
                    }
                    return config;
                }
                throw new JsonParseException("Invalid config format: must be object or array");
            }
        }
    }

    public static class ShowcaseMeta {
        public Vector3f offset = new Vector3f();
        public Vector3f scale = new Vector3f(1.0f);
        public Quaternionf rotation = new Quaternionf();
        public ShowcaseType type = ShowcaseType.item;
        public List<class_1792> filterItems;
        public List<class_2960> filterTags;
        public class_2960 addItemSound = class_3417.field_14667.comp_3319();
        public class_2960 removeItemSound = class_3417.field_14770.comp_3319();
        public int maxStackSize = 1;
        public class_811 display = class_811.field_4315;
    }

    public static enum ShowcaseType {
        item,
        block,
        dynamic;

    }
}

