/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.entity.target;

import de.tomalbrc.filament.api.behaviour.EntityBehaviour;
import de.tomalbrc.filament.entity.FilamentMob;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4051;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NearestAttackableTargetGoal
implements EntityBehaviour<Config> {
    private final Config config;

    public NearestAttackableTargetGoal(Config config) {
        this.config = config;
    }

    @Override
    public void registerGoals(FilamentMob mob) {
        EntityBehaviour.super.registerGoals(mob);
        mob.getTargetSelector().method_6277(this.config.priority, (class_1352)new NearestAttackableTargetGoalImpl((class_1308)mob, (class_1299)class_7923.field_41177.method_63535(this.config.target), this.config.randomInterval, this.config.mustSee, this.config.mustReach, this::check));
    }

    boolean check(class_1309 livingEntity, class_3218 serverLevel) {
        return !(this.config.ignoreBaby && !livingEntity.method_6109() || this.config.ignoreInWater && livingEntity.method_5799());
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        int priority;
        class_2960 target;
        int randomInterval = 10;
        boolean mustSee = true;
        boolean mustReach = true;
        boolean ignoreBaby = false;
        boolean ignoreInWater = false;
    }

    public static class NearestAttackableTargetGoalImpl
    extends class_1405 {
        protected final class_1299<?> targetType;
        protected final int randomInterval;
        @Nullable
        protected class_1309 target;
        protected class_4051 targetConditions;

        public NearestAttackableTargetGoalImpl(class_1308 mob, class_1299<?> entityType, int interval, boolean mustSee, boolean mustReach, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable class_4051.class_10254 selector) {
            super(mob, mustSee, mustReach);
            this.targetType = entityType;
            this.randomInterval = NearestAttackableTargetGoalImpl.method_38848((int)interval);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
            this.targetConditions = class_4051.method_36625().method_18418(this.method_6326()).method_18420(selector);
        }

        public boolean method_6264() {
            if (this.randomInterval > 0 && this.field_6660.method_59922().method_43048(this.randomInterval) != 0) {
                return false;
            }
            this.findTarget();
            return this.target != null;
        }

        protected class_238 getTargetSearchArea(double d) {
            return this.field_6660.method_5829().method_1009(d, d, d);
        }

        protected void findTarget() {
            class_3218 serverLevel = NearestAttackableTargetGoalImpl.method_64451((class_1297)this.field_6660);
            this.target = this.targetType != class_1299.field_6097 ? serverLevel.method_64393(this.field_6660.method_37908().method_8390(class_1308.class, this.getTargetSearchArea(this.method_6326()), livingEntity -> livingEntity.method_5864() == this.targetType), this.getTargetConditions(), (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321()) : serverLevel.method_64389(this.getTargetConditions(), (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
        }

        public void method_6269() {
            this.field_6660.method_5980(this.target);
            super.method_6269();
        }

        public void setTarget(@Nullable class_1309 livingEntity) {
            this.target = livingEntity;
        }

        private class_4051 getTargetConditions() {
            return this.targetConditions.method_18418(this.method_6326());
        }
    }
}

