/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5761;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Trap
implements ItemBehaviour<Config> {
    private final Config config;

    public Trap(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void appendHoverText(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        class_9279 bucketData = (class_9279)itemStack.method_58694(class_9334.field_49610);
        if (bucketData != null && bucketData.method_57450("Type")) {
            class_1299 type = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)bucketData.method_57461().method_10558("Type").orElse("minecraft:pig")));
            consumer.accept((class_2561)class_2561.method_43470((String)"Contains ").method_10852((class_2561)class_2561.method_43471((String)type.method_5882())));
        } else {
            if (this.config.requiredEffects != null) {
                consumer.accept((class_2561)class_2561.method_43470((String)"Requires effects: "));
                for (int i = 0; i < this.config.requiredEffects.size(); ++i) {
                    class_2960 e = this.config.requiredEffects.get(i);
                    consumer.accept((class_2561)class_2561.method_43470((String)"\u203a ").method_10852((class_2561)class_2561.method_43471((String)Objects.requireNonNull((class_1291)class_7923.field_41174.method_63535(e)).method_5567())));
                }
            }
            consumer.accept((class_2561)class_2561.method_43470((String)("Chance: " + this.config.chance + "%")));
        }
    }

    @Override
    public class_1269 use(class_1792 item, class_1937 level, class_1657 user, class_1268 hand) {
        this.useTrapAndBreak(item, user, hand);
        return class_1269.field_21466;
    }

    public void useTrapAndBreak(class_1792 item, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        if (this.config.useDuration > 0) {
            player.method_7357().method_62835(itemStack, this.config.useDuration);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        Util.damageAndBreak(1, itemStack, (class_1309)player, class_1657.method_56079((class_1268)hand));
    }

    @Override
    public class_1269 useOn(class_1838 useOnContext) {
        class_1937 class_19372;
        if (useOnContext.method_8036() != null && Trap.canSpawn(useOnContext.method_8041()) && (class_19372 = useOnContext.method_8045()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.spawn(serverLevel, useOnContext.method_8036(), useOnContext.method_20287(), useOnContext.method_8041(), useOnContext.method_8037());
            this.useTrapAndBreak(useOnContext.method_8041().method_7909(), useOnContext.method_8036(), useOnContext.method_20287());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void modifyPolymerItemStack(Map<String, class_2960> modelData, class_1799 original, class_1799 itemStack, class_1836 tooltipType, class_7225.class_7874 lookup, @Nullable class_3222 player) {
        if (modelData != null) {
            itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(Trap.canSpawn(original) ? "trapped" : "default"), List.of()));
        }
    }

    private static boolean canSpawn(class_1799 useOnContext) {
        return useOnContext.method_58694(class_9334.field_49610) != null && Objects.requireNonNull((class_9279)useOnContext.method_58694(class_9334.field_49610)).method_57450("Type");
    }

    private void spawn(class_3218 serverLevel, class_1657 player, class_1268 hand, class_1799 itemStack, class_2338 blockPos) {
        class_9279 bucketData = (class_9279)itemStack.method_58694(class_9334.field_49610);
        if (bucketData != null) {
            class_2487 compoundTag = bucketData.method_57461();
            class_1299 entityType = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)compoundTag.method_10558("Type").orElse("minecraft:pig")));
            class_1297 entity = entityType.method_47821(serverLevel, blockPos.method_10086(1), class_3730.field_16473);
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                this.loadFromTag(mob, compoundTag);
            }
            itemStack.method_57381(class_9334.field_49610);
        }
    }

    public boolean canUseOn(class_1308 mob) {
        boolean isType;
        class_2960 mobType = class_7923.field_41177.method_10221((Object)mob.method_5864());
        if (this.config.types != null && (isType = this.config.types.contains(mobType))) {
            return true;
        }
        if (this.config.tags != null) {
            for (class_2960 tag : this.config.tags) {
                if (!mob.method_5864().method_20210(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)tag))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSave(class_1308 mob) {
        boolean hasEffects = true;
        if (this.config.requiredEffects != null) {
            hasEffects = false;
            for (int i = 0; i < this.config.requiredEffects.size(); ++i) {
                class_2960 effectId = this.config.requiredEffects.get(i);
                Optional optional = class_7923.field_41174.method_10223(effectId);
                if (!optional.isPresent() || !mob.method_6059((class_6880)optional.get())) continue;
                hasEffects = true;
            }
        }
        return hasEffects && mob.method_59922().method_43048(100) <= this.config.chance;
    }

    public void saveToTag(class_1308 mob, class_1799 itemStack) {
        class_5761.method_35167((class_1308)mob, (class_1799)itemStack);
        class_2960 resourceLocation = class_7923.field_41177.method_10221((Object)mob.method_5864());
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)itemStack, tag -> tag.method_10582("Type", resourceLocation.toString()));
    }

    public void loadFromTag(class_1308 mob, class_2487 compoundTag) {
        class_5761.method_35168((class_1308)mob, (class_2487)compoundTag);
    }

    public static class Config {
        public List<class_2960> types = null;
        public List<class_2960> tags = null;
        public List<class_2960> requiredEffects = null;
        public int chance = 50;
        public int useDuration = 0;
    }
}

