/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.block;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.util.BlockUtil;
import de.tomalbrc.filament.util.DecorationUtil;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.virtualentity.api.BlockWithElementHolder;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.mixin.accessors.ItemDisplayEntityAccessor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_811;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SimpleVirtualBlock
extends SimpleBlock
implements BlockWithElementHolder {
    private final Map<BlockData.BlockStateMeta, String> cmdMap = new Reference2ObjectOpenHashMap();

    public SimpleVirtualBlock(class_4970.class_2251 properties, BlockData data) {
        super(properties, data);
    }

    @Override
    public void postRegister() {
        super.postRegister();
        for (Map.Entry stateMapEntry : this.stateMap.entrySet()) {
            for (Map.Entry<String, class_2960> blockResourceModelsEntry : this.blockData.blockResource().getModels().entrySet()) {
                boolean same = blockResourceModelsEntry.getValue().equals((Object)((BlockData.BlockStateMeta)stateMapEntry.getValue()).polymerBlockModel().model());
                if (!same) continue;
                this.cmdMap.put((BlockData.BlockStateMeta)stateMapEntry.getValue(), blockResourceModelsEntry.getKey());
            }
        }
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new VirtualBlockHolder(initialBlockState);
    }

    @Override
    protected void method_33614(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState) {
        class_1937 class_19372;
        BlockBoundAttachment attachment;
        if (((BlockProperties)this.blockData.properties()).showBreakParticles && (attachment = BlockBoundAttachment.get((class_1937)player.method_37908(), (class_2338)blockPos)) != null && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            VirtualBlockHolder holder = (VirtualBlockHolder)attachment.holder();
            DecorationUtil.showBreakParticleShaped(serverLevel, blockPos, blockState, holder.displayStack);
            BlockUtil.playBreakSound((class_1937)serverLevel, blockPos, blockState);
        }
    }

    public static class VirtualBlockHolder
    extends ElementHolder {
        @NotNull
        private final SimpleVirtualBlock virtualBlock;
        @NotNull
        private final class_1799 displayStack;
        @NotNull
        private final ItemDisplayElement displayElement;

        public VirtualBlockHolder(class_2680 blockState) {
            this.virtualBlock = (SimpleVirtualBlock)blockState.method_26204();
            this.displayStack = this.virtualBlock.method_8389().method_7854();
            this.displayStack.method_57379(class_9334.field_54199, (Object)this.virtualBlock.blockData.id().method_45138("block/"));
            this.displayElement = new ItemDisplayElement(this.displayStack);
            this.displayElement.setItemDisplayContext(class_811.field_4315);
            this.displayElement.setScale((Vector3fc)new Vector3f(1.0001f));
            this.displayElement.setDisplaySize(1.0f, 1.0f);
            this.displayElement.setInvisible(true);
            this.update(blockState, false);
            this.addElement((VirtualElement)this.displayElement);
        }

        private BlockAwareAttachment attachment() {
            return (BlockAwareAttachment)this.getAttachment();
        }

        public void update(class_2680 blockState, boolean update) {
            class_2680 state = this.virtualBlock.behaviourModifiedBlockState(blockState, blockState);
            BlockData.BlockStateMeta meta = (BlockData.BlockStateMeta)this.virtualBlock.stateMap.get(state);
            this.displayStack.method_57379(class_9334.field_49637, (Object)new class_9280((List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)this.virtualBlock.cmdMap.get(meta)), (List)ImmutableList.of()));
            PolymerBlockModel polymerBlockModel = meta.polymerBlockModel();
            this.displayElement.setLeftRotation((Quaternionfc)new Quaternionf().rotateX((float)polymerBlockModel.x() * ((float)Math.PI / 180)).rotateY((float)(-polymerBlockModel.y() + 180) * ((float)Math.PI / 180)));
            if (update) {
                this.displayElement.getDataTracker().setDirty(ItemDisplayEntityAccessor.getITEM(), true);
                this.displayElement.tick();
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            super.notifyUpdate(updateType);
            BlockAwareAttachment attachment = this.attachment();
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE && attachment != null) {
                this.update(attachment.getBlockState(), true);
            }
        }
    }
}

