/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import de.tomalbrc.filament.api.behaviour.ContainerLike;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_8934;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilamentContainer
extends class_1277
implements class_8934 {
    List<class_1309> menus = new ObjectArrayList();
    private boolean valid = true;
    private final boolean purge;
    private final DecorationBlockEntity blockEntity;
    private Runnable closeCallback;
    private Runnable openCallback;

    public FilamentContainer(DecorationBlockEntity blockEntity, int size, boolean purge) {
        super(size);
        this.method_5489(x -> blockEntity.method_5431());
        this.blockEntity = blockEntity;
        this.purge = purge;
    }

    public boolean method_5443(class_1657 player) {
        return this.valid && !this.blockEntity.method_11015();
    }

    public boolean method_49104(class_1263 target, int slot, class_1799 stack) {
        return this.valid;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.valid && !this.blockEntity.method_11015() && stack.method_7947() <= this.getMaxStackSize(slot) - this.method_5438(slot).method_7947();
    }

    public int getMaxStackSize(int slot) {
        return this.method_5444();
    }

    public void setValid(boolean valid) {
        if (!valid) {
            for (class_1309 entity : this.menus) {
                if (!(entity instanceof class_3222)) continue;
                class_3222 player = (class_3222)entity;
                player.method_7346();
            }
        }
        this.valid = valid;
    }

    public boolean hasViewers() {
        return !this.menus.isEmpty();
    }

    public void method_5435(class_1657 player) {
        this.method_54873(player);
        this.method_54873(player);
        super.method_5435(player);
        if (!player.method_7325() && this.menus.isEmpty() && this.openCallback != null) {
            this.openCallback.run();
        }
        this.menus.add((class_1309)player);
    }

    public void method_5432(class_1657 player) {
        super.method_5432(player);
        this.menus.remove(player);
        if (this.menus.isEmpty() && this.closeCallback != null) {
            this.closeCallback.run();
        }
        if (this.purge && this.menus.isEmpty()) {
            this.method_5448();
        }
    }

    public void setCloseCallback(Runnable closeCallback) {
        this.closeCallback = closeCallback;
    }

    public void setOpenCallback(Runnable openCallback) {
        this.openCallback = openCallback;
    }

    public boolean method_5442() {
        this.method_54873(null);
        return super.method_5442();
    }

    @NotNull
    public class_1799 method_5438(int n) {
        this.method_54873(null);
        return super.method_5438(n);
    }

    @NotNull
    public class_1799 method_5434(int n, int n2) {
        this.method_54873(null);
        return super.method_5434(n, n2);
    }

    @NotNull
    public class_1799 method_5441(int n) {
        this.method_54873(null);
        return super.method_5441(n);
    }

    public void method_5447(int n, class_1799 itemStack) {
        this.method_54873(null);
        super.method_5447(n, itemStack);
    }

    @NotNull
    public class_2371<class_1799> method_54454() {
        this.method_54873(null);
        return this.field_5828;
    }

    public DecorationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Nullable
    public class_5321<class_52> method_54869() {
        ContainerLike containerLike = DecorationData.getFirstContainer(this.blockEntity);
        if (containerLike != null) {
            return containerLike.getLootTable();
        }
        return null;
    }

    public void method_11285(@Nullable class_5321<class_52> resourceKey) {
        ContainerLike containerLike = DecorationData.getFirstContainer(this.blockEntity);
        if (containerLike != null) {
            containerLike.setLootTable(resourceKey);
        }
    }

    public long method_54870() {
        ContainerLike containerLike = DecorationData.getFirstContainer(this.blockEntity);
        if (containerLike != null) {
            return containerLike.getLootTableSeed();
        }
        return 0L;
    }

    public void method_54866(long l) {
        ContainerLike containerLike = DecorationData.getFirstContainer(this.blockEntity);
        if (containerLike != null) {
            containerLike.setLootTableSeed(l);
        }
    }

    @NotNull
    public class_2338 method_11016() {
        return this.blockEntity.method_11016();
    }

    @Nullable
    public class_1937 method_10997() {
        return this.blockEntity.method_10997();
    }

    public static boolean isPickUpContainer(class_1263 container) {
        FilamentContainer filamentContainer;
        ContainerLike containerLike;
        return container instanceof FilamentContainer && (containerLike = DecorationData.getFirstContainer((filamentContainer = (FilamentContainer)container).getBlockEntity())) != null && containerLike.canPickUp();
    }
}

