/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.common.collect.ImmutableList;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class Budding
implements BlockBehaviour<Config>,
class_3737 {
    private final Config config;

    public Budding(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isRandomlyTicking(class_2680 blockState) {
        return true;
    }

    @Override
    public void randomTick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (randomSource.method_43048(101) < this.config.chance) {
            return;
        }
        class_2350 direction = this.config.sides.get(randomSource.method_43048(this.config.sides.size()));
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_2680 blockState2 = serverLevel.method_8320(blockPos2);
        class_2680 state = null;
        if (this.canGrowAndReplace(blockState2)) {
            state = ((class_2248)class_7923.field_41175.method_10223(this.config.grows.getFirst())).method_9564();
        }
        class_2350 dir = this.getFacingOrNull(blockState2);
        class_2350.class_2351 axis = this.getAxisOrNull(blockState2);
        for (int i = 0; i < this.config.grows.size() - 1; ++i) {
            class_2248 currentStage = (class_2248)class_7923.field_41175.method_10223(this.config.grows.get(i));
            if (!blockState2.method_27852(currentStage) || dir != null && dir != direction && axis != null && !axis.method_10176(direction)) continue;
            class_2248 nextStage = (class_2248)class_7923.field_41175.method_10223(this.config.grows.get(i + 1));
            state = nextStage.method_9564();
            break;
        }
        if (state != null) {
            class_2680 finalState = this.setWaterlogged(this.setFacingOrAxis(state, direction), blockState2.method_26227().method_15772() == class_3612.field_15910);
            serverLevel.method_8501(blockPos2, finalState);
        }
    }

    private class_2350.class_2351 getAxisOrNull(class_2680 blockState) {
        ImmutableList props2 = ImmutableList.of((Object)class_2741.field_12496, (Object)class_2741.field_12529);
        for (class_2754 prop : props2) {
            if (!blockState.method_28498((class_2769)prop)) continue;
            return (class_2350.class_2351)blockState.method_11654((class_2769)prop);
        }
        return null;
    }

    private class_2350 getFacingOrNull(class_2680 blockState) {
        ImmutableList props = ImmutableList.of((Object)class_2741.field_12525, (Object)class_2741.field_12481, (Object)class_2741.field_28062, (Object)class_2741.field_12545);
        for (class_2754 prop : props) {
            if (!blockState.method_28498((class_2769)prop)) continue;
            return (class_2350)blockState.method_11654((class_2769)prop);
        }
        return null;
    }

    private class_2680 setFacingOrAxis(class_2680 blockState, class_2350 direction) {
        ImmutableList props = ImmutableList.of((Object)class_2741.field_12525, (Object)class_2741.field_12481, (Object)class_2741.field_28062, (Object)class_2741.field_12545);
        for (class_2754 prop : props) {
            if (!blockState.method_28498((class_2769)prop)) continue;
            return (class_2680)blockState.method_11657((class_2769)prop, (Comparable)direction);
        }
        ImmutableList props2 = ImmutableList.of((Object)class_2741.field_12496, (Object)class_2741.field_12529);
        for (class_2754 prop : props2) {
            if (!blockState.method_28498((class_2769)prop)) continue;
            return (class_2680)blockState.method_11657((class_2769)prop, (Comparable)direction.method_10166());
        }
        return blockState;
    }

    private class_2680 setWaterlogged(class_2680 blockState, boolean waterlogged) {
        if (blockState.method_28498((class_2769)class_2741.field_12508)) {
            return (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged));
        }
        return blockState;
    }

    private boolean canGrowAndReplace(class_2680 blockState) {
        return blockState.method_26215() || ((class_2248)class_7923.field_41175.method_10223(this.config.grows.getFirst())).method_9564().method_28498((class_2769)class_2741.field_12508) && blockState.method_27852(class_2246.field_10382) && blockState.method_26227().method_15761() == 8;
    }

    public static class Config {
        public int chance = 20;
        public List<class_2960> grows = ImmutableList.of((Object)class_2960.method_60656((String)"chain"), (Object)class_2960.method_60656((String)"end_rod"));
        public List<class_2350> sides = Arrays.stream(class_2350.values()).toList();
    }
}

