/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import net.minecraft.class_1303;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;

public class DropXp
implements BlockBehaviour<Config> {
    private final Config config;

    public DropXp(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void spawnAfterBreak(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_1799 itemStack, boolean doSpawn) {
        if (doSpawn) {
            this.spawnXpAfterEnchantCheck(serverLevel, blockPos, itemStack, this.getRange(blockState));
        }
    }

    private class_6017 getRange(class_2680 blockState) {
        if (this.config.max == this.config.min) {
            return class_6016.method_34998((int)this.config.min.getOrDefault(blockState, 0));
        }
        return class_6019.method_35017((int)this.config.min.getOrDefault(blockState, 0), (int)this.config.max.getOrDefault(blockState, 0));
    }

    protected void spawnXpAfterEnchantCheck(class_3218 serverLevel, class_2338 blockPos, class_1799 itemStack, class_6017 intProvider) {
        int i = class_1890.method_60157((class_3218)serverLevel, (class_1799)itemStack, (int)intProvider.method_35008(serverLevel.method_8409()));
        if (i > 0) {
            this.spawnXp(serverLevel, blockPos, i);
        }
    }

    private void spawnXp(class_3218 serverLevel, class_2338 blockPos, int amount) {
        if (serverLevel.method_8450().method_8355(class_1928.field_19392)) {
            class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)blockPos), (int)amount);
        }
    }

    public static class Config {
        public BlockStateMappedProperty<Integer> min = BlockStateMappedProperty.of(0);
        public BlockStateMappedProperty<Integer> max = BlockStateMappedProperty.of(4);
    }
}

