/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.util.ExecuteUtil;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecuteInteractBlock
implements BlockBehaviour<Config> {
    private final Config config;

    public ExecuteInteractBlock(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.runCommandBlock(serverPlayer, blockPos);
            return class_1269.field_5812;
        }
        return BlockBehaviour.super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    @Override
    @Nullable
    public class_1269 useItemOn(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.runCommandBlock(serverPlayer, blockPos);
            return class_1269.field_5812;
        }
        return BlockBehaviour.super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void runCommandBlock(class_3222 user, class_2338 blockPos) {
        List<String> cmds = this.commands();
        if (cmds != null) {
            class_243 pos;
            class_243 class_2432 = pos = this.config.atBlock ? blockPos.method_46558() : null;
            if (this.getConfig().console) {
                ExecuteUtil.asConsole(user, pos, cmds.toArray(new String[0]));
            } else {
                ExecuteUtil.asPlayer(user, pos, cmds.toArray(new String[0]));
            }
            if (this.config.sound != null) {
                class_2960 sound = this.config.sound;
                user.method_37908().method_43129(null, (class_1297)user, (class_3414)class_7923.field_41172.method_10223(sound), class_3419.field_15254, 1.0f, 1.0f);
            }
            if (this.config.consumes) {
                user.method_37908().method_8651(blockPos, this.config.dropBlock, (class_1297)user);
            }
        }
    }

    private List<String> commands() {
        return this.config.commands == null ? (this.config.command == null ? null : List.of(this.config.command)) : this.config.commands;
    }

    public static class Config {
        public boolean consumes;
        public String command;
        public List<String> commands;
        public boolean atBlock = false;
        public boolean dropBlock = false;
        public class_2960 sound;
        public boolean console;
    }
}

