/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.util.BlockUtil;
import de.tomalbrc.filament.util.DecorationUtil;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class Lamp
implements BlockBehaviour<Config> {
    private final Config config;

    public Lamp(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_2680 modifyPolymerBlockState(class_2680 originalBlockState, class_2680 blockState) {
        return this.config.models == Boolean.TRUE ? blockState : (class_2680)blockState.method_11657((class_2769)BlockUtil.LIGHT_LEVEL, (Comparable)Integer.valueOf(0));
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 blockState, class_1750 blockPlaceContext) {
        blockState.method_11657((class_2769)BlockUtil.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.config.cycle != null && !this.config.cycle.isEmpty() ? this.config.cycle.getFirst() : (this.config.defaultValue == null ? this.config.off : this.config.defaultValue)));
        return BlockBehaviour.super.getStateForPlacement(blockState, blockPlaceContext);
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{BlockUtil.LIGHT_LEVEL});
    }

    @Override
    public class_4970.class_2251 modifyBlockProperties(class_4970.class_2251 props) {
        props.method_9631(state -> state.method_28498((class_2769)BlockUtil.LIGHT_LEVEL) ? (Integer)state.method_11654((class_2769)BlockUtil.LIGHT_LEVEL) : 0);
        return props;
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        Integer lightLevel = (Integer)blockState.method_11654((class_2769)BlockUtil.LIGHT_LEVEL);
        if (this.config.cycle != null && !this.config.cycle.isEmpty() && level != null) {
            DecorationBlockEntity decorationBlockEntity;
            int currentIndex = this.config.cycle.indexOf(lightLevel);
            Integer next = this.config.cycle.get((currentIndex + 1) % this.config.cycle.size());
            level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)BlockUtil.LIGHT_LEVEL, (Comparable)next));
            class_2586 class_25862 = level.method_8321(blockPos);
            if (class_25862 instanceof DecorationBlockEntity && (decorationBlockEntity = (DecorationBlockEntity)class_25862).getMainBlockEntity().getDecorationData().hasBlocks() && decorationBlockEntity.getMainBlockEntity().getDecorationData().countBlocks() > 1) {
                DecorationUtil.forEachRotated(decorationBlockEntity.getMainBlockEntity().getDecorationData().blocks(), blockPos, decorationBlockEntity.getMainBlockEntity().rotation, pos -> level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)BlockUtil.LIGHT_LEVEL, (Comparable)next)));
            }
            this.playSound(level, blockPos, blockState);
            return class_1269.field_21466;
        }
        if (level != null) {
            if (lightLevel == this.config.on) {
                level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)BlockUtil.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.config.off)));
            } else {
                level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)BlockUtil.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.config.on)));
            }
            this.playSound(level, blockPos, blockState);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    private void playSound(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (this.config.sound != null) {
            level.method_45447(null, blockPos, class_3414.method_47908((class_2960)this.config.sound.getValue(blockState)), class_3419.field_15245);
        }
    }

    public static class Config {
        int on = 15;
        int off = 0;
        Integer defaultValue = 0;
        List<Integer> cycle;
        Boolean models;
        public BlockStateMappedProperty<class_2960> sound;
    }
}

