/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.item.FilamentItem;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.sgui.api.gui.SignGui;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import net.minecraft.class_8824;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Sign
implements DecorationBehaviour<Config> {
    Config config;
    Map<ConfiguredSignElement, SignData> signData = new Reference2ObjectOpenHashMap();
    boolean isWaxed = false;
    UUID editingPlayer = null;

    public Sign(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_1269 interact(class_3222 player, class_1268 hand, class_243 location, final DecorationBlockEntity decorationBlockEntity) {
        final ConfiguredSignElement e = this.getClosestTextElement(decorationBlockEntity, location);
        final SignData sd = this.getSignData(e);
        if (this.config.canEdit) {
            class_1792 class_17922;
            FilamentItem filamentItem;
            class_1792 class_17923;
            class_1799 itemStack = player.method_5998(hand);
            if (this.config.waxable && !this.isWaxed && (itemStack.method_31574(class_1802.field_20414) || (class_17923 = itemStack.method_7909()) instanceof FilamentItem && (filamentItem = (FilamentItem)class_17923).has(Behaviours.WAX))) {
                class_174.field_24478.method_23889(player, decorationBlockEntity.method_11016(), itemStack);
                player.method_37908().method_8444(null, 3003, decorationBlockEntity.method_11016(), 0);
                if (!itemStack.method_7963()) {
                    itemStack.method_57008(1, (class_1309)player);
                } else {
                    itemStack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                }
                this.isWaxed = true;
                decorationBlockEntity.method_5431();
                return class_1269.field_21466;
            }
            boolean empty = sd.isEmpty();
            if (this.config.dyeable && !empty && (class_17922 = itemStack.method_7909()) instanceof class_1769) {
                class_1769 dyeItem = (class_1769)class_17922;
                if (this.apply(player.method_37908(), decorationBlockEntity, e, dyeItem.method_7802(), sd.glow)) {
                    if (!itemStack.method_7963()) {
                        itemStack.method_57008(1, (class_1309)player);
                    } else {
                        itemStack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                    }
                    return class_1269.field_21466;
                }
            }
            if (!empty && itemStack.method_31574(class_1802.field_28410) && !sd.glow) {
                sd.glow = true;
                player.method_37908().method_8396(null, decorationBlockEntity.method_11016(), class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                this.changed(decorationBlockEntity, e);
                if (!itemStack.method_7963()) {
                    itemStack.method_57008(1, (class_1309)player);
                } else {
                    itemStack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                }
                return class_1269.field_21466;
            }
            if (!(this.isWaxed || player.method_21823() || this.editingPlayer != null && Filament.SERVER.method_3760().method_14602(this.editingPlayer) != null || e == null)) {
                this.editingPlayer = player.method_5667();
                SignGui signGui = new SignGui(player){

                    public void onClose() {
                        for (int i = 0; i < e.lines; ++i) {
                            sd.text[i] = this.getLine(i);
                        }
                        Sign.this.changed(decorationBlockEntity, e);
                        Sign.this.editingPlayer = null;
                        super.onClose();
                    }
                };
                for (int i = 0; i < e.lines; ++i) {
                    signGui.setLine(i, this.getLine(e, i));
                }
                signGui.setSignType(this.config.block);
                signGui.open();
                return class_1269.field_21466;
            }
        }
        if (this.executeClickCommandsIfPresent(player.method_51469(), (class_1657)player, decorationBlockEntity.method_11016(), sd.text)) {
            return class_1269.field_21466;
        }
        return DecorationBehaviour.super.interact(player, hand, location, decorationBlockEntity);
    }

    public boolean executeClickCommandsIfPresent(class_3218 level, class_1657 player, class_2338 blockPos, class_2561[] components) {
        boolean bl2 = false;
        for (class_2561 component : components) {
            class_2583 style = component.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            player.method_5682().method_3734().method_44252(Sign.createCommandSourceStack(player, level, blockPos), clickEvent.method_10844());
            bl2 = true;
        }
        return bl2;
    }

    private static class_2168 createCommandSourceStack(@Nullable class_1657 player, class_3218 serverLevel, class_2338 blockPos) {
        String string = player == null ? "Decoration" : player.method_5477().getString();
        class_5250 component = player == null ? class_2561.method_43470((String)"Decoration") : player.method_5476();
        return new class_2168(class_2165.field_17395, class_243.method_24953((class_2382)blockPos), class_241.field_1340, serverLevel, 2, string, (class_2561)component, serverLevel.method_8503(), (class_1297)player);
    }

    @Override
    public void read(class_2487 output, class_7225.class_7874 lookup, DecorationBlockEntity blockEntity) {
        boolean bl = this.isWaxed = output.method_10545("IsWaxed") && output.method_10577("IsWaxed");
        if (output.method_10545("SignData")) {
            class_2520 tag = output.method_10580("SignData");
            DataResult dec = SignData.CODEC.listOf().decode((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)tag);
            dec.ifSuccess(pair -> {
                List x = (List)pair.getFirst();
                for (int i = 0; i < this.config.elements.size(); ++i) {
                    ConfiguredSignElement signElement = this.config.elements.get(i);
                    this.signData.put(signElement, (SignData)x.get(i));
                    this.changed(blockEntity, signElement);
                }
            });
        }
    }

    @Override
    public void write(class_2487 input, class_7225.class_7874 lookup, DecorationBlockEntity blockEntity) {
        input.method_10556("IsWaxed", this.isWaxed);
        ObjectArrayList data = new ObjectArrayList();
        for (int i = 0; i < this.config.elements.size(); ++i) {
            ConfiguredSignElement signElement = this.config.elements.get(i);
            data.add(i, this.getSignData(signElement));
        }
        input.method_10566("SignData", (class_2520)SignData.CODEC.listOf().encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)data).getOrThrow());
    }

    @Override
    public void applyImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_2586.class_9473 dataComponentGetter) {
        class_9279 data = (class_9279)dataComponentGetter.method_58694(class_9334.field_49628);
        if (data != null) {
            if (data.method_57450("SignData")) {
                class_2487 t = data.method_57461();
                class_2520 sd = t.method_10580("SignData");
                SignData.CODEC.listOf().decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)Filament.SERVER.method_30611()), (Object)sd).ifSuccess(pair -> {
                    List res = (List)pair.getFirst();
                    for (int i = 0; i < this.config.elements.size(); ++i) {
                        ConfiguredSignElement signElement = this.config.elements.get(i);
                        this.signData.put(signElement, (SignData)res.get(i));
                        this.changed(decorationBlockEntity, signElement);
                    }
                });
            }
        } else {
            for (int i = 0; i < this.config.elements.size(); ++i) {
                ConfiguredSignElement signElement = this.config.elements.get(i);
                this.changed(decorationBlockEntity, signElement);
            }
        }
    }

    @Override
    public void collectImplicitComponents(DecorationBlockEntity decorationBlockEntity, class_9323.class_9324 builder) {
        ObjectArrayList data = new ObjectArrayList();
        for (int i = 0; i < this.config.elements.size(); ++i) {
            ConfiguredSignElement signElement = this.config.elements.get(i);
            data.add(i, this.getSignData(signElement));
        }
        builder.method_57840(class_9334.field_49628, (Object)class_9279.field_49302.method_57451(arg_0 -> Sign.lambda$collectImplicitComponents$3((List)data, arg_0)));
    }

    private class_2561 getLine(ConfiguredSignElement element, int i) {
        return this.getSignData((ConfiguredSignElement)element).text[i];
    }

    private SignData getSignData(ConfiguredSignElement element) {
        return this.signData.computeIfAbsent(element, x -> new SignData());
    }

    private void changed(DecorationBlockEntity decorationBlockEntity, ConfiguredSignElement configuredSignElement) {
        decorationBlockEntity.method_5431();
        SignData sd = this.getSignData(configuredSignElement);
        class_5250 c = class_2561.method_43473();
        if (sd.isEmpty() && configuredSignElement.text != null) {
            for (i = 0; i < configuredSignElement.text.length; ++i) {
                c.method_27693("\n").method_10852(configuredSignElement.text[i]);
            }
        } else {
            for (i = 0; i < configuredSignElement.lines; ++i) {
                c.method_27693("\n").method_10852(this.getLine(configuredSignElement, i));
            }
        }
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.rotate((Quaternionfc)configuredSignElement.rotation);
        matrix4f.scale((Vector3fc)configuredSignElement.scale);
        if (sd.display == null) {
            sd.display = new SignLikeTextDisplay();
        }
        SignLikeTextDisplay element = sd.display;
        element.setOffset(new class_243(configuredSignElement.offset.rotateY((float)Math.PI / 180 * -decorationBlockEntity.getVisualRotationYInDegrees(), new Vector3f())));
        element.setSeeThrough(configuredSignElement.seeThrough);
        element.setBackground(configuredSignElement.backgroundColor);
        element.setYaw(decorationBlockEntity.getVisualRotationYInDegrees() + 180.0f);
        element.setDisplaySize(3, 3);
        element.setTransformation(matrix4f);
        element.setBillboardMode(configuredSignElement.billboardMode);
        element.setTextAlignment(configuredSignElement.alignment);
        if (element.getHolder() == null) {
            decorationBlockEntity.getOrCreateHolder().addElement(element);
        }
        element.setText((class_2561)c, sd.color, sd.glow);
        decorationBlockEntity.getOrCreateHolder().tick();
    }

    public ConfiguredSignElement getClosestTextElement(DecorationBlockEntity decorationBlockEntity, class_243 location) {
        if (this.config.elements.size() == 1) {
            return this.config.elements.getFirst();
        }
        double dist = Double.MAX_VALUE;
        ConfiguredSignElement nearest = null;
        for (ConfiguredSignElement element : this.config.elements) {
            class_243 q = decorationBlockEntity.method_11016().method_46558().method_1019(new class_243(this.getTranslation(element).rotateY((-decorationBlockEntity.getVisualRotationYInDegrees() + 180.0f) * ((float)Math.PI / 180))));
            double distance = q.method_1022(location);
            if (!(distance < dist)) continue;
            dist = distance;
            nearest = element;
        }
        return nearest;
    }

    private Vector3f getTranslation(ConfiguredSignElement element) {
        return new Vector3f((Vector3fc)element.offset).sub(0.0f, 0.475f, 0.0f).rotate((Quaternionfc)element.rotation).rotateY((float)Math.PI);
    }

    public boolean apply(class_1937 level, DecorationBlockEntity blockEntity, ConfiguredSignElement element, class_1767 color, boolean glow) {
        boolean changedColor = false;
        SignData sd = this.getSignData(element);
        if (color != null && sd.color != color) {
            sd.color = color;
            changedColor = true;
            level.method_8396(null, blockEntity.method_11016(), class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
        }
        sd.glow = glow;
        this.changed(blockEntity, element);
        return changedColor;
    }

    private static /* synthetic */ void lambda$collectImplicitComponents$3(List data, class_2487 x) {
        SignData.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, (Object)data).ifSuccess(res -> x.method_10566("SignData", res));
    }

    public static class Config {
        public boolean canEdit = true;
        public boolean waxable = true;
        public boolean dyeable = true;
        public class_2248 block = class_2246.field_10121;
        public List<ConfiguredSignElement> elements = List.of();
    }

    public static class ConfiguredSignElement {
        public Vector3f offset = new Vector3f(0.0f, 0.0f, 0.5f);
        public Vector3f scale = new Vector3f(0.5f);
        public Quaternionf rotation = new Quaternionf();
        public int lines = 4;
        public class_2561[] text;
        public class_8113.class_8114 billboardMode = class_8113.class_8114.field_42406;
        public int backgroundColor = 0;
        public boolean seeThrough = false;
        public class_8113.class_8123.class_8124 alignment = class_8113.class_8123.class_8124.field_42450;
    }

    public static class SignData {
        public class_2561[] text = new class_2561[]{class_2561.method_43473(), class_2561.method_43473(), class_2561.method_43473(), class_2561.method_43473()};
        public SignLikeTextDisplay display;
        public boolean glow = false;
        public class_1767 color = class_1767.field_7952;
        public static final Codec<SignData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.listOf().fieldOf("text").forGetter(signData -> List.of(signData.text)), (App)Codec.BOOL.fieldOf("glow").forGetter(signData -> signData.glow), (App)class_1767.field_41600.fieldOf("color").forGetter(signData -> signData.color)).apply((Applicative)instance, (textList, glow, color) -> {
            SignData data = new SignData();
            data.text = textList.toArray(new class_2561[0]);
            data.glow = glow;
            data.color = color;
            return data;
        }));

        private boolean isEmpty() {
            for (class_2561 line : this.text) {
                if (line == null || line.method_44746().isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    public static class SignLikeTextDisplay
    extends TextDisplayElement {
        private static final int CENTER = 4;
        private final TextDisplayElement[] displayText = new TextDisplayElement[9];
        private boolean glow = false;
        private Matrix4f transformation;

        public SignLikeTextDisplay() {
            for (int i = 0; i < this.displayText.length; ++i) {
                TextDisplayElement text = new TextDisplayElement();
                text.setBackground(0);
                text.setInvisible(true);
                this.displayText[i] = text;
            }
        }

        public void setText(class_2561 text, class_1767 color, boolean glow) {
            class_8104 brightness = glow ? class_8104.field_42264 : null;
            this.displayText[4].setText((class_2561)class_2561.method_43473().method_10852(text).method_54663(color.method_7787()));
            this.displayText[4].setBrightness(brightness);
            if (glow) {
                class_5250 background = class_2561.method_43473().method_10852(text).method_54663(SignLikeTextDisplay.getOutlineColor(color));
                for (int i = 0; i < this.displayText.length; ++i) {
                    if (i == 4) continue;
                    this.displayText[i].setText((class_2561)background);
                    this.displayText[i].setBrightness(brightness);
                    if (this.glow || this.getHolder() == null) continue;
                    this.getHolder().addElement((VirtualElement)this.displayText[i]);
                }
            } else if (this.glow && this.getHolder() != null) {
                for (int i = 0; i < this.displayText.length; ++i) {
                    if (i == 4) continue;
                    this.getHolder().removeElement((VirtualElement)this.displayText[i]);
                }
            }
            this.glow = glow;
        }

        public static int getOutlineColor(class_1767 color) {
            if (color == class_1767.field_7963) {
                return -988212;
            }
            int i = color.method_7787();
            int j = (int)((double)class_5253.class_5254.method_27765((int)i) * 0.4);
            int k = (int)((double)class_5253.class_5254.method_27766((int)i) * 0.4);
            int l = (int)((double)class_5253.class_5254.method_27767((int)i) * 0.4);
            return class_5253.class_5254.method_27764((int)0, (int)j, (int)k, (int)l);
        }

        public void setHolder(ElementHolder holder) {
            block5: {
                ElementHolder old;
                block4: {
                    old = this.getHolder();
                    super.setHolder(holder);
                    if (holder == null) break block4;
                    if (this.glow) {
                        holder.addElement((VirtualElement)this.displayText[4]);
                    } else {
                        for (TextDisplayElement x : this.displayText) {
                            holder.addElement((VirtualElement)x);
                        }
                    }
                    break block5;
                }
                if (old == null) break block5;
                for (TextDisplayElement x : this.displayText) {
                    old.removeElement((VirtualElement)x);
                }
            }
        }

        public void startWatching(class_3222 serverPlayer, Consumer<class_2596<class_2602>> consumer) {
        }

        public void stopWatching(class_3222 serverPlayer, Consumer<class_2596<class_2602>> consumer) {
        }

        public void tick() {
            if (this.glow) {
                for (TextDisplayElement x : this.displayText) {
                    x.tick();
                }
            } else {
                this.displayText[4].tick();
            }
        }

        public void setYaw(float yaw) {
            for (TextDisplayElement x : this.displayText) {
                x.setYaw(yaw);
            }
            if (this.transformation != null) {
                this.setTransformation(this.transformation);
            }
        }

        public void setDisplaySize(int x, int y) {
            for (TextDisplayElement e : this.displayText) {
                e.setDisplaySize((float)x, (float)y);
            }
        }

        public IntList getEntityIds() {
            return IntList.of();
        }

        public void notifyMove(class_243 oldPos, class_243 currentPos, class_243 delta) {
        }

        public void setSeeThrough(boolean seeThrough) {
            for (TextDisplayElement e : this.displayText) {
                e.setSeeThrough(seeThrough);
            }
        }

        public void setBackground(int backgroundColor) {
            for (TextDisplayElement e : this.displayText) {
                e.setBackground(backgroundColor);
            }
        }

        public void setTransformation(Matrix4f matrix4f) {
            this.transformation = matrix4f;
            for (int i = 0; i < this.displayText.length; ++i) {
                Matrix4f mat = new Matrix4f((Matrix4fc)matrix4f);
                if (4 == i) {
                    this.displayText[i].setTransformation(mat.translate((Vector3fc)new Vector3f(0.0f, 0.0f, 0.002f)));
                    continue;
                }
                int x = i % 3 - 1;
                int y = i / 3 - 1;
                this.displayText[i].setTransformation(mat.translate((Vector3fc)new Vector3f((float)x / 40.0f, (float)y / 40.0f, 0.0f)));
            }
        }

        public void setBillboardMode(class_8113.class_8114 billboardMode) {
            for (TextDisplayElement e : this.displayText) {
                e.setBillboardMode(billboardMode);
            }
        }

        public void setTextAlignment(class_8113.class_8123.class_8124 alignment) {
            for (TextDisplayElement e : this.displayText) {
                e.setTextAlignment(alignment);
            }
        }

        public void setOffset(class_243 offset) {
            for (TextDisplayElement e : this.displayText) {
                e.setOffset(offset);
            }
        }
    }
}

