/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.entity.goal;

import de.tomalbrc.filament.api.behaviour.EntityBehaviour;
import de.tomalbrc.filament.entity.FilamentMob;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FollowMobGoal
implements EntityBehaviour<Config> {
    private final Config config;

    public FollowMobGoal(Config config) {
        this.config = config;
    }

    @Override
    public void registerGoals(FilamentMob mob) {
        EntityBehaviour.super.registerGoals(mob);
        mob.getGoalSelector().method_6277(this.config.priority, (class_1352)new FollowMobGoalImpl((class_1308)mob, this.config.speedModifier, this.config.stopDistance, this.config.areaSize));
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        int priority;
        float speedModifier = 1.0f;
        float stopDistance;
        float areaSize;
    }

    public static class FollowMobGoalImpl
    extends class_1352 {
        private final class_1308 mob;
        private final Predicate<class_1308> followPredicate;
        @Nullable
        private class_1308 followingMob;
        private final double speedModifier;
        private final class_1408 navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private float oldWaterCost;
        private final float areaSize;

        public FollowMobGoalImpl(class_1308 mob, double speedModifier, float stopDistance, float areaSize) {
            this.mob = mob;
            this.followPredicate = mob2 -> mob2 != null && mob.method_5864() != mob2.method_5864();
            this.speedModifier = speedModifier;
            this.navigation = mob.method_5942();
            this.stopDistance = stopDistance;
            this.areaSize = areaSize;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            if (!(mob.method_5942() instanceof class_1409) && !(mob.method_5942() instanceof class_1407)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
            }
        }

        public boolean method_6264() {
            List list = this.mob.method_37908().method_8390(class_1308.class, this.mob.method_5829().method_1014((double)this.areaSize), this.followPredicate);
            if (!list.isEmpty()) {
                for (class_1308 mob : list) {
                    if (mob.method_5767()) continue;
                    this.followingMob = mob;
                    return true;
                }
            }
            return false;
        }

        public boolean method_6266() {
            return this.followingMob != null && !this.navigation.method_6357() && this.mob.method_5858((class_1297)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.mob.method_5944(class_7.field_18);
            this.mob.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.followingMob = null;
            this.navigation.method_6340();
            this.mob.method_5941(class_7.field_18, this.oldWaterCost);
        }

        public void method_6268() {
            if (this.followingMob != null && !this.mob.method_60953()) {
                this.mob.method_5988().method_6226((class_1297)this.followingMob, 10.0f, (float)this.mob.method_5978());
                if (--this.timeToRecalcPath <= 0) {
                    double zDelta;
                    double yDelta;
                    this.timeToRecalcPath = this.method_38847(10);
                    double xDelta = this.mob.method_23317() - this.followingMob.method_23317();
                    double len = xDelta * xDelta + (yDelta = this.mob.method_23318() - this.followingMob.method_23318()) * yDelta + (zDelta = this.mob.method_23321() - this.followingMob.method_23321()) * zDelta;
                    if (!(len <= (double)(this.stopDistance * this.stopDistance))) {
                        this.navigation.method_6335((class_1297)this.followingMob, this.speedModifier);
                    } else {
                        this.navigation.method_6340();
                        class_1333 lookControl = this.followingMob.method_5988();
                        if (len <= (double)this.stopDistance || lookControl.method_6225() == this.mob.method_23317() && lookControl.method_6227() == this.mob.method_23318() && lookControl.method_6228() == this.mob.method_23321()) {
                            double xd = this.followingMob.method_23317() - this.mob.method_23317();
                            double zd = this.followingMob.method_23321() - this.mob.method_23321();
                            this.navigation.method_6337(this.mob.method_23317() - xd, this.mob.method_23318(), this.mob.method_23321() - zd, this.speedModifier);
                        }
                    }
                }
            }
        }
    }
}

