/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.item.Cosmetic;
import de.tomalbrc.filament.trim.FilamentTrimPatterns;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5151;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8055;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Armor
implements ItemBehaviour<Config> {
    private final Config config;
    private PolymerArmorModel armorModel;
    private FilamentTrimPatterns.FilamentTrimHolder trimHolder;

    public Armor(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(class_1792 item, BehaviourHolder behaviourHolder) {
        if (!this.config.trim && this.config.texture != null) {
            this.armorModel = PolymerResourcePackUtils.requestArmor((class_2960)this.config.texture);
        } else if (this.config.texture != null) {
            this.trimHolder = FilamentTrimPatterns.addConfig(this.config);
        }
        class_2315.method_10009((class_1935)item, (class_2357)class_1738.field_7879);
    }

    @Override
    public void modifyPolymerItemStack(Map<String, class_2960> modelMap, class_1799 original, class_1799 polymer, class_1836 tooltipFlag, class_7225.class_7874 lookup, class_3222 player) {
        if (this.trimHolder != null) {
            polymer.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)((class_7225.class_7226)lookup.method_46759(class_7924.field_42083).orElseThrow()).method_46746(class_8055.field_42004).orElseThrow(), this.trimHolder.trimPattern, false));
        }
    }

    @Override
    public int modifyPolymerArmorColor(class_1799 itemStack, @Nullable class_3222 player, int color) {
        return this.armorModel != null ? this.armorModel.color() : color;
    }

    @Override
    public class_1271<class_1799> use(class_1792 item, class_1937 level, class_1657 player, class_1268 interactionHand) {
        if (item instanceof class_5151) {
            return Cosmetic.swapWithEquipmentSlot(item, level, player, interactionHand);
        }
        return ItemBehaviour.super.use(item, level, player, interactionHand);
    }

    @Override
    @NotNull
    public class_1304 getEquipmentSlot() {
        return this.config.slot;
    }

    public static class Config {
        public class_1304 slot;
        public class_2960 texture;
        public boolean trim = false;
    }
}

