/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.cosmetic;

import de.tomalbrc.filament.behaviour.item.Cosmetic;
import de.tomalbrc.filament.cosmetic.CosmeticInterface;
import de.tomalbrc.filament.cosmetic.CosmeticUtil;
import de.tomalbrc.filament.util.FilamentConfig;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.impl.EntityExt;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2716;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4050;
import net.minecraft.class_8042;
import net.minecraft.class_811;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CosmeticHolder
extends ElementHolder {
    private final class_1309 entity;
    private final ItemDisplayElement displayElement;
    boolean hidden = false;

    private CosmeticInterface access() {
        return (CosmeticInterface)this.entity;
    }

    public CosmeticHolder(class_1309 entity, class_1799 itemStack) {
        this.entity = entity;
        this.displayElement = new ItemDisplayElement(itemStack.method_7972());
        this.displayElement.setInvisible(true);
        Cosmetic.Config cosmeticData = CosmeticUtil.getCosmeticData(itemStack);
        if (cosmeticData != null) {
            this.displayElement.setModelTransformation(cosmeticData.display);
            this.displayElement.setLeftRotation((Quaternionfc)cosmeticData.rotation);
            this.displayElement.setTranslation((Vector3fc)cosmeticData.translation);
            this.displayElement.setScale((Vector3fc)cosmeticData.scale);
            if (FilamentConfig.getInstance().alternativeCosmeticPlacement) {
                this.displayElement.setModelTransformation(class_811.field_4316);
                this.displayElement.setTranslation((Vector3fc)new Vector3f(0.0f, 1.25f, 0.0f));
                this.displayElement.setScale((Vector3fc)new Vector3f(0.625f));
            }
        }
        this.displayElement.setTeleportDuration(1);
        this.displayElement.ignorePositionUpdates();
        this.addElement((VirtualElement)this.displayElement);
    }

    public void onTick() {
        class_3222 serverPlayer;
        class_1309 class_13092;
        if (this.entity.method_29504() || this.entity.method_31481()) {
            this.destroy();
        }
        if (this.entity.method_18376() == class_4050.field_18079 || this.entity.method_18376() == class_4050.field_18078 || (class_13092 = this.entity) instanceof class_3222 && (serverPlayer = (class_3222)class_13092).method_7325()) {
            if (!this.hidden) {
                CosmeticHolder.hideForAll(this);
                this.hidden = true;
            }
        } else {
            if (this.hidden) {
                CosmeticHolder.showForAll(this);
                this.updatePosition();
                class_2752 packet = VirtualEntityUtils.createRidePacket((int)this.entity.method_5628(), (IntList)((EntityExt)this.entity).polymerVE$getVirtualRidden());
                this.sendPacket((class_2596)packet);
                this.hidden = false;
            }
            this.displayElement.setYaw(this.access().filament$bodyYaw());
            this.displayElement.setPitch(this.entity.method_5715() ? 25.0f : 0.0f);
            if (FilamentConfig.getInstance().alternativeCosmeticPlacement) {
                this.displayElement.setTranslation((Vector3fc)new Vector3f(0.0f, this.entity.method_5715() ? 1.325f : 1.25f, this.entity.method_5715() ? 0.15f : 0.0f));
            } else {
                Cosmetic.Config cosmeticData = CosmeticUtil.getCosmeticData(this.displayElement.getItem());
                this.displayElement.setTranslation((Vector3fc)cosmeticData.translation.add((Vector3fc)new Vector3f(0.0f, 0.0f, this.entity.method_5715() ? 0.15f : 0.0f), new Vector3f()));
            }
        }
        super.onTick();
    }

    protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
    }

    public static void hideForAll(ElementHolder elementHolder) {
        for (class_3244 player : elementHolder.getWatchingPlayers()) {
            player.method_14364((class_2596)new class_2716(elementHolder.getEntityIds()));
        }
    }

    public static void showForAll(ElementHolder elementHolder) {
        for (class_3244 player : elementHolder.getWatchingPlayers()) {
            ObjectArrayList packets = new ObjectArrayList();
            for (VirtualElement e : elementHolder.getElements()) {
                Objects.requireNonNull(packets);
                e.startWatching(player.field_14140, arg_0 -> ((ObjectArrayList)packets).add(arg_0));
            }
            player.method_14364((class_2596)new class_8042((Iterable)packets));
        }
    }

    public class_243 getPos() {
        return this.entity instanceof class_3222 ? this.entity.method_19538() : this.entity.method_33571();
    }
}

