/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data;

import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.data.resource.ResourceProvider;
import de.tomalbrc.filament.util.FilamentBlockResourceUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockData
extends AbstractBlockData<BlockProperties> {
    @Nullable
    private final BlockStateMappedProperty<BlockModelType> blockModelType;

    public BlockData(@NotNull class_2960 id, @Nullable class_1792 vanillaItem, @Nullable Map<String, String> translations, @Nullable class_2561 displayName, @Nullable ItemResource itemResource, @Nullable Integer itemModel, @Nullable BehaviourConfigMap behaviourConfig, @Nullable class_9323 components, @Nullable class_2960 itemGroup, @NotNull BlockResource blockResource, @Nullable BlockStateMappedProperty<BlockModelType> blockModelType, @Nullable BlockProperties properties, @Nullable Set<class_2960> itemTags, @Nullable Set<class_2960> blockTags) {
        super(id, vanillaItem, translations, displayName, itemResource, blockResource, itemModel, behaviourConfig, components, itemGroup, properties, itemTags, blockTags);
        this.blockModelType = blockModelType;
    }

    @Override
    @NotNull
    public BlockProperties properties() {
        if (this.properties == null) {
            this.properties = new BlockProperties();
        }
        return (BlockProperties)this.properties;
    }

    @Override
    public boolean virtual() {
        return this.properties().virtual;
    }

    @Override
    public Map<class_2680, BlockStateMeta> createStandardStateMap() {
        Reference2ReferenceArrayMap val = new Reference2ReferenceArrayMap();
        if (this.blockResource() != null && this.blockResource().models() != null && this.blockModelType != null) {
            for (Map.Entry<String, PolymerBlockModel> entry : this.blockResource().models().entrySet()) {
                if (entry.getKey().equals("default")) {
                    BlockModelType type = this.safeBlockModelType(this.blockModelType.getRawValue());
                    class_2680 requestedState = type == null ? null : FilamentBlockResourceUtils.requestBlock(type, entry.getValue(), this.virtual());
                    val.put((Object)((class_2248)class_7923.field_41175.method_10223(this.id)).method_9564(), (Object)BlockStateMeta.of(type == null ? class_2246.field_9987.method_9564() : requestedState, entry.getValue()));
                    continue;
                }
                class_2680 state = BlockData.blockState(String.format("%s[%s]", this.id, entry.getKey()));
                BlockModelType type = this.safeBlockModelType(this.blockModelType.getOrDefault(state, BlockModelType.FULL_BLOCK));
                class_2680 requestedState = type == null ? null : FilamentBlockResourceUtils.requestBlock(type, entry.getValue(), this.virtual());
                val.put((Object)state, (Object)BlockStateMeta.of(type == null ? class_2246.field_9987.method_9564() : requestedState, entry.getValue()));
            }
        }
        return val;
    }

    @Override
    @NotNull
    public ResourceProvider preferredResource() {
        return this.blockResource();
    }

    @Nullable
    public BlockStateMappedProperty<BlockModelType> blockModelType() {
        return this.blockModelType;
    }

    @Override
    public Object2ObjectOpenHashMap<String, PolymerModelData> requestModels() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        if (this.itemResource != null) {
            this.itemResource.getModels().forEach((key, value) -> map.put(key, (Object)PolymerResourcePackUtils.requestModel((class_1792)(this.vanillaItem == null ? class_1802.field_8407 : this.vanillaItem), (class_2960)value)));
        } else if (this.blockResource() != null) {
            this.blockResource().getModels().forEach((key, value) -> map.put(key, (Object)PolymerResourcePackUtils.requestModel((class_1792)(this.vanillaItem == null ? class_1802.field_8407 : this.vanillaItem), (class_2960)value)));
        }
        return map;
    }

    @Override
    public String toString() {
        return "BlockData[id=" + String.valueOf(this.id) + ", vanillaItem=" + String.valueOf(this.vanillaItem) + ", blockResource=" + String.valueOf(this.blockResource()) + ", itemResource=" + String.valueOf(this.itemResource) + ", blockModelType=" + String.valueOf(this.blockModelType) + ", properties=" + String.valueOf(this.properties) + ", behaviourConfig=" + String.valueOf(this.behaviour) + ", components=" + String.valueOf(this.components) + ", itemGroup=" + String.valueOf(this.group) + "]";
    }

    public record BlockStateMeta(class_2680 blockState, PolymerBlockModel polymerBlockModel) {
        public static BlockStateMeta of(class_2680 blockState, PolymerBlockModel blockModel) {
            return new BlockStateMeta(blockState, blockModel);
        }
    }
}

