/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.datafixer.fix;

import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.datafixer.DataFix;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.util.BlockUtil;
import de.tomalbrc.filament.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1208;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2841;
import net.minecraft.class_2960;

public class ChangeVersionAndRotationState
extends com.mojang.datafixers.DataFix {
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());

    public ChangeVersionAndRotationState(Schema outputSchema) {
        super(outputSchema, true);
    }

    public static com.mojang.datafixers.DataFix create(Schema outputSchema) {
        return new ChangeVersionAndRotationState(outputSchema);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(class_1208.field_5726);
        Type type2 = this.getOutputSchema().getType(class_1208.field_5726);
        return this.writeFixAndRead("UpdateFilamentDecorations", type, type2, this::fix);
    }

    private Dynamic<?> fix(Dynamic<?> dynamic) {
        try {
            List blockEntities = dynamic.get("block_entities").asList(dyn -> dyn.castTyped((DynamicOps)class_2509.field_11560));
            if (blockEntities == null || blockEntities.isEmpty()) {
                return dynamic;
            }
            List sections = dynamic.get("sections").asList(dyn -> dyn.castTyped((DynamicOps)class_2509.field_11560));
            OptionalDynamic blendingData = dynamic.get("blending_data");
            int min = blendingData.get("min_section").asInt(-4);
            HashMap<Integer, List> map = new HashMap<Integer, List>();
            for (Dynamic blockEntity : blockEntities) {
                OptionalDynamic v;
                DataResult id = blockEntity.get("id").read((Decoder)class_2960.field_25139);
                if (id.isError() || (v = blockEntity.get("V")) == null || v.get().isError()) continue;
                int version = v.asInt(0);
                if (((class_2960)id.getOrThrow()).method_12836().equals("minecraft") || version >= DataFix.VERSION) continue;
                int yData = blockEntity.get("y").asInt(0);
                int idx = (yData - min * 16) / 16;
                map.computeIfAbsent(idx, x -> new ArrayList()).add(blockEntity);
            }
            if (!map.isEmpty()) {
                for (Integer idx : map.keySet()) {
                    List entries = (List)map.get(idx);
                    Dynamic section = (Dynamic)sections.get(idx);
                    OptionalDynamic states = section.get("block_states");
                    class_2841 palettedContainer = (class_2841)states.read((Decoder)class_2487.field_25128).mapOrElse(tag -> (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, tag).promotePartial(string -> {}).getOrThrow(), tagError -> new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569));
                    for (Dynamic blockEntityData : entries) {
                        int yData = blockEntityData.get("y").asInt(0);
                        int x2 = blockEntityData.get("x").asInt(0) & 0xF;
                        int y = yData & 0xF;
                        int z = blockEntityData.get("z").asInt(0) & 0xF;
                        class_2350 dir = class_2350.method_10143((int)blockEntityData.get("Direction").asInt(class_2350.field_11036.method_10146()));
                        OptionalDynamic rot = blockEntityData.get("Rotation");
                        class_2680 state = (class_2680)palettedContainer.method_12321(x2, y, z);
                        if (state.method_26204() instanceof DecorationBlock && state.method_28498((class_2769)BlockUtil.ROTATION)) {
                            state = (class_2680)state.method_11657((class_2769)BlockUtil.ROTATION, (Comparable)Integer.valueOf(Util.SEGMENTED_ANGLE8.method_48125(DataFix.getVisualRotationYInDegrees(dir, rot.asInt(0)))));
                            palettedContainer.method_12328(x2, y, z, (Object)state);
                        }
                        Dynamic upgradedBlockEntityData = blockEntityData.set("V", dynamic.createInt(2)).remove("Rotation");
                        blockEntities.set(blockEntities.indexOf(blockEntityData), upgradedBlockEntityData);
                    }
                    DataResult result = BLOCK_STATE_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)palettedContainer);
                    class_2520 tag2 = (class_2520)result.getOrThrow();
                    section = section.replaceField("block_states", "block_states", Optional.of(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag2)));
                    sections.set(idx, section);
                }
                dynamic = dynamic.set("block_entities", dynamic.createList(blockEntities.stream())).set("sections", dynamic.createList(sections.stream()));
            }
        }
        catch (Exception e) {
            Filament.LOGGER.info("Error during data fix", (Throwable)e);
        }
        return dynamic;
    }
}

