/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.block;

import com.mojang.authlib.GameProfile;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.api.behaviour.DecorationRotationProvider;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.util.VirtualDestroyStage;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.virtualentity.api.BlockWithElementHolder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public abstract class DecorationBlock
extends SimpleBlock
implements PolymerBlock,
BlockWithElementHolder,
class_3737,
VirtualDestroyStage.Marker {
    protected final class_2960 decorationId;
    protected final DecorationData data;
    protected final Map<BlockData.BlockStateMeta, String> cmdMap = new Reference2ObjectOpenHashMap();

    public DecorationBlock(class_4970.class_2251 properties, DecorationData data) {
        super(properties, data);
        this.decorationId = data.id();
        this.data = data;
    }

    @Override
    public void postRegister() {
        this.stateMap = this.data.createStandardStateMap();
        BlockResource resource = this.blockData.blockResource();
        if (resource != null) {
            for (Map.Entry stateMapEntry : this.stateMap.entrySet()) {
                for (Map.Entry<String, class_2960> blockResourceModelsEntry : resource.getModels().entrySet()) {
                    boolean same = blockResourceModelsEntry.getValue().equals((Object)((BlockData.BlockStateMeta)stateMapEntry.getValue()).polymerBlockModel().model());
                    if (!same) continue;
                    this.cmdMap.put((BlockData.BlockStateMeta)stateMapEntry.getValue(), blockResourceModelsEntry.getKey());
                }
            }
        }
        this.stateDefinitionEx.method_11662().forEach(class_4970.class_4971::method_26200);
    }

    public DecorationData getDecorationData() {
        return this.data;
    }

    public class_2680 getPolymerBlockState(class_2680 state, class_3222 packetContext) {
        DecorationData decorationData = this.getDecorationData();
        if (decorationData != null) {
            boolean waterlogged;
            boolean passthrough = !decorationData.hasBlocks();
            class_2680 newState = state;
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour)) continue;
                BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
                newState = blockBehaviour.modifyPolymerBlockState(state, newState);
            }
            class_2680 customBlock = decorationData.block(state);
            class_2680 blockState = customBlock == null ? (passthrough ? class_2246.field_10124.method_9564() : class_2246.field_10499.method_9564()) : customBlock;
            boolean bl = waterlogged = newState.method_28498((class_2769)class_2741.field_12508) && (Boolean)newState.method_11654((class_2769)class_2741.field_12508) != false;
            if (passthrough && waterlogged) {
                return class_2246.field_10382.method_9564();
            }
            if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged));
            }
            return blockState;
        }
        return super.getPolymerBlockState(state, packetContext);
    }

    @Override
    public void method_55124(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        class_1657 player;
        class_1297 class_12972 = explosion.method_46406();
        if (class_12972 instanceof class_1657 && !CommonProtection.canExplodeBlock((class_1937)level, (class_2338)blockPos, (class_1927)explosion, (GameProfile)(player = (class_1657)class_12972).method_7334(), (class_1657)player)) {
            return;
        }
        if (!(explosion.method_55111() != class_1927.class_4179.field_18687 && explosion.method_55111() != class_1927.class_4179.field_40879 || blockState.method_26215())) {
            this.removeDecoration(level, blockPos, null);
            this.method_9586(level, blockPos, explosion);
        }
    }

    @Override
    @NotNull
    public class_2680 method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        class_2680 returnVal = super.method_9576(level, blockPos, blockState, player);
        this.removeDecoration(level, blockPos, player);
        return returnVal;
    }

    protected void removeDecoration(class_1937 level, class_2338 blockPos, class_1657 player) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof DecorationBlockEntity) {
            DecorationBlockEntity decorationBlockEntity = (DecorationBlockEntity)blockEntity;
            if (player != null) {
                for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : decorationBlockEntity.getBehaviours()) {
                    Behaviour<?> behaviour2 = behaviour.getValue();
                    if (!(behaviour2 instanceof DecorationBehaviour)) continue;
                    DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
                    decorationBehaviour.postBreak(decorationBlockEntity, blockPos, player);
                }
            }
            decorationBlockEntity.destroyStructure(player == null || !player.method_56992());
        } else {
            level.method_22352(blockPos, false);
        }
    }

    @NotNull
    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        if (!this.getDecorationData().hasBlocks()) {
            return class_259.method_1073();
        }
        return super.method_9549(blockState, blockGetter, blockPos, collisionContext);
    }

    public float getVisualRotationYInDegrees(class_2680 blockState) {
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof DecorationBlock) {
            DecorationBlock decorationBlock = (DecorationBlock)class_22482;
            for (Map.Entry behaviour : decorationBlock.getBehaviours()) {
                Object v = behaviour.getValue();
                if (!(v instanceof DecorationRotationProvider)) continue;
                DecorationRotationProvider rotationProvider = (DecorationRotationProvider)v;
                return rotationProvider.getVisualRotationYInDegrees(blockState);
            }
        }
        return 0.0f;
    }

    public abstract class_1799 visualItemStack(class_4538 var1, class_2338 var2, class_2680 var3);
}

