/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.block.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.BehaviourMap;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.decoration.block.DecorationBlock;
import de.tomalbrc.filament.decoration.block.entity.AbstractDecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.DecorationHolder;
import de.tomalbrc.filament.decoration.holder.FilamentDecorationHolder;
import de.tomalbrc.filament.decoration.util.BlockEntityWithElementHolder;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.registry.OxidizableRegistry;
import de.tomalbrc.filament.util.BlockUtil;
import de.tomalbrc.filament.util.DecorationUtil;
import de.tomalbrc.filament.util.FilamentConfig;
import de.tomalbrc.filament.util.Util;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class DecorationBlockEntity
extends AbstractDecorationBlockEntity
implements BlockEntityWithElementHolder,
BehaviourHolder {
    private final BehaviourMap behaviours = new BehaviourMap();
    private Boolean replaceable;
    @Nullable
    private FilamentDecorationHolder decorationHolder;

    public DecorationBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state);
    }

    @Override
    public BehaviourMap getBehaviours() {
        return this.behaviours;
    }

    @Override
    public void method_11014(class_2487 input, class_7225.class_7874 lookup) {
        super.method_11014(input, lookup);
        if (this.isMain() || this.main == null) {
            this.loadMain(input, lookup);
        }
    }

    public void loadMain(class_2487 input, class_7225.class_7874 lookup) {
        DecorationData decorationData = this.getDecorationData();
        if (decorationData == null) {
            Filament.LOGGER.error("No decoration data for {}!", (Object)this.getItem().method_7909().method_7876());
        }
        if (input.method_10545("Item")) {
            class_1799.field_24671.decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup), (Object)input.method_10580("Item")).ifSuccess(r -> {
                class_1799 item = (class_1799)r.getFirst();
                this.method_58683(item);
            });
        }
        this.setupBehaviour(this.getDecorationData());
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.behaviours) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour;
            decorationBehaviour.read(input, (class_7225.class_7874)Filament.SERVER.method_30611(), this);
        }
    }

    @Override
    public void method_11007(class_2487 output, class_7225.class_7874 lookup) {
        super.method_11007(output, lookup);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry : this.behaviours) {
            Behaviour<?> behaviour = entry.getValue();
            if (!(behaviour instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour;
            decorationBehaviour.write(output, lookup, this);
        }
    }

    @Override
    public FilamentDecorationHolder getOrCreateHolder() {
        DecorationBehaviour decorationBehaviour;
        Map.Entry<BehaviourType<?, ?>, Behaviour<?>> entry;
        Behaviour<?> behaviour;
        if (this.decorationHolder != null) {
            return this.decorationHolder;
        }
        FilamentDecorationHolder holder = null;
        Iterator<Map.Entry<BehaviourType<?, ?>, Behaviour<?>>> iterator = this.behaviours.iterator();
        while (iterator.hasNext() && (!((behaviour = (entry = iterator.next()).getValue()) instanceof DecorationBehaviour) || (holder = (decorationBehaviour = (DecorationBehaviour)behaviour).createHolder(this)) == null)) {
        }
        if (holder == null) {
            holder = new DecorationHolder(this::getItem);
            DecorationUtil.setupElements(holder, this.getDecorationData(), this.direction, this.getVisualRotationYInDegrees(), this.visualItemStack(this.method_11010()), this::interact);
        }
        this.decorationHolder = holder;
        return this.decorationHolder;
    }

    @Override
    public void attach(class_2818 chunk) {
        if (this.main == null) {
            this.main = class_2338.field_10980;
        }
        if (this.isMain()) {
            this.setupBehaviour(this.getDecorationData());
            FilamentDecorationHolder holder = this.getOrCreateHolder();
            if (holder != null && holder.getAttachment() == null) {
                BlockBoundAttachment blockBoundAttachment = new BlockBoundAttachment(holder.asPolymerHolder(), chunk, this.method_11010(), this.method_11016(), this.method_11016().method_46558(), holder.isAnimated());
            }
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviourEntry : this.behaviours) {
                Behaviour<?> behaviour = behaviourEntry.getValue();
                if (!(behaviour instanceof DecorationBehaviour)) continue;
                DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour;
                decorationBehaviour.onHolderAttach(this, this.decorationHolder);
            }
        }
    }

    public void setupBehaviour(DecorationData decorationData) {
        if (this.isMain() && this.behaviours.isEmpty()) {
            this.initBehaviours(decorationData.behaviour());
        }
    }

    @Override
    public void initBehaviours(BehaviourConfigMap behaviourConfigMap) {
        BehaviourHolder.super.initBehaviours(behaviourConfigMap);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            decorationBehaviour.init(this);
        }
    }

    public class_1269 interact(class_1657 player, class_1268 interactionHand, class_243 location) {
        return this.decorationInteract((class_3222)player, interactionHand, location);
    }

    public class_1269 decorationInteract(class_3222 player, class_1268 interactionHand, class_243 location) {
        DecorationBehaviour decorationBehaviour;
        Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour;
        Behaviour<?> behaviour2;
        boolean adventureCheck;
        boolean bl = adventureCheck = FilamentConfig.getInstance().preventAdventureModeDecorationInteraction && !this.getDecorationData().properties().allowAdventureMode && player.field_13974.method_14257() == class_1934.field_9216;
        if (adventureCheck || !CommonProtection.canInteractBlock((class_1937)player.method_37908(), (class_2338)class_2338.method_49638((class_2374)location), (GameProfile)player.method_7334(), (class_1657)player)) {
            return class_1269.field_5814;
        }
        if (!this.isMain()) {
            return this.getMainBlockEntity().decorationInteract(player, interactionHand, location);
        }
        DecorationData decorationData = this.getDecorationData();
        if (decorationData == null) {
            Filament.LOGGER.warn("Can't interact with decoration: Missing decoration data! Location: {}", (Object)location.toString());
            return class_1269.field_5814;
        }
        class_1269 res = class_1269.field_5811;
        Iterator<Map.Entry<BehaviourType<?, ?>, Behaviour<?>>> iterator = this.behaviours.iterator();
        while (!(!iterator.hasNext() || (behaviour2 = (behaviour = iterator.next()).getValue()) instanceof DecorationBehaviour && (res = (decorationBehaviour = (DecorationBehaviour)behaviour2).interact(player, interactionHand, location, this)).method_23665())) {
        }
        return res;
    }

    public class_1799 visualItemStack(class_2680 blockState) {
        class_1799 adjusted = DecorationUtil.placementAdjustedItem(this.getItem(), this.getDecorationData().itemResource(), this.direction != class_2350.field_11033 && this.direction != class_2350.field_11036, this.direction == class_2350.field_11033);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            adjusted = decorationBehaviour.visualItemStack(this, adjusted, blockState);
        }
        return adjusted;
    }

    @Override
    protected void destroyBlocks(class_1799 particleItem) {
        class_2680 decorationBlockState = this.method_11010();
        if (DecorationRegistry.isDecoration(decorationBlockState) && this.getDecorationData() != null) {
            DecorationData data = this.getDecorationData();
            if (data.hasBlocks()) {
                DecorationUtil.forEachRotated(data.blocks(), this.method_11016(), this.getVisualRotationYInDegrees(), blockPos -> {
                    if (this.method_10997() != null && DecorationRegistry.isDecoration(this.method_10997().method_8320(blockPos))) {
                        if (data.properties().showBreakParticles) {
                            DecorationUtil.showBreakParticle((class_3218)this.field_11863, data.properties().useItemParticles ? particleItem : this.getDecorationData().properties().blockBase.method_8389().method_7854(), (float)blockPos.method_46558().method_10216(), (float)blockPos.method_46558().method_10214(), (float)blockPos.method_46558().method_10215());
                        }
                        this.method_10997().method_22352(blockPos, false);
                        this.method_10997().method_8544(this.method_11016());
                    }
                });
            } else {
                assert (this.field_11863 != null);
                class_2338 blockPos2 = this.method_11016();
                if (data.properties().showBreakParticles) {
                    DecorationUtil.showBreakParticle((class_3218)this.field_11863, this.getDecorationData().properties().useItemParticles ? particleItem : this.getDecorationData().properties().blockBase.method_8389().method_7854(), (float)blockPos2.method_46558().method_10216(), (float)blockPos2.method_46558().method_10214(), (float)blockPos2.method_46558().method_10215());
                }
                BlockUtil.playBreakSound(this.field_11863, this.method_11016(), this.method_11010());
                this.field_11863.method_22352(this.method_11016(), true);
                this.field_11863.method_8544(this.method_11016());
            }
        }
    }

    @Override
    public void destroyStructure(boolean dropItem) {
        class_1799 thisItemStack;
        class_1799 visualStack = this.getBlock().visualItemStack((class_4538)this.field_11863, this.method_11016(), this.method_11010());
        if (!this.isMain()) {
            class_2586 class_25862;
            if (this.method_10997() != null && this.main != null && (class_25862 = this.method_10997().method_8321(this.method_11016().method_10059((class_2382)this.main))) instanceof DecorationBlockEntity) {
                DecorationBlockEntity mainBlockEntity = (DecorationBlockEntity)class_25862;
                mainBlockEntity.destroyStructure(dropItem);
            }
            return;
        }
        if (!this.getDecorationData().properties().drops) {
            dropItem = false;
        }
        if ((thisItemStack = this.getItem()) != null && !thisItemStack.method_7960()) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof DecorationBehaviour)) continue;
                DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
                if (dropItem) {
                    decorationBehaviour.modifyDrop(this, thisItemStack);
                }
                decorationBehaviour.destroy(this, dropItem);
            }
            if (dropItem) {
                thisItemStack.method_57365(this.method_58693());
                Util.spawnAtLocation(this.method_10997(), this.method_11016().method_46558(), thisItemStack.method_7972());
            }
        }
        this.removeHolder(this.decorationHolder);
        this.destroyBlocks(visualStack);
    }

    private void removeHolder(FilamentDecorationHolder holder) {
        if (holder != null && holder.getAttachment() != null) {
            holder.getAttachment().destroy();
        }
    }

    public DecorationBlock getBlock() {
        return (DecorationBlock)this.method_11010().method_26204();
    }

    public DecorationData getDecorationData() {
        return this.getBlock().getDecorationData();
    }

    public class_2680 updateShape(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            decorationBehaviour.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
        }
        return blockState;
    }

    protected void method_57568(class_2586.class_9473 dataComponentGetter) {
        super.method_57568(dataComponentGetter);
        this.setupBehaviour(this.getDecorationData());
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            decorationBehaviour.applyImplicitComponents(this, dataComponentGetter);
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            decorationBehaviour.collectImplicitComponents(this, builder);
        }
    }

    public void method_57569(class_2487 valueOutput) {
        super.method_57569(valueOutput);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.behaviours) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof DecorationBehaviour)) continue;
            DecorationBehaviour decorationBehaviour = (DecorationBehaviour)behaviour2;
            decorationBehaviour.removeComponentsFromTag(this, valueOutput, (class_7225.class_7874)Filament.SERVER.method_30611());
        }
    }

    public boolean replaceable() {
        if (this.replaceable == null) {
            this.replaceable = this.has(Behaviours.OXIDIZABLE) || this.has(Behaviours.STRIPPABLE) || OxidizableRegistry.hasPrevious(this.method_11010().method_26204());
        }
        return this.replaceable;
    }
}

