/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.decoration.holder;

import de.tomalbrc.bil.core.holder.positioned.PositionedHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.decoration.Animation;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.FilamentDecorationHolder;
import de.tomalbrc.filament.decoration.util.ItemFrameElement;
import de.tomalbrc.filament.util.DecorationUtil;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimatedDecorationHolder
extends PositionedHolder
implements FilamentDecorationHolder {
    private final DecorationBlockEntity parent;
    private BlockStateMappedProperty<String> variantProperty;

    public AnimatedDecorationHolder(DecorationBlockEntity blockEntity, Model model) {
        super((class_3218)blockEntity.method_10997(), blockEntity.method_11016().method_46558(), model);
        this.parent = blockEntity;
        if (this.parent.has(Behaviours.ANIMATION)) {
            Animation.Config animation = this.parent.getDecorationData().behaviour().get(Behaviours.ANIMATION);
            this.setAnimationData(animation);
            this.variantProperty = animation.variant;
        }
        DecorationUtil.setupElements(this, blockEntity.getDecorationData(), blockEntity.getDirection(), blockEntity.getVisualRotationYInDegrees(), this.parent.getItem(), this.parent::interact);
    }

    private void updateVariant(class_2680 blockState) {
        if (this.variantProperty != null) {
            String variantName;
            if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
            }
            if ((variantName = this.variantProperty.getValue(blockState)) != null) {
                this.getVariantController().setVariant(variantName);
            }
        }
    }

    @Override
    public void setYaw(float rotation) {
        this.getElements().forEach(x -> {
            if (x instanceof ItemDisplayElement) {
                ItemDisplayElement displayElement = (ItemDisplayElement)x;
                displayElement.setTeleportDuration(0);
                displayElement.setYaw(rotation - 180.0f);
            }
        });
    }

    public void applyPose(Pose pose, DisplayWrapper<?> display) {
        super.applyPose(pose, display);
        display.element().setTranslation((Vector3fc)pose.translation().get(new Vector3f()).sub(0.0f, 0.5f, 0.0f));
    }

    protected void onDataLoaded() {
        super.onDataLoaded();
        if (this.bones != null && this.parent.getDecorationData() != null && this.parent.getDecorationData().size() != null) {
            for (Bone bone : this.bones) {
                ((ItemDisplayElement)bone.element()).setDisplaySize(this.parent.getDecorationData().size().get(0) * 1.5f, this.parent.getDecorationData().size().get(1) * 1.5f);
            }
        }
        this.updateVariant(this.parent.method_11010());
    }

    public void setAnimationData(@NotNull Animation.Config animationData) {
        if (animationData.model != null) {
            if (this.model == null) {
                Filament.LOGGER.error("No Animated model named '{}' was found!", (Object)animationData.model);
            } else {
                if (animationData.autoplay != null) {
                    this.getAnimator().playAnimation(animationData.autoplay);
                }
                this.setYaw(this.parent.getVisualRotationYInDegrees());
            }
        }
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        super.notifyUpdate(updateType);
        if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE && this.getAttachment() != null) {
            this.update(((BlockAwareAttachment)this.getAttachment()).getBlockState());
        }
    }

    @Override
    public void update(class_2680 blockState) {
        FilamentDecorationHolder.super.update(blockState);
        this.updateVariant(blockState);
    }

    @Override
    public void playAnimation(String animation, int priority, Runnable onFinish) {
        this.getAnimator().playAnimation(animation, priority, onFinish);
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    @Override
    public class_1799 getPickResult() {
        return this.parent.getItem().method_7972();
    }

    @Override
    public <T extends VirtualElement> T addElement(T element) {
        VirtualElement res = super.addElement(element);
        if (element instanceof InteractionElement) {
            InteractionElement interactionElement = (InteractionElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(interactionElement.getEntityId(), this::getPickResult);
        }
        if (element instanceof ItemFrameElement) {
            ItemFrameElement itemFrameElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.put(itemFrameElement.getEntityId(), this::getPickResult);
        }
        return (T)res;
    }

    protected void onAttachmentRemoved(HolderAttachment oldAttachment) {
        for (VirtualElement element : this.getElements()) {
            Object interactionElement;
            if (element instanceof InteractionElement) {
                interactionElement = (InteractionElement)element;
                DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
            }
            if (!(element instanceof ItemFrameElement)) continue;
            interactionElement = (ItemFrameElement)element;
            DecorationUtil.VIRTUAL_ENTITY_PICK_MAP.remove(interactionElement.getEntityId());
        }
        super.onAttachmentRemoved(oldAttachment);
    }
}

