/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.trim;

import com.mojang.serialization.Lifecycle;
import de.tomalbrc.filament.behaviour.item.Armor;
import de.tomalbrc.filament.trim.ResourcePackBlocksAtlas;
import de.tomalbrc.filament.trim.ResourcePackSimplifiedItemModel;
import de.tomalbrc.filament.trim.ResourcePackTrimPatternAtlas;
import de.tomalbrc.filament.util.FilamentConfig;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2385;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_9226;
import net.minecraft.class_9248;
import net.minecraft.class_9334;

public class FilamentTrimPatterns {
    private static final Map<Armor.Config, FilamentTrimHolder> trimConfigs = new Object2ObjectOpenHashMap();
    private static final Map<class_1792, BiConsumer<class_5455, class_1799>> modelList = new Reference2ObjectOpenHashMap();
    public static final FilamentTrimHolder CHAIN_TRIM = FilamentTrimPatterns.addConfig(FilamentTrimPatterns.fakeChainmailConfig());

    private static Armor.Config fakeChainmailConfig() {
        Armor.Config conf = new Armor.Config();
        conf.texture = class_2960.method_60656((String)"chainmail");
        return conf;
    }

    public static FilamentTrimHolder addConfig(Armor.Config config) {
        FilamentTrimHolder tmpHolder = trimConfigs.get(config);
        if (tmpHolder != null) {
            return tmpHolder;
        }
        FilamentTrimHolder holder = new FilamentTrimHolder();
        for (Map.Entry<Armor.Config, FilamentTrimHolder> configFilamentTrimHolderEntry : trimConfigs.entrySet()) {
            if (!configFilamentTrimHolderEntry.getKey().texture.equals((Object)config.texture)) continue;
            return configFilamentTrimHolderEntry.getValue();
        }
        trimConfigs.put(config, holder);
        return holder;
    }

    public static void bootstrap(class_2385<class_8056> registry) {
        for (Map.Entry<Armor.Config, FilamentTrimHolder> entry : trimConfigs.entrySet()) {
            if (entry.getValue() == CHAIN_TRIM && !FilamentTrimPatterns.overwriteChainMail()) continue;
            entry.getValue().trimPattern = FilamentTrimPatterns.register(registry, class_1802.field_8077, FilamentTrimPatterns.of(entry.getKey().texture));
        }
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(FilamentTrimPatterns::addRPContents);
    }

    private static void copyChainmailTexture(ResourcePackBuilder resourcePackBuilder) {
        String p1 = "assets/minecraft/textures/models/armor/chainmail_layer_1.png";
        String p2 = "assets/minecraft/textures/models/armor/chainmail_layer_2.png";
        resourcePackBuilder.addData("assets/minecraft/textures/trims/models/armor/chainmail.png", resourcePackBuilder.getDataOrSource(p1));
        resourcePackBuilder.addData("assets/minecraft/textures/trims/models/armor/chainmail_leggings.png", resourcePackBuilder.getDataOrSource(p2));
        BufferedImage image = new BufferedImage(64, 32, 2);
        byte[] pngData = null;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", stream);
            pngData = stream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        resourcePackBuilder.addData(p1, pngData);
        resourcePackBuilder.addData(p2, pngData);
    }

    public static void apply(class_5455 registryAccess, class_1799 itemStack) {
        itemStack.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)((class_7225.class_7226)registryAccess.method_46759(class_7924.field_42083).get()).method_46746(class_8055.field_42004).get(), FilamentTrimPatterns.CHAIN_TRIM.trimPattern, false));
    }

    public static void addRPContents(ResourcePackBuilder builder) {
        FilamentTrimPatterns.addTrimAtlas(builder);
        FilamentTrimPatterns.addBlockAtlas(builder);
        if (FilamentTrimPatterns.overwriteChainMail()) {
            FilamentTrimPatterns.copyChainmailTexture(builder);
            List<class_1792> items = List.of(class_1802.field_8283, class_1802.field_8873, class_1802.field_8218, class_1802.field_8313);
            for (class_1792 item : items) {
                String itemModelPath = "assets/minecraft/models/item/" + class_7923.field_41178.method_10221((Object)item).method_12832() + ".json";
                byte[] data = builder.getDataOrSource(itemModelPath);
                ResourcePackSimplifiedItemModel tmp = (ResourcePackSimplifiedItemModel)Json.GSON.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(data)), ResourcePackSimplifiedItemModel.class);
                builder.addData(itemModelPath, Json.GSON.toJson((Object)tmp).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private static void addTrimAtlas(ResourcePackBuilder builder) {
        String path = "assets/minecraft/atlases/armor_trims.json";
        byte[] data = builder.getDataOrSource(path);
        ResourcePackTrimPatternAtlas atlas = (ResourcePackTrimPatternAtlas)Json.GSON.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(data)), ResourcePackTrimPatternAtlas.class);
        atlas.sources.getFirst().textures = new ObjectArrayList();
        Map.Entry<String, String> permEntry = atlas.sources.getFirst().permutations.entrySet().iterator().next();
        atlas.sources.getFirst().permutations = Map.of(permEntry.getKey(), permEntry.getValue());
        for (Map.Entry<Armor.Config, FilamentTrimHolder> entry : trimConfigs.entrySet()) {
            String k2;
            String k1 = entry.getKey().texture.method_45138("trims/models/armor/").toString();
            if (!atlas.sources.getFirst().textures.contains(k1)) {
                atlas.sources.getFirst().textures.add(k1);
            }
            if (atlas.sources.getFirst().textures.contains(k2 = entry.getKey().texture.method_45138("trims/models/armor/").method_48331("_leggings").toString())) continue;
            atlas.sources.getFirst().textures.add(k2);
        }
        builder.addData(path, Json.GSON.toJson((Object)atlas).getBytes(StandardCharsets.UTF_8));
    }

    private static void addBlockAtlas(ResourcePackBuilder builder) {
        String path = "assets/minecraft/atlases/blocks.json";
        ResourcePackBlocksAtlas atlas = new ResourcePackBlocksAtlas();
        atlas.sources = new ObjectArrayList();
        for (Map.Entry<Armor.Config, FilamentTrimHolder> entry : trimConfigs.entrySet()) {
            ResourcePackBlocksAtlas.Source source = new ResourcePackBlocksAtlas.Source();
            source.type = "single";
            source.sprite = entry.getKey().texture.method_45138("trims/models/armor/").toString();
            source.resource = entry.getKey().texture.method_45138("trims/models/armor/").toString();
            atlas.sources.add(source);
            ResourcePackBlocksAtlas.Source source2 = new ResourcePackBlocksAtlas.Source();
            source2.type = "single";
            source2.sprite = entry.getKey().texture.method_45138("trims/models/armor/").method_48331("_leggings").toString();
            source2.resource = entry.getKey().texture.method_45138("trims/models/armor/").method_48331("_leggings").toString();
            atlas.sources.add(source2);
        }
        builder.addData(path, Json.GSON.toJson((Object)atlas).getBytes(StandardCharsets.UTF_8));
    }

    private static class_6880.class_6883<class_8056> register(class_2385<class_8056> registry, class_1792 template, class_5321<class_8056> key) {
        class_8056 armorTrimPattern = new class_8056(key.method_29177(), class_7923.field_41178.method_47983((Object)template), (class_2561)class_2561.method_43470((String)"-"), false);
        return registry.method_10272(key, (Object)armorTrimPattern, new class_9248(Optional.of(new class_9226("filament", "filament", class_155.method_16673().method_48018())), Lifecycle.stable()));
    }

    private static class_5321<class_8056> of(class_2960 resourceLocation) {
        return class_5321.method_29179((class_5321)class_7924.field_42082, (class_2960)resourceLocation);
    }

    public static boolean overwriteChainMail() {
        return FilamentConfig.getInstance().trimArmorReplaceChainmail;
    }

    public static class FilamentTrimHolder {
        public class_6880.class_6883<class_8056> trimPattern;
    }
}

