/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.decoration;

import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.decoration.block.entity.DecorationBlockEntity;
import de.tomalbrc.filament.decoration.holder.AnimatedDecorationHolder;
import de.tomalbrc.filament.decoration.holder.FilamentDecorationHolder;
import de.tomalbrc.filament.registry.ModelRegistry;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Animation
implements DecorationBehaviour<Config> {
    private final Config config;

    public Animation(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public FilamentDecorationHolder createHolder(DecorationBlockEntity blockEntity) {
        Model model = ModelRegistry.getModel(this.config.model);
        if (model != null) {
            return new AnimatedDecorationHolder(blockEntity, model);
        }
        Filament.LOGGER.error("No Animated model named '{}' was found!", (Object)this.config.model);
        return null;
    }

    @Override
    public void onHolderAttach(DecorationBlockEntity blockEntity, FilamentDecorationHolder holder) {
        holder.setYaw(blockEntity.getVisualRotationYInDegrees());
    }

    public static class Config {
        public class_2960 model = null;
        public String autoplay = null;
        public BlockStateMappedProperty<String> variant = BlockStateMappedProperty.of("default");
    }
}

