/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.block;

import com.mojang.authlib.GameProfile;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.BehaviourMap;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.impl.content.registry.FireBlockHooks;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5688;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import net.minecraft.class_8567;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class SimpleBlock
extends class_2248
implements PolymerTexturedBlock,
BehaviourHolder,
class_3737,
class_2256,
class_5955,
class_5688,
FireBlockHooks {
    protected Map<class_2680, BlockData.BlockStateMeta> stateMap;
    protected final class_2680 breakEventState;
    protected final AbstractBlockData<? extends BlockProperties> blockData;
    protected final class_2689<class_2248, class_2680> stateDefinitionEx;
    private final BehaviourMap behaviours = new BehaviourMap();

    @Override
    public BehaviourMap getBehaviours() {
        return this.behaviours;
    }

    public SimpleBlock(class_4970.class_2251 properties, AbstractBlockData<? extends BlockProperties> data) {
        super(properties);
        this.initBehaviours(data.behaviour());
        this.breakEventState = ((BlockProperties)data.properties()).blockBase.method_9564();
        this.blockData = data;
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour2 : this.behaviours) {
            Behaviour<?> behaviour3 = behaviour2.getValue();
            if (!(behaviour3 instanceof BlockBehaviour)) continue;
            BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour3;
            blockBehaviour.modifyBlockProperties(properties);
        }
        class_2689.class_2690 builder = new class_2689.class_2690((Object)this);
        this.method_9515((class_2689.class_2690<class_2248, class_2680>)builder);
        this.stateDefinitionEx = builder.method_11668(class_2248::method_9564, class_2680::new);
        class_2680[] def = new class_2680[]{(class_2680)this.stateDefinitionEx.method_11664()};
        this.forEach(behaviour -> {
            def[0] = behaviour.modifyDefaultState(def[0]);
        });
        this.method_9590(def[0]);
    }

    public boolean hasData() {
        return this.blockData != null;
    }

    public AbstractBlockData<? extends BlockProperties> data() {
        return this.blockData;
    }

    @NotNull
    public class_5250 method_9518() {
        class_2561 dataName = this.blockData.displayName();
        return dataName != null ? dataName.method_27661() : super.method_9518();
    }

    public boolean forceLightUpdates(class_2680 blockState) {
        return true;
    }

    @NotNull
    public class_2689<class_2248, class_2680> method_9595() {
        return this.stateDefinitionEx;
    }

    public void postRegister() {
        this.stateMap = this.blockData.createStandardStateMap();
        if (this.stateMap != null) {
            this.forEach(behaviour -> behaviour.modifyStateMap(this.stateMap, this.blockData));
        }
        this.stateDefinitionEx.method_11662().forEach(class_4970.class_4971::method_26200);
    }

    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        class_2680 state = blockState;
        if (this.stateMap != null) {
            state = this.behaviourModifiedBlockState(blockState, state);
        }
        return this.stateMap != null && this.stateMap.get(state) != null ? this.stateMap.get(state).blockState() : class_2246.field_9987.method_9564();
    }

    public class_2680 behaviourModifiedBlockState(class_2680 original, class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour)) continue;
            BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
            original = blockBehaviour.modifyPolymerBlockState(original, blockState);
        }
        return original;
    }

    private void forEach(Consumer<BlockBehaviour<?>> consumer) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour)) continue;
            BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
            consumer.accept(blockBehaviour);
        }
    }

    @NotNull
    public class_2680 method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.playerWillDestroy(level, blockPos, blockState, player));
        }
        return super.method_9576(level, blockPos, blockState, player);
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.setPlacedBy(level, blockPos, blockState, livingEntity, itemStack));
        }
    }

    public void method_66388(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, boolean bl) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.affectNeighborsAfterRemoval(blockState, serverLevel, blockPos, bl));
        }
    }

    protected long method_9535(class_2680 blockState, class_2338 blockPos) {
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                BlockBehaviour blockBehaviour;
                Optional<Long> res;
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getSeed(blockState, blockPos)) == null || !res.isPresent()) continue;
                return res.orElseThrow();
            }
        }
        return super.method_9535(blockState, blockPos);
    }

    public void method_10127(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2680 blockState2, class_1540 fallingBlockEntity) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.onLand(level, blockPos, blockState, blockState2, fallingBlockEntity));
        }
    }

    public void method_10129(class_1937 level, class_2338 blockPos, class_1540 fallingBlockEntity) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.onBrokenAfterFall(level, blockPos, fallingBlockEntity));
        }
    }

    @NotNull
    public class_1282 method_32898(class_1297 entity) {
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                BlockBehaviour blockBehaviour;
                class_1282 res;
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getFallDamageSource(entity)) == null) continue;
                return res;
            }
        }
        return super.method_32898(entity);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.createBlockStateDefinition(builder));
        }
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2680 def = super.method_9605(blockPlaceContext);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour)) continue;
            BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
            def = blockBehaviour.getStateForPlacement(def, blockPlaceContext);
        }
        return def;
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_9904 orientation, boolean bl) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.neighborChanged(blockState, level, blockPos, block, orientation, bl));
        }
        super.method_9612(blockState, level, blockPos, block, orientation, bl);
    }

    public void method_55124(class_2680 blockState, class_3218 level, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        class_1657 player;
        class_1297 class_12972 = explosion.method_46406();
        if (class_12972 instanceof class_1657 && !CommonProtection.canExplodeBlock((class_1937)level, (class_2338)blockPos, (class_1927)explosion, (GameProfile)(player = (class_1657)class_12972).method_7334(), (class_1657)player)) {
            return;
        }
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.onExplosionHit(blockState, level, blockPos, explosion, biConsumer));
        }
        if (!(blockState.method_26215() || explosion.method_55111() != class_1927.class_4179.field_18687 && explosion.method_55111() != class_1927.class_4179.field_40879)) {
            class_2248 block = blockState.method_26204();
            boolean bl = explosion.method_8347() instanceof class_1657;
            if (block.method_9533(explosion)) {
                class_2586 blockEntity = blockState.method_31709() ? level.method_8321(blockPos) : null;
                class_8567.class_8568 builder = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)blockEntity).method_51877(class_181.field_1226, (Object)explosion.method_46406());
                if (explosion.method_55111() == class_1927.class_4179.field_40879) {
                    builder.method_51874(class_181.field_1225, (Object)Float.valueOf(explosion.method_55107()));
                }
                blockState.method_26180(level, blockPos, class_1799.field_8037, bl);
                blockState.method_26189(builder).forEach((? super T itemStack) -> biConsumer.accept((class_1799)itemStack, blockPos));
            }
            this.method_9586(level, blockPos, explosion);
            level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
        }
    }

    public void method_9586(class_3218 serverLevel, class_2338 blockPos, class_1927 explosion) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.wasExploded(serverLevel, blockPos, explosion));
        }
    }

    public boolean method_9533(class_1927 explosion) {
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                BlockBehaviour blockBehaviour;
                boolean res;
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).dropFromExplosion(explosion))) continue;
                return false;
            }
        }
        return super.method_9533(explosion);
    }

    @NotNull
    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            class_2680 res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).rotate(blockState, rotation)) == null) continue;
            return res;
        }
        return super.method_9598(blockState, rotation);
    }

    @NotNull
    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            class_2680 res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).mirror(blockState, mirror)) == null) continue;
            return res;
        }
        return super.method_9569(blockState, mirror);
    }

    public boolean method_9506(class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            boolean res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || !(res = (blockBehaviour = (BlockBehaviour)behaviour2).isSignalSource(blockState))) continue;
            return true;
        }
        return super.method_9506(blockState);
    }

    public int method_9603(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            int res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getDirectSignal(blockState, blockGetter, blockPos, direction)) <= 0) continue;
            return res;
        }
        return super.method_9603(blockState, blockGetter, blockPos, direction);
    }

    public int method_9524(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            int res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getSignal(blockState, blockGetter, blockPos, direction)) <= 0) continue;
            return res;
        }
        return super.method_9524(blockState, blockGetter, blockPos, direction);
    }

    protected boolean method_9526(class_2680 blockState) {
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                BlockBehaviour blockBehaviour;
                Optional<Boolean> res;
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour) || !(res = (blockBehaviour = (BlockBehaviour)behaviour2).useShapeForLightOcclusion(blockState)).isPresent()) continue;
                return res.get();
            }
        }
        return super.method_9526(blockState);
    }

    protected boolean method_9616(class_2680 blockState, class_1750 blockPlaceContext) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            Optional<Boolean> res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || !(res = (blockBehaviour = (BlockBehaviour)behaviour2).canBeReplaced(blockState, blockPlaceContext)).isPresent()) continue;
            return res.get();
        }
        return super.method_9616(blockState, blockPlaceContext);
    }

    protected boolean method_22358(class_2680 blockState, class_3611 fluid) {
        return blockState.method_45474() || !((BlockProperties)this.blockData.properties()).solid;
    }

    @NotNull
    protected class_3610 method_9545(class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            class_3610 res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getFluidState(blockState)) == null) continue;
            return res;
        }
        return super.method_9545(blockState);
    }

    public boolean method_10311(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            class_3737 waterloggedBlock;
            boolean res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof class_3737) || !(res = (waterloggedBlock = (class_3737)behaviour2).method_10311(levelAccessor, blockPos, blockState, fluidState))) continue;
            return true;
        }
        if (!((BlockProperties)this.blockData.properties()).solid) {
            levelAccessor.method_22352(blockPos, true);
            levelAccessor.method_8652(blockPos, fluidState.method_15759(), 3);
        }
        return !((BlockProperties)this.blockData.properties()).solid;
    }

    public boolean method_10310(@Nullable class_1309 livingEntity, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof class_3737)) continue;
            class_3737 waterloggedBlock = (class_3737)behaviour2;
            return waterloggedBlock.method_10310(livingEntity, blockGetter, blockPos, blockState, fluid);
        }
        return !((BlockProperties)this.blockData.properties()).solid;
    }

    @NotNull
    protected class_2680 method_9559(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        class_2680 bs = super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour)) continue;
            BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
            bs = blockBehaviour.updateShape(bs, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
        }
        return bs;
    }

    protected boolean method_9516(class_2680 blockState, class_10 pathComputationType) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            Optional<Boolean> res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || !(res = (blockBehaviour = (BlockBehaviour)behaviour2).isPathfindable(blockState, pathComputationType)).isPresent()) continue;
            return res.get();
        }
        return super.method_9516(blockState, pathComputationType);
    }

    protected void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        super.method_9615(blockState, level, blockPos, blockState2, bl);
        this.forEach(x -> x.onPlace(blockState, level, blockPos, blockState2, bl));
    }

    protected void method_9565(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_1799 itemStack, boolean bl) {
        this.forEach(x -> x.spawnAfterBreak(blockState, serverLevel, blockPos, itemStack, bl));
        super.method_9565(blockState, serverLevel, blockPos, itemStack, bl);
    }

    @NotNull
    public class_1799 method_9574(class_4538 levelReader, class_2338 blockPos, class_2680 blockState, boolean includeData) {
        class_1799 stack = super.method_9574(levelReader, blockPos, blockState, includeData);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            class_1799 item;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (item = (blockBehaviour = (BlockBehaviour)behaviour2).getCloneItemStack(stack, levelReader, blockPos, blockState, includeData)) == null) continue;
            stack = item;
        }
        return stack;
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            boolean res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).canSurvive(blockState, levelReader, blockPos))) continue;
            return false;
        }
        return true;
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        super.method_9588(blockState, serverLevel, blockPos, randomSource);
        this.forEach(x -> x.tick(blockState, serverLevel, blockPos, randomSource));
    }

    protected boolean method_9542(class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            boolean res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || !(res = (blockBehaviour = (BlockBehaviour)behaviour2).isRandomlyTicking(blockState))) continue;
            return true;
        }
        return super.method_9542(blockState);
    }

    protected void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.randomTick(blockState, serverLevel, blockPos, randomSource));
        }
    }

    public boolean method_9651(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            class_2256 bonemealableBlock;
            boolean res;
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_2256) || !(res = (bonemealableBlock = (class_2256)behaviour2).method_9651(levelReader, blockPos, blockState))) continue;
            return true;
        }
        return false;
    }

    public boolean method_9650(class_1937 level, class_5819 randomSource, class_2338 blockPos, class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            class_2256 bonemealableBlock;
            boolean res;
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_2256) || !(res = (bonemealableBlock = (class_2256)behaviour2).method_9650(level, randomSource, blockPos, blockState))) continue;
            return true;
        }
        return false;
    }

    public void method_9652(class_3218 serverLevel, class_5819 randomSource, class_2338 blockPos, class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_2256)) continue;
            class_2256 bonemealableBlock = (class_2256)behaviour2;
            bonemealableBlock.method_9652(serverLevel, randomSource, blockPos, blockState);
        }
    }

    @NotNull
    public class_2256.class_9077 method_55770() {
        class_2256.class_9077 def = super.method_55770();
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            class_2256 bonemealableBlock;
            class_2256.class_9077 res;
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_2256) || (res = (bonemealableBlock = (class_2256)behaviour2).method_55770()).equals((Object)def)) continue;
            return res;
        }
        return def;
    }

    @NotNull
    public class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            class_1269 res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).useWithoutItem(blockState, level, blockPos, player, blockHitResult)) == null || !res.method_23665()) continue;
            return res;
        }
        return super.method_55766(blockState, level, blockPos, player, blockHitResult);
    }

    @NotNull
    public class_1269 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            class_1269 res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult)) == null || !res.method_23665()) continue;
            return res;
        }
        return super.method_55765(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected void method_9606(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.attack(blockState, level, blockPos, player));
        }
    }

    public void method_19286(class_1937 level, class_2680 blockState, class_3965 blockHitResult, class_1676 projectile) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.onProjectileHit(level, blockState, blockHitResult, projectile));
        }
    }

    public void method_54764(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_5955)) continue;
            class_5955 weatheringCopper = (class_5955)behaviour2;
            weatheringCopper.method_54764(blockState, serverLevel, blockPos, randomSource);
        }
    }

    @NotNull
    public class_5955.class_5811 getAge() {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_5955)) continue;
            class_5955 weatheringCopper = (class_5955)behaviour2;
            return (class_5955.class_5811)weatheringCopper.method_33622();
        }
        return class_5955.class_5811.field_28707;
    }

    @NotNull
    public Optional<class_2680> method_54765(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            Behaviour<?> behaviour2;
            if (!(behaviour.getValue() instanceof BlockBehaviour) || !((behaviour2 = behaviour.getValue()) instanceof class_5955)) continue;
            class_5955 weatheringCopper = (class_5955)behaviour2;
            return weatheringCopper.method_54765(blockState, serverLevel, blockPos, randomSource);
        }
        return Optional.empty();
    }

    public boolean method_9498(class_2680 blockState) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            Optional<Boolean> res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || !(res = (blockBehaviour = (BlockBehaviour)behaviour2).hasAnalogOutputSignal(blockState)).isPresent()) continue;
            return res.orElseThrow();
        }
        return super.method_9498(blockState);
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2350 direction) {
        int max = super.method_9572(blockState, level, blockPos, direction);
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
            BlockBehaviour blockBehaviour;
            int res;
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getAnalogOutputSignal(blockState, level, blockPos, direction)) <= max) continue;
            max = res;
        }
        return max;
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity, class_10774 insideBlockEffectApplier) {
        if (this.getBehaviours() != null) {
            this.getBehaviours().forEach((? super T behaviourTypeBehaviourEntry) -> {
                Object patt0$temp = behaviourTypeBehaviourEntry.getValue();
                if (patt0$temp instanceof BlockBehaviour) {
                    BlockBehaviour blockBehaviourWithEntity = (BlockBehaviour)patt0$temp;
                    blockBehaviourWithEntity.entityInside(blockState, level, blockPos, entity, insideBlockEffectApplier);
                }
            });
        }
    }

    public FlammableBlockRegistry.Entry fabric_getVanillaEntry(class_2680 blockState) {
        return new FlammableBlockRegistry.Entry(0, 0);
    }

    protected int method_9505(class_2680 state) {
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                BlockBehaviour blockBehaviour;
                int res;
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getLightBlock(state)) == -1) continue;
                return res;
            }
        }
        return super.method_9505(state);
    }

    @NotNull
    protected class_265 method_25959(class_2680 state, class_1922 level, class_2338 pos) {
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                BlockBehaviour blockBehaviour;
                class_265 res;
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour) || (res = (blockBehaviour = (BlockBehaviour)behaviour2).getBlockSupportShape(state, level, pos)) == null) continue;
                return res;
            }
        }
        return super.method_25959(state, level, pos);
    }

    public void method_9502(class_1922 blockGetter, class_1297 entity) {
        boolean ranCustomImpl = false;
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour)) continue;
                BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
                ranCustomImpl = ranCustomImpl || blockBehaviour.updateEntityMovementAfterFallOn(blockGetter, entity);
            }
        }
        if (!ranCustomImpl) {
            super.method_9502(blockGetter, entity);
        }
    }

    public void method_9554(class_1937 level, class_2680 blockState, class_2338 blockPos, class_1297 entity, double d) {
        boolean ranCustomImpl = false;
        if (this.getBehaviours() != null) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : this.getBehaviours()) {
                Behaviour<?> behaviour2 = behaviour.getValue();
                if (!(behaviour2 instanceof BlockBehaviour)) continue;
                BlockBehaviour blockBehaviour = (BlockBehaviour)behaviour2;
                ranCustomImpl |= blockBehaviour.fallOn(level, blockState, blockPos, entity, d);
            }
        }
        if (!ranCustomImpl) {
            super.method_9554(level, blockState, blockPos, entity, d);
        }
    }

    public void method_9591(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1297 entity) {
        if (this.getBehaviours() != null) {
            this.forEach(x -> x.stepOn(level, blockPos, blockState, entity));
        }
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState) {
        if (((BlockProperties)this.blockData.properties()).showBreakParticles) {
            super.method_33614(level, player, blockPos, blockState);
        }
    }
}

