/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data.properties;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import de.tomalbrc.filament.data.properties.RangedValue;
import java.util.List;
import net.minecraft.class_5819;
import org.joml.Vector3f;

public class RangedVector3f {
    private final RangedValue x;
    private final RangedValue y;
    private final RangedValue z;
    public static final Codec<RangedVector3f> CODEC = RangedValue.CODEC.listOf().comapFlatMap(list -> {
        if (list.size() != 3) {
            return DataResult.error(() -> "Expected 3 elements for RangedVector3f, got " + list.size());
        }
        return DataResult.success((Object)new RangedVector3f((RangedValue)list.get(0), (RangedValue)list.get(1), (RangedValue)list.get(2)));
    }, vec -> List.of(vec.getX(), vec.getY(), vec.getZ()));

    public RangedVector3f(RangedValue x, RangedValue y, RangedValue z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public RangedVector3f() {
        this.x = new RangedValue(0.0);
        this.y = new RangedValue(0.0);
        this.z = new RangedValue(0.0);
    }

    public RangedValue getX() {
        return this.x;
    }

    public RangedValue getY() {
        return this.y;
    }

    public RangedValue getZ() {
        return this.z;
    }

    public Vector3f random(class_5819 random) {
        return new Vector3f((float)this.x.randomValue(random), (float)this.y.randomValue(random), (float)this.z.randomValue(random));
    }
}

