/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.api;

import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.registry.BlockRegistry;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.registry.ItemRegistry;
import de.tomalbrc.filament.registry.ModelRegistry;
import de.tomalbrc.filament.util.Json;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public class FilamentLoader {
    public static void loadBlocks(String modid) {
        Behaviours.register();
        FilamentLoader.search(modid, f -> {
            try {
                if (f.endsWith(".yaml") || f.endsWith(".yml")) {
                    List<InputStream> list = Json.yamlToJson(Files.newInputStream(f, new OpenOption[0]));
                    for (InputStream stream : list) {
                        BlockRegistry.register(stream);
                    }
                } else {
                    BlockRegistry.register(Json.camelToSnakeCase(Files.newInputStream(f, new OpenOption[0])));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, "filament/block");
    }

    public static void loadItems(String modid) {
        Behaviours.register();
        FilamentLoader.search(modid, f -> {
            try {
                if (f.endsWith(".yaml") || f.endsWith(".yml")) {
                    List<InputStream> list = Json.yamlToJson(Files.newInputStream(f, new OpenOption[0]));
                    for (InputStream stream : list) {
                        ItemRegistry.register(stream);
                    }
                } else {
                    ItemRegistry.register(Json.camelToSnakeCase(Files.newInputStream(f, new OpenOption[0])));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, "filament/item/");
    }

    public static void loadDecorations(String modid) {
        Behaviours.register();
        FilamentLoader.search(modid, f -> {
            try {
                if (f.endsWith(".yaml") || f.endsWith(".yml")) {
                    List<InputStream> list = Json.yamlToJson(Files.newInputStream(f, new OpenOption[0]));
                    for (InputStream stream : list) {
                        DecorationRegistry.register(stream);
                    }
                } else {
                    DecorationRegistry.register(Json.camelToSnakeCase(Files.newInputStream(f, new OpenOption[0])));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, "filament/decoration/");
    }

    public static void loadModels(String modid, String namespace) {
        Behaviours.register();
        FilamentLoader.search(modid, f -> {
            try {
                if (f.getFileName() != null) {
                    ModelRegistry.registerAjModel(Files.newInputStream(f, new OpenOption[0]), class_2960.method_60655((String)namespace, (String)f.getFileName().toString()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, "filament/model/", ".ajmodel");
        FilamentLoader.search(modid, f -> {
            try {
                if (f.getFileName() != null) {
                    ModelRegistry.registerBbModel(Files.newInputStream(f, new OpenOption[0]), class_2960.method_60655((String)namespace, (String)f.getFileName().toString()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, "filament/model/", ".bbmodel");
        FilamentLoader.search(modid, f -> {
            try {
                if (f.getFileName() != null) {
                    ModelRegistry.registerAjBlueprintModel(Files.newInputStream(f, new OpenOption[0]), class_2960.method_60655((String)namespace, (String)f.getFileName().toString()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, "filament/model/", ".ajblueprint");
    }

    private static void search(String modid, Consumer<Path> registry, String path) {
        FilamentLoader.search(modid, registry, path, ".json");
        FilamentLoader.search(modid, registry, path, ".yaml");
        FilamentLoader.search(modid, registry, path, ".yml");
    }

    private static void search(String modid, Consumer<Path> registry, String path, String ext) {
        FilamentLoader.processJsonFilesInJar(modid, registry, path, ext);
    }

    private static void processJsonFilesInJar(String modid, Consumer<Path> consumer, String rootPath, String ext) {
        Optional container = FabricLoader.getInstance().getModContainer(modid);
        if (container.isPresent() && !((ModContainer)container.get()).getRootPaths().isEmpty()) {
            for (Path rootPaths : ((ModContainer)container.get()).getRootPaths()) {
                try {
                    Stream<Path> str = Files.walk(rootPaths, new FileVisitOption[0]);
                    try {
                        str.forEach(file -> {
                            try {
                                if (file.getFileName() == null) {
                                    return;
                                }
                                String name = file.getFileName().toString();
                                if (file.toAbsolutePath().toString().contains(rootPath) && name.endsWith(ext)) {
                                    consumer.accept((Path)file);
                                }
                            }
                            catch (Throwable throwable) {
                                Filament.LOGGER.error("Could not load file from jar: {}", file);
                                Filament.LOGGER.error(throwable.getMessage());
                            }
                        });
                    }
                    finally {
                        if (str == null) continue;
                        str.close();
                    }
                }
                catch (Throwable throwable) {
                    Filament.LOGGER.error("Error searching in jar for {}", (Object)modid);
                    Filament.LOGGER.error(throwable.getMessage());
                }
            }
        } else {
            Filament.LOGGER.error("Not a jar");
        }
    }
}

