/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviourWithEntity;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.mixin.accessor.HopperBlockEntityAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hopper
implements BlockBehaviourWithEntity<Config> {
    private final Config config;

    public Hopper(Config config) {
        this.config = config;
    }

    @Override
    public class_2591<?> blockEntityType() {
        return class_2591.field_11888;
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 blockState, class_1750 blockPlaceContext) {
        class_2350 direction = blockPlaceContext.method_8038().method_10153();
        return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12545, (Comparable)(direction.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11033 : direction))).method_11657((class_2769)class_2741.field_12515, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public class_2586 newBlockEntity(class_2338 blockPos, class_2680 blockState) {
        return new class_2614(blockPos, blockState);
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> getTicker(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return level.method_8608() ? null : BlockBehaviourWithEntity.createTickerHelper(blockEntityType, class_2591.field_11888, Hopper::pushItemsTick);
    }

    public static void pushItemsTick(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2614 hopperBlockEntity) {
        HopperBlockEntityAccessor accessor = (HopperBlockEntityAccessor)hopperBlockEntity;
        accessor.setCooldownTime(accessor.cooldownTime() - 1);
        accessor.setTickedGameTime(level.method_8510());
        if (!accessor.invokeIsOnCooldown()) {
            accessor.setCooldownTime(0);
            Config conf = Hopper.get((class_2614)hopperBlockEntity).config;
            Hopper.tryMoveItems(level, blockPos, blockState, hopperBlockEntity, () -> Hopper.suckInItems(level, hopperBlockEntity), conf);
        }
    }

    protected static void setChanged(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        level.method_8524(blockPos);
        if (!blockState.method_26215()) {
            level.method_8455(blockPos, blockState.method_26204());
        }
    }

    private static void tryMoveItems(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2614 hopperBlockEntity, BooleanSupplier booleanSupplier, Config config) {
        if (!level.method_8608() && !((HopperBlockEntityAccessor)hopperBlockEntity).invokeIsOnCooldown() && ((Boolean)blockState.method_11654((class_2769)class_2377.field_11126)).booleanValue()) {
            boolean changed = false;
            if (!hopperBlockEntity.method_5442()) {
                changed = HopperBlockEntityAccessor.invokeEjectItems(level, blockPos, hopperBlockEntity);
            }
            if (!((HopperBlockEntityAccessor)hopperBlockEntity).invokeInventoryFull()) {
                changed |= booleanSupplier.getAsBoolean();
            }
            if (changed) {
                ((HopperBlockEntityAccessor)hopperBlockEntity).setCooldownTime(config.cooldownTime);
                Hopper.setChanged(level, blockPos, blockState);
            }
        }
    }

    public static boolean suckInItems(class_1937 level, class_2614 hopper) {
        block4: {
            boolean fullBlockShape;
            class_1263 container;
            class_2680 blockState;
            class_2338 blockPos;
            Config conf;
            block3: {
                conf = Hopper.get((class_2614)hopper).config;
                blockPos = class_2338.method_49637((double)hopper.method_11266(), (double)(hopper.method_11264() + 1.0), (double)hopper.method_11265());
                blockState = level.method_8320(blockPos);
                container = class_2614.method_11250((class_1937)level, (class_2338)blockPos);
                if (container == null || !conf.takeFromContainer) break block3;
                class_2350 direction = class_2350.field_11033;
                for (int i : HopperBlockEntityAccessor.invokeGetSlots(container, direction)) {
                    if (!Hopper.tryTakeInItemFromSlot(hopper, container, i, direction)) continue;
                    return true;
                }
                break block4;
            }
            if (container != null || !conf.pickupItemEntities) break block4;
            boolean bl = fullBlockShape = blockState.method_26234((class_1922)level, blockPos) && !blockState.method_26164(class_3481.field_49147);
            if (!fullBlockShape) {
                for (class_1542 itemEntity : class_2614.method_11237((class_1937)level, (class_2615)hopper)) {
                    if (!conf.canTake(itemEntity.method_6983()) || !class_2614.method_11247((class_1263)hopper, (class_1542)itemEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(class_2614 hopper, class_1263 container, int i, class_2350 direction) {
        class_1799 itemStack = container.method_5438(i);
        if (!itemStack.method_7960() && Hopper.canTakeItemFromContainer(hopper, container, itemStack, i, direction)) {
            int count = itemStack.method_7947();
            class_1799 itemStack2 = class_2614.method_11260((class_1263)container, (class_1263)hopper, (class_1799)container.method_5434(i, 1), null);
            if (itemStack2.method_7960()) {
                container.method_5431();
                return true;
            }
            itemStack.method_7939(count);
            if (count == 1) {
                container.method_5447(i, itemStack);
            }
        }
        return false;
    }

    private static boolean canTakeItemFromContainer(class_2614 hopperContainer, class_1263 container2, class_1799 itemStack, int i, class_2350 direction) {
        class_1278 worldlyContainer;
        Hopper self = Hopper.get(hopperContainer);
        if (!container2.method_49104((class_1263)hopperContainer, i, itemStack) || !self.config.canTake(itemStack)) {
            return false;
        }
        return !(container2 instanceof class_1278) || (worldlyContainer = (class_1278)container2).method_5493(i, itemStack, direction);
    }

    private static Hopper get(class_2614 hopperBlockEntity) {
        return (Hopper)((SimpleBlock)hopperBlockEntity.method_11010().method_26204()).get(Behaviours.HOPPER);
    }

    @Override
    public void onPlace(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState2.method_27852(blockState.method_26204())) {
            this.checkPoweredState(level, blockPos, blockState);
        }
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        class_2586 class_25862;
        if (!level.method_8608() && (class_25862 = level.method_8321(blockPos)) instanceof class_2614) {
            class_2614 hopperBlockEntity = (class_2614)class_25862;
            player.method_17355((class_3908)hopperBlockEntity);
            player.method_7281(class_3468.field_15366);
        }
        return class_1269.field_5812;
    }

    @Override
    public void neighborChanged(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 blockPos2, boolean bl) {
        this.checkPoweredState(level, blockPos, blockState);
    }

    private void checkPoweredState(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        boolean bl;
        boolean bl2 = bl = !level.method_49803(blockPos);
        if (bl != (Boolean)blockState.method_11654((class_2769)class_2741.field_12515)) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12515, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    @Override
    public void affectNeighborsAfterRemoval(class_2680 state, class_1937 level, class_2338 pos, class_2680 blockState2, boolean movedByPiston) {
        class_1264.method_54291((class_2680)state, (class_2680)blockState2, (class_1937)level, (class_2338)pos);
    }

    @Override
    public Optional<Boolean> hasAnalogOutputSignal(class_2680 blockState) {
        return Optional.of(true);
    }

    @Override
    public int getAnalogOutputSignal(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        return class_1703.method_7608((class_2586)level.method_8321(blockPos));
    }

    @Override
    public class_2680 rotate(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12545, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)class_2741.field_12545)));
    }

    @Override
    public class_2680 mirror(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)class_2741.field_12545)));
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12545, class_2741.field_12515});
    }

    @Override
    public void entityInside(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof class_2614) {
            class_2614.method_11236((class_1937)level, (class_2338)blockPos, (class_2680)blockState, (class_1297)entity, (class_2614)((class_2614)blockEntity));
        }
    }

    @Override
    public Optional<Boolean> isPathfindable(class_2680 blockState, class_10 pathComputationType) {
        return Optional.of(false);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        public List<String> filterItems;
        public boolean pickupItemEntities = true;
        public boolean takeFromContainer = true;
        public int cooldownTime = 8;
        public transient List<class_1792> itemFilter;
        public transient List<class_6862<class_1792>> itemTagFilter;

        public boolean canTake(class_1799 itemStack) {
            if (this.itemFilter == null) {
                this.itemFilter = new ObjectArrayList();
                this.itemTagFilter = new ObjectArrayList();
                if (this.filterItems != null) {
                    for (String string : this.filterItems) {
                        if (string.startsWith("#")) {
                            this.itemTagFilter.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)string.substring(1))));
                            continue;
                        }
                        this.itemFilter.add((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)string)));
                    }
                }
            }
            for (class_1792 class_17922 : this.itemFilter) {
                if (!itemStack.method_31574(class_17922)) continue;
                return true;
            }
            for (class_6862 class_68622 : this.itemTagFilter) {
                if (!itemStack.method_31573(class_68622)) continue;
                return true;
            }
            return this.itemTagFilter.isEmpty() && this.itemFilter.isEmpty();
        }
    }
}

