/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.AsyncTickingBlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class StatusEffectEmitter
implements BlockBehaviour<Config>,
AsyncTickingBlockBehaviour {
    private Config config;

    public StatusEffectEmitter(Config config) {
        this.config = config;
    }

    private class_1293 decode(EffectElement element) {
        return new class_1293((class_6880)class_7923.field_41174.method_55841(element.effect).orElseThrow(), element.duration, element.amplifier, element.ambient, element.visible, element.showIcon);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void tickAsync(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (this.config.enabled.getValue(blockState).booleanValue() && this.config.elements != null && !this.config.elements.isEmpty()) {
            for (EffectElement element : this.config.elements) {
                if (!element.enabled.getValue(blockState).booleanValue() || (serverLevel.method_8510() % 1000000L + blockPos.method_10063()) % (long)element.interval.getValue(blockState).intValue() != 0L) continue;
                this.emit(blockState, serverLevel, blockPos, randomSource, element);
            }
        }
    }

    private void emit(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource, EffectElement element) {
        class_238 aABB = new class_238(blockPos).method_1014((double)element.radius.getValue(blockState).intValue()).method_1012(0.0, element.ignoreHeight ? (double)serverLevel.method_31605() : 0.0, 0.0);
        List list = element.onlyPlayer ? serverLevel.method_18467(class_1657.class, aABB) : serverLevel.method_18467(class_1309.class, aABB);
        for (class_1309 entity : list) {
            entity.method_6092(this.decode(element));
        }
    }

    public static class Config {
        BlockStateMappedProperty<Boolean> enabled = BlockStateMappedProperty.of(true);
        public List<EffectElement> elements;
    }

    public static class EffectElement {
        public boolean onlyPlayer = true;
        public boolean ignoreHeight = false;
        BlockStateMappedProperty<Boolean> enabled = BlockStateMappedProperty.of(true);
        BlockStateMappedProperty<Integer> interval = BlockStateMappedProperty.of(1);
        BlockStateMappedProperty<Integer> radius = BlockStateMappedProperty.of(16);
        class_2960 effect = class_2960.method_60656((String)"speed");
        int duration = 20;
        int amplifier = 0;
        boolean ambient = true;
        boolean visible = true;
        boolean showIcon = true;
    }
}

