/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.util.FilamentBlockResourceUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Trapdoor
implements BlockBehaviour<Config>,
class_3737 {
    private final Config config;

    public Trapdoor(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_2680 rotate(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)));
    }

    @Override
    public class_2680 mirror(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)));
    }

    @Override
    public Optional<Boolean> isPathfindable(class_2680 blockState, class_10 pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case class_10.field_50, class_10.field_51 -> Optional.of((Boolean)blockState.method_11654((class_2769)class_2741.field_12537));
            case class_10.field_48 -> Optional.of((Boolean)blockState.method_11654((class_2769)class_2741.field_12508));
        };
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        if (!this.config.canOpenByHand) {
            return class_1269.field_5811;
        }
        this.toggle(blockState, level, blockPos, player);
        return class_1269.field_5812;
    }

    @Override
    public void onExplosionHit(class_2680 blockState, class_3218 level, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        if (explosion.method_60274() && this.config.canOpenByWindCharge && !((Boolean)blockState.method_11654((class_2769)class_2741.field_12484)).booleanValue()) {
            this.toggle(blockState, (class_1937)level, blockPos, null);
        }
    }

    private void toggle(class_2680 blockState, class_1937 level, class_2338 blockPos, @Nullable class_1657 player) {
        class_2680 blockState2 = (class_2680)blockState.method_28493((class_2769)class_2741.field_12537);
        level.method_8652(blockPos, blockState2, 2);
        if (((Boolean)blockState2.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            level.method_39281(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        this.playSound(player, level, blockPos, (Boolean)blockState2.method_11654((class_2769)class_2741.field_12537));
    }

    protected void playSound(@Nullable class_1657 player, class_1937 level, class_2338 blockPos, boolean open) {
        level.method_8396(player, blockPos, class_3414.method_47908((class_2960)(open ? this.config.openSound : this.config.closeSound)), class_3419.field_15245, 1.0f, level.method_8409().method_43057() * 0.1f + 0.9f);
        level.method_33596((class_1297)player, (class_6880)(open ? class_5712.field_28168 : class_5712.field_28169), blockPos);
    }

    @Override
    public void neighborChanged(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 blockPos2, boolean bl) {
        if (level.method_8608()) {
            return;
        }
        boolean bl2 = level.method_49803(blockPos);
        if (bl2 != (Boolean)blockState.method_11654((class_2769)class_2741.field_12484)) {
            if ((Boolean)blockState.method_11654((class_2769)class_2741.field_12537) != bl2) {
                blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(bl2));
                this.playSound(null, level, blockPos, bl2);
            }
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(bl2)), 2);
            if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                level.method_39281(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
            }
        }
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 self, class_1750 blockPlaceContext) {
        class_2680 blockState = self.method_26204().method_9564();
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPlaceContext.method_8037());
        class_2350 direction = blockPlaceContext.method_8038();
        class_2680 class_26802 = blockPlaceContext.method_7717() || !direction.method_10166().method_10179() ? (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)blockPlaceContext.method_8042().method_10153())).method_11657((class_2769)class_2741.field_12518, (Comparable)(direction == class_2350.field_11036 ? class_2760.field_12617 : class_2760.field_12619)) : (blockState = (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)direction)).method_11657((class_2769)class_2741.field_12518, (Comparable)(blockPlaceContext.method_17698().field_1351 - (double)blockPlaceContext.method_8037().method_10264() > 0.5 ? class_2760.field_12619 : class_2760.field_12617)));
        if (blockPlaceContext.method_8045().method_49803(blockPlaceContext.method_8037())) {
            blockState = (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true));
        }
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481, class_2741.field_12537, class_2741.field_12518, class_2741.field_12484, class_2741.field_12508});
    }

    @Override
    public class_3610 getFluidState(class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return null;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            levelAccessor.method_39281(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        return BlockBehaviour.super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12617);
    }

    @Override
    public boolean modifyStateMap(Map<class_2680, BlockData.BlockStateMeta> map, AbstractBlockData<? extends BlockProperties> data) {
        for (Map.Entry<String, PolymerBlockModel> entry : data.blockResource().models().entrySet()) {
            class_2259.class_7211 parsed;
            PolymerBlockModel blockModel = entry.getValue();
            String str = String.format("%s[%s]", data.id(), entry.getKey());
            try {
                parsed = class_2259.method_41957((class_7225)class_7923.field_41175.method_46771(), (String)str, (boolean)false);
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Invalid BlockState value: " + str);
            }
            map.put(parsed.comp_622(), BlockData.BlockStateMeta.of(this.dryState(parsed, blockModel, data.virtual()), blockModel));
            map.put((class_2680)parsed.comp_622().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), BlockData.BlockStateMeta.of(this.wetState(parsed, blockModel, data.virtual()), blockModel));
        }
        return true;
    }

    private class_2680 dryState(class_2259.class_7211 parsed, PolymerBlockModel blockModel, boolean virtual) {
        class_2680 requestedState = null;
        if (parsed.comp_622().method_11654((class_2769)class_2741.field_12518) == class_2760.field_12619 && !((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.TOP_TRAPDOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12518) == class_2760.field_12617 && !((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.BOTTOM_TRAPDOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11043 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.NORTH_TRAPDOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11034 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.EAST_TRAPDOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11035 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.SOUTH_TRAPDOOR, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11039 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.WEST_TRAPDOOR, blockModel, virtual);
        }
        return requestedState;
    }

    private class_2680 wetState(class_2259.class_7211 parsed, PolymerBlockModel blockModel, boolean virtual) {
        class_2680 requestedState = null;
        if (parsed.comp_622().method_11654((class_2769)class_2741.field_12518) == class_2760.field_12619 && !((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.TOP_TRAPDOOR_WATERLOGGED, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12518) == class_2760.field_12617 && !((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11043 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.NORTH_TRAPDOOR_WATERLOGGED, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11034 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.EAST_TRAPDOOR_WATERLOGGED, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11035 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.SOUTH_TRAPDOOR_WATERLOGGED, blockModel, virtual);
        } else if (parsed.comp_622().method_11654((class_2769)class_2741.field_12481) == class_2350.field_11039 && ((Boolean)parsed.comp_622().method_11654((class_2769)class_2741.field_12537)).booleanValue()) {
            requestedState = FilamentBlockResourceUtils.requestBlock(BlockModelType.WEST_TRAPDOOR_WATERLOGGED, blockModel, virtual);
        }
        return requestedState;
    }

    @Override
    public class_2680 modifyPolymerBlockState(class_2680 original, class_2680 blockState) {
        return (class_2680)blockState.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(false));
    }

    public static class Config {
        public boolean canOpenByWindCharge = true;
        public boolean canOpenByHand = true;
        public class_2960 openSound = class_3417.field_14932.method_14833();
        public class_2960 closeSound = class_3417.field_15080.method_14833();
    }
}

