/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.item.Snowball;
import de.tomalbrc.filament.item.BaseProjectileEntity;
import de.tomalbrc.filament.registry.EntityRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9463;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Shoot
implements ItemBehaviour<Config> {
    private final Config config;

    public Shoot(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(class_1792 item, BehaviourHolder behaviourHolder) {
        ItemBehaviour.super.init(item, behaviourHolder);
        if (this.config.dispenserSupport) {
            class_2315.method_10009((class_1935)item, (class_2357)new Snowball.SnowballDispenseBehavior(item, class_9463.class_9464.field_50147));
        }
    }

    @Override
    public class_1271<class_1799> use(class_1792 item, class_1937 level, class_1657 user, class_1268 hand) {
        user.method_7357().method_7906(user.method_5998(hand).method_7909(), this.config.cooldown);
        class_1799 itemStack = user.method_5998(hand);
        if (!level.method_8608()) {
            BaseProjectileEntity projectile = (BaseProjectileEntity)EntityRegistry.BASE_PROJECTILE.method_5883(level);
            if (projectile != null) {
                projectile.config = this.config;
                projectile.method_33574(user.method_19538().method_1031(0.0, (double)user.method_5751(), 0.0));
                itemStack.method_7970(1, (class_1309)user, class_1309.method_56079((class_1268)hand));
                float pitch = user.method_36455();
                float yaw = user.method_36454();
                double speed = this.config.speed;
                Vector3f deltaMovement = new Vector3f(-((float)Math.sin(Math.toRadians(yaw))) * (float)Math.cos(Math.toRadians(pitch)), -((float)Math.sin(Math.toRadians(pitch))), (float)Math.cos(Math.toRadians(yaw)) * (float)Math.cos(Math.toRadians(pitch))).mul((float)speed);
                projectile.method_36456(user.method_36454());
                projectile.method_36457(user.method_36455());
                projectile.method_18800(deltaMovement.x, deltaMovement.y, deltaMovement.z);
                class_1799 projItem = this.config.projectile != null ? ((class_1792)class_7923.field_41178.method_10223(this.config.projectile)).method_7854() : itemStack.method_46651(1);
                class_1799 pickupItem = this.config.pickupItem != null ? ((class_1792)class_7923.field_41178.method_10223(this.config.pickupItem)).method_7854() : projItem;
                projectile.method_7432((class_1297)user);
                projectile.setPickupStack(pickupItem);
                projectile.setBase(itemStack.method_7972());
                projectile.setProjectileStack(projItem);
                projectile.method_7438(this.config.baseDamage);
                if (user.method_7337()) {
                    projectile.field_7572 = class_1665.class_1666.field_7594;
                }
            }
            level.method_8649((class_1297)projectile);
            level.method_43129(null, (class_1297)projectile, this.config.sound != null ? (class_3414)class_7923.field_41172.method_10223(this.config.sound) : (class_3414)class_3417.field_15001.comp_349(), class_3419.field_15254, this.config.volume, this.config.pitch);
            if (!user.method_7337()) {
                if (this.config.consumes) {
                    itemStack.method_7934(1);
                } else if (this.config.damages) {
                    itemStack.method_7970(1, (class_1309)user, class_1309.method_56079((class_1268)hand));
                }
            }
        }
        user.method_7259(class_3468.field_15372.method_14956((Object)item));
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public static class Config {
        public boolean consumes;
        public boolean damages;
        public double baseDamage = 2.0;
        public double speed = 1.0;
        public int cooldown = 8;
        public class_2960 projectile;
        public class_2960 pickupItem;
        public boolean dispenserSupport = false;
        public boolean canPickUp = false;
        public boolean dropAsItem = true;
        public class_2960 sound = ((class_3414)class_3417.field_15001.comp_349()).method_14833();
        public float volume = 1.0f;
        public float pitch = 1.0f;
        public class_2960 hitSound = class_3417.field_15213.method_14833();
        public float hitVolume = 1.0f;
        public float hitPitch = 1.0f;
        public class_2960 hitGroundSound = class_3417.field_15104.method_14833();
        public class_811 display = class_811.field_4315;
        public Quaternionf rotation = new Quaternionf().rotationY(1.5707964f);
        public Vector3f translation = new Vector3f();
        public Vector3f scale = new Vector3f(0.6f);
    }
}

