/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data;

import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.BehaviourList;
import de.tomalbrc.filament.data.properties.EntityProperties;
import de.tomalbrc.filament.entity.BiomeHelper;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1299;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityData {
    @NotNull
    private final class_2960 id;
    @Nullable
    private final class_2960 entityType;
    @Nullable
    private final Map<String, String> translations;
    @Nullable
    private final AnimationInfo animation;
    @Nullable
    private EntityProperties properties;
    @SerializedName(value="behaviour", alternate={"behaviours", "behaviors", "behavior"})
    @Nullable
    private BehaviourConfigMap behaviour;
    @Nullable
    private final BehaviourList goals;
    @Nullable
    private final Set<class_2960> entityTags;
    @Nullable
    private final Map<class_2960, Double> attributes;
    @Nullable
    private final SpawnInfo spawn;

    protected EntityData(@NotNull class_2960 id, @Nullable Map<String, String> translations, @Nullable AnimationInfo animation, @Nullable class_2960 entityType, @Nullable EntityProperties properties, @Nullable BehaviourList goals, @Nullable BehaviourConfigMap behaviour, @Nullable Set<class_2960> entityTags, @Nullable Map<class_2960, Double> attributes, @Nullable SpawnInfo spawn) {
        this.id = id;
        this.translations = translations;
        this.animation = animation;
        this.entityType = entityType;
        this.properties = properties;
        this.behaviour = behaviour;
        this.goals = goals;
        this.entityTags = entityTags;
        this.attributes = attributes;
        this.spawn = spawn;
    }

    @NotNull
    public class_2960 id() {
        return this.id;
    }

    @NotNull
    public class_2960 entityType() {
        return this.entityType == null ? class_7923.field_41177.method_10221((Object)class_1299.field_6093) : this.entityType;
    }

    @Nullable
    public Map<String, String> translations() {
        return this.translations;
    }

    @Nullable
    public AnimationInfo animation() {
        return this.animation;
    }

    @NotNull
    public BehaviourConfigMap behaviour() {
        if (this.behaviour == null) {
            this.behaviour = new BehaviourConfigMap();
        }
        return this.behaviour;
    }

    @Nullable
    public Set<class_2960> entityTags() {
        return this.entityTags;
    }

    @Nullable
    public Map<class_2960, Double> attributes() {
        return this.attributes;
    }

    @NotNull
    public EntityProperties properties() {
        if (this.properties == null) {
            this.properties = new EntityProperties();
        }
        return this.properties;
    }

    @NotNull
    public BehaviourList goals() {
        return this.goals == null ? BehaviourList.EMPTY : this.goals;
    }

    @Nullable
    public SpawnInfo spawn() {
        return this.spawn;
    }

    public record AnimationInfo(class_2960 model, String idleAnimation, String walkAnimation) {
    }

    public record SpawnInfo(int weight, int minGroupSize, int maxGroupSize, boolean foundInOverworld, boolean foundInNether, boolean foundInEnd, Set<class_2960> spawnsLike, Set<class_2960> biomes, Set<class_2960> biomeTags) {
        public void add(class_1299<?> entityType) {
            Predicate<BiomeSelectionContext> biomeSelectors;
            ImmutableSet spawns;
            Object object = spawns = this.spawnsLike == null ? ImmutableSet.of() : null;
            if (spawns == null) {
                spawns = new ObjectArraySet();
                for (class_2960 resourceLocation : this.spawnsLike) {
                    spawns.add((class_1299)class_7923.field_41177.method_10223(resourceLocation));
                }
            }
            Predicate<BiomeSelectionContext> predicate = biomeSelectors = spawns.isEmpty() ? x -> false : BiomeSelectors.spawnsOneOf((Set)spawns);
            if (this.biomes != null) {
                biomeSelectors = biomeSelectors.or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9471, class_1972.field_38748}));
            }
            if (this.biomeTags != null) {
                for (class_2960 tag : this.biomeTags) {
                    biomeSelectors = biomeSelectors.or(BiomeSelectors.tag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tag)));
                }
            }
            if (this.foundInOverworld) {
                biomeSelectors = biomeSelectors.and(BiomeSelectors.foundInOverworld());
            }
            if (this.foundInNether) {
                biomeSelectors = biomeSelectors.and(BiomeSelectors.foundInTheNether());
            }
            if (this.foundInEnd) {
                biomeSelectors = biomeSelectors.and(BiomeSelectors.foundInTheEnd());
            }
            BiomeHelper.addSpawn(entityType, this.weight, this.minGroupSize, this.maxGroupSize, biomeSelectors);
        }
    }
}

