/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.file.loader.AjBlueprintLoader;
import de.tomalbrc.bil.file.loader.AjModelLoader;
import de.tomalbrc.bil.file.loader.BbModelLoader;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import it.unimi.dsi.fastutil.objects.Object2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.FilenameUtils;

public class ModelRegistry {
    private static final String BBMODEL_SUFFIX = ".bbmodel";
    private static final String AJMODEL_SUFFIX = ".ajmodel";
    private static final String AJBP_SUFFIX = ".ajblueprint";
    private static final Object2ReferenceMap<class_2960, Model> ajmodels = new Object2ReferenceArrayMap();

    public static Model getModel(class_2960 model) {
        return (Model)ajmodels.get((Object)model);
    }

    public static class_2960 sanitize(class_2960 resourceLocation) {
        String path;
        String customPath = path.substring((path = resourceLocation.method_12832()).contains("/") ? path.lastIndexOf(47) + 1 : 0, path.lastIndexOf(46));
        return class_2960.method_60655((String)resourceLocation.method_12836(), (String)customPath);
    }

    public static void registerAjModel(InputStream inputStream, class_2960 resourceLocation) throws IOException {
        ajmodels.put((Object)ModelRegistry.sanitize(resourceLocation), (Object)new AjModelLoader().load(inputStream, resourceLocation.method_12832()));
    }

    public static void registerBbModel(InputStream inputStream, class_2960 resourceLocation) throws IOException {
        ajmodels.put((Object)ModelRegistry.sanitize(resourceLocation), (Object)new BbModelLoader().load(inputStream, resourceLocation.method_12832()));
    }

    public static void registerAjBlueprintModel(InputStream inputStream, class_2960 resourceLocation) throws IOException {
        ajmodels.put((Object)ModelRegistry.sanitize(resourceLocation), (Object)new AjBlueprintLoader().load(inputStream, resourceLocation.method_12832()));
    }

    public static class AjModelReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"model");
        }

        public void method_14491(class_3300 resourceManager) {
            Map resources = resourceManager.method_14488("filament/model", path -> path.method_12832().endsWith(ModelRegistry.AJMODEL_SUFFIX) || path.method_12832().endsWith(ModelRegistry.AJBP_SUFFIX) || path.method_12832().endsWith(ModelRegistry.BBMODEL_SUFFIX));
            for (Map.Entry entry : resources.entrySet()) {
                try {
                    InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                    try {
                        String path2 = ((class_2960)entry.getKey()).method_12832();
                        Model model = path2.endsWith(ModelRegistry.AJMODEL_SUFFIX) ? new AjModelLoader().load(inputStream, FilenameUtils.getBaseName((String)path2)) : (path2.endsWith(ModelRegistry.AJBP_SUFFIX) ? new AjBlueprintLoader().load(inputStream, FilenameUtils.getBaseName((String)path2)) : new BbModelLoader().load(inputStream, FilenameUtils.getBaseName((String)path2)));
                        ajmodels.put((Object)ModelRegistry.sanitize((class_2960)entry.getKey()), (Object)model);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException | IllegalStateException e) {
                    Filament.LOGGER.error("Failed to load decoration resource \"{}\".", entry.getKey());
                }
            }
            Filament.LOGGER.info("filament models registered: {}", (Object)ajmodels.size());
        }
    }
}

