/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import net.minecraft.class_10225;
import net.minecraft.class_1540;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class FallingBlock
implements BlockBehaviour<Config> {
    private final Config config;

    public FallingBlock(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void onPlace(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        level.method_64310(blockPos, blockState.method_26204(), this.config.delayAfterPlace.getValue(blockState).intValue());
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        scheduledTickAccess.method_64310(blockPos, blockState.method_26204(), this.config.delayAfterPlace.getValue(blockState).intValue());
        return BlockBehaviour.super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
    }

    @Override
    public void tick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (class_2346.method_10128((class_2680)serverLevel.method_8320(blockPos.method_10074())) && blockPos.method_10264() >= serverLevel.method_31607()) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)serverLevel, (class_2338)blockPos, (class_2680)blockState);
            if (this.config.disableDrops.getValue(blockState).booleanValue()) {
                fallingBlockEntity.method_49181();
            }
            fallingBlockEntity.field_7193 = this.config.dropItem.getValue(blockState);
            fallingBlockEntity.method_5803(true);
            this.falling(fallingBlockEntity);
        }
    }

    private void falling(class_1540 fallingBlockEntity) {
        if (this.config.heavy.getValue(fallingBlockEntity.method_6962()).booleanValue()) {
            fallingBlockEntity.method_6965(this.config.damagePerDistance.getValue(fallingBlockEntity.method_6962()).floatValue(), this.config.maxDamage.getValue(fallingBlockEntity.method_6962()).intValue());
        }
    }

    @Override
    public void onLand(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2680 blockState2, class_1540 fallingBlockEntity) {
        if (!this.config.silent.getValue(blockState).booleanValue()) {
            level.method_45447(null, blockPos, class_3414.method_47908((class_2960)this.config.landSound.getValue(blockState2)), class_3419.field_15245);
        }
    }

    @Override
    public void onBrokenAfterFall(class_1937 level, class_2338 blockPos, class_1540 fallingBlockEntity) {
        class_2680 bs = level.method_8320(blockPos);
        if (!this.config.silent.getValue(bs).booleanValue()) {
            level.method_45447(null, blockPos, class_3414.method_47908((class_2960)this.config.breakSound.getValue(bs)), class_3419.field_15245);
        }
    }

    public static class Config {
        public BlockStateMappedProperty<Boolean> dropItem = BlockStateMappedProperty.of(true);
        BlockStateMappedProperty<Integer> delayAfterPlace = BlockStateMappedProperty.of(2);
        BlockStateMappedProperty<Boolean> heavy = BlockStateMappedProperty.of(false);
        public BlockStateMappedProperty<Float> damagePerDistance = BlockStateMappedProperty.of(Float.valueOf(2.0f));
        public BlockStateMappedProperty<Integer> maxDamage = BlockStateMappedProperty.of(40);
        BlockStateMappedProperty<Boolean> disableDrops = BlockStateMappedProperty.of(false);
        BlockStateMappedProperty<Boolean> silent = BlockStateMappedProperty.of(false);
        BlockStateMappedProperty<class_2960> breakSound = BlockStateMappedProperty.of(class_3417.field_14542.comp_3319());
        BlockStateMappedProperty<class_2960> landSound = BlockStateMappedProperty.of(class_3417.field_14833.comp_3319());
        public BlockStateMappedProperty<Boolean> canBeDamaged = BlockStateMappedProperty.of(false);
        public BlockStateMappedProperty<class_2960> damagedBlock = null;
        public BlockStateMappedProperty<Float> baseBreakChance = BlockStateMappedProperty.of(Float.valueOf(0.05f));
        public BlockStateMappedProperty<Float> breakChancePerDistance = BlockStateMappedProperty.of(Float.valueOf(0.05f));
    }
}

