/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.data.properties.RangedValue;
import de.tomalbrc.filament.data.properties.RangedVector3f;
import de.tomalbrc.filament.mixin.behaviour.grass_spread.SpreadingSnowyDirtBlockAccessor;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GrassSpread
implements BlockBehaviour<Config>,
class_3737 {
    private final Config config;

    public GrassSpread(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isRandomlyTicking(class_2680 blockState) {
        return true;
    }

    @Override
    public void randomTick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (this.config.canDecay && !SpreadingSnowyDirtBlockAccessor.invokeCanBeGrass(blockState, (class_4538)serverLevel, blockPos)) {
            serverLevel.method_8501(blockPos, this.config.decayBlockState);
        } else if (this.config.requiredBrightness.isInRange(serverLevel.method_22339(blockPos.method_10084()))) {
            class_2680 defaultBlockState = blockState.method_26204().method_9564();
            for (int i = 0; i < this.config.attemptsPerTick.getValue(blockState); ++i) {
                Vector3f dim = this.config.spreadDimensions.getValue(blockState).random(randomSource);
                Vector3f off = this.config.spreadOffset.getValue(blockState);
                Vector3f posOffset = dim.add((Vector3fc)off);
                class_2338 blockPos2 = blockPos.method_10081((class_2382)class_2338.method_49637((double)posOffset.x, (double)posOffset.y, (double)posOffset.z));
                class_2680 blockState2 = serverLevel.method_8320(blockPos2);
                boolean canReplace = false;
                for (class_2248 block : this.config.propagatesToBlocks) {
                    if (canReplace |= blockState2.method_27852(block)) break;
                }
                if (!canReplace && this.config.propagatesToBlocks != null && !this.config.propagatesToBlockTags.isEmpty()) {
                    class_2960 tag;
                    Iterator<class_2248> iterator = this.config.propagatesToBlockTags.iterator();
                    while (iterator.hasNext() && !(canReplace |= blockState2.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)(tag = (class_2960)iterator.next()))))) {
                    }
                }
                if (!canReplace || !SpreadingSnowyDirtBlockAccessor.invokeCanPropagate(defaultBlockState, (class_4538)serverLevel, blockPos2)) continue;
                serverLevel.method_8501(blockPos2, defaultBlockState);
            }
        }
    }

    public static class Config {
        public BlockStateMappedProperty<RangedVector3f> spreadDimensions = BlockStateMappedProperty.of(new RangedVector3f(new RangedValue(0.0, 3.0), new RangedValue(0.0, 5.0), new RangedValue(0.0, 3.0)));
        public BlockStateMappedProperty<Vector3f> spreadOffset = BlockStateMappedProperty.of(new Vector3f(-1.0f, -3.0f, -1.0f));
        public BlockStateMappedProperty<Integer> attemptsPerTick = BlockStateMappedProperty.of(4);
        public RangedValue requiredBrightness = new RangedValue(9.0, 15.0);
        public boolean canDecay = true;
        public class_2680 decayBlockState = class_2246.field_10566.method_9564();
        public List<class_2248> propagatesToBlocks = List.of(class_2246.field_10566);
        public List<class_2960> propagatesToBlockTags = List.of();
    }
}

