/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import java.util.function.BiConsumer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9902;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Lever
implements BlockBehaviour<Config> {
    private final Config config;

    public Lever(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        this.cycle(blockState, level, blockPos);
        return class_1269.field_5812;
    }

    @Override
    public void onExplosionHit(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
        if (explosion.method_60274()) {
            this.cycle(blockState, (class_1937)serverLevel, blockPos);
        }
    }

    private void cycle(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        blockState = (class_2680)blockState.method_28493((class_2769)class_2401.field_11265);
        level.method_8652(blockPos, blockState, 3);
        this.updateNeighbours(blockState, level, blockPos);
        this.playSound(null, (class_1936)level, blockPos, blockState);
        level.method_33596(null, (class_6880)((Boolean)blockState.method_11654((class_2769)class_2401.field_11265) != false ? class_5712.field_28174 : class_5712.field_28175), blockPos);
    }

    protected void playSound(@Nullable class_1657 player, class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState) {
        float pitch = this.config.pitch.getOrDefault(blockState, Float.valueOf((Boolean)blockState.method_11654((class_2769)class_2401.field_11265) != false ? 0.6f : 0.5f)).floatValue();
        levelAccessor.method_8396((class_1297)player, blockPos, class_3414.method_47908((class_2960)this.config.sound.getValue(blockState)), class_3419.field_15245, this.config.volume.getValue(blockState).floatValue(), pitch);
    }

    @Override
    public void affectNeighborsAfterRemoval(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, boolean bl) {
        if (!bl && ((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
            this.updateNeighbours(blockState, (class_1937)serverLevel, blockPos);
        }
    }

    @Override
    public int getSignal(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        return (Boolean)blockState.method_11654((class_2769)class_2401.field_11265) != false ? this.config.powerlevel.getValue(blockState) : 0;
    }

    @Override
    public int getDirectSignal(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        return (Boolean)blockState.method_11654((class_2769)class_2401.field_11265) != false && Lever.getConnectedDirection(blockState) == direction ? this.config.powerlevel.getValue(blockState) : 0;
    }

    @Override
    public boolean isSignalSource(class_2680 blockState) {
        return true;
    }

    private void updateNeighbours(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        class_2350 direction;
        class_9904 orientation = class_9902.method_61826((class_1937)level, (class_2350)direction, (class_2350)((direction = Lever.getConnectedDirection(blockState).method_10153()).method_10166().method_10179() ? class_2350.field_11036 : (class_2350)blockState.method_11654((class_2769)class_2401.field_11177)));
        level.method_8452(blockPos, blockState.method_26204(), orientation);
        level.method_8452(blockPos.method_10093(direction), blockState.method_26204(), orientation);
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2401.field_11007, class_2401.field_11177, class_2401.field_11265});
    }

    static class_2350 getConnectedDirection(class_2680 state) {
        return switch ((class_2738)state.method_11654((class_2769)class_2401.field_11007)) {
            case class_2738.field_12473 -> class_2350.field_11033;
            case class_2738.field_12475 -> class_2350.field_11036;
            default -> (class_2350)state.method_11654((class_2769)class_2401.field_11177);
        };
    }

    public static class Config {
        public BlockStateMappedProperty<Integer> powerlevel = BlockStateMappedProperty.of(15);
        public BlockStateMappedProperty<class_2960> sound = BlockStateMappedProperty.of(class_3417.field_14962.comp_3319());
        public BlockStateMappedProperty<Float> volume = BlockStateMappedProperty.of(Float.valueOf(0.3f));
        public BlockStateMappedProperty<Float> pitch = BlockStateMappedProperty.empty();
    }
}

