/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.util.FilamentBlockResourceUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2778;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stairs
implements BlockBehaviour<Config>,
class_3737 {
    private final Config config;

    public Stairs(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617)).method_11657((class_2769)class_2510.field_11565, (Comparable)class_2778.field_12710)).method_11657((class_2769)class_2510.field_11573, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public Optional<Boolean> useShapeForLightOcclusion(class_2680 blockState) {
        return Optional.of(false);
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2510.field_11571, class_2510.field_11572, class_2510.field_11565, class_2510.field_11573});
    }

    private static boolean canTakeShape(class_2680 state, class_1922 level, class_2338 pos, class_2350 face) {
        class_2680 blockState = level.method_8320(pos.method_10093(face));
        return !Stairs.isStairs(blockState) || blockState.method_11654((class_2769)class_2510.field_11571) != state.method_11654((class_2769)class_2510.field_11571) || blockState.method_11654((class_2769)class_2510.field_11572) != state.method_11654((class_2769)class_2510.field_11572);
    }

    public static boolean isStairs(class_2680 state) {
        if (state.method_26204() instanceof class_2510) {
            return true;
        }
        if (state.method_26204() instanceof SimpleBlock) {
            for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behavior : ((SimpleBlock)state.method_26204()).getBehaviours()) {
                if (!behavior.getKey().id().toString().equals("filament:stairs")) continue;
                return true;
            }
        }
        return false;
    }

    private static class_2778 getStairsShape(class_2680 state, class_1922 level, class_2338 pos) {
        class_2350 direction3;
        class_2350 direction2;
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
        class_2680 blockState = level.method_8320(pos.method_10093(direction));
        if (Stairs.isStairs(blockState) && state.method_11654((class_2769)class_2510.field_11572) == blockState.method_11654((class_2769)class_2510.field_11572) && (direction2 = (class_2350)blockState.method_11654((class_2769)class_2510.field_11571)).method_10166() != ((class_2350)state.method_11654((class_2769)class_2510.field_11571)).method_10166() && Stairs.canTakeShape(state, level, pos, direction2.method_10153())) {
            if (direction2 == direction.method_10160()) {
                return class_2778.field_12708;
            }
            return class_2778.field_12709;
        }
        class_2680 blockState2 = level.method_8320(pos.method_10093(direction.method_10153()));
        if (Stairs.isStairs(blockState2) && state.method_11654((class_2769)class_2510.field_11572) == blockState2.method_11654((class_2769)class_2510.field_11572) && (direction3 = (class_2350)blockState2.method_11654((class_2769)class_2510.field_11571)).method_10166() != ((class_2350)state.method_11654((class_2769)class_2510.field_11571)).method_10166() && Stairs.canTakeShape(state, level, pos, direction3)) {
            if (direction3 == direction.method_10160()) {
                return class_2778.field_12712;
            }
            return class_2778.field_12713;
        }
        return class_2778.field_12710;
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 prevBlockState, class_1750 context) {
        class_2350 direction = context.method_8038();
        class_2338 blockPos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(blockPos);
        class_2680 blockState = (class_2680)((class_2680)((class_2680)this.modifyDefaultState(prevBlockState).method_11657((class_2769)class_2510.field_11571, (Comparable)context.method_8042())).method_11657((class_2769)class_2510.field_11572, (Comparable)(!(direction == class_2350.field_11033 || direction != class_2350.field_11036 && context.method_17698().field_1351 - (double)blockPos.method_10264() > 0.5) ? class_2760.field_12617 : class_2760.field_12619))).method_11657((class_2769)class_2510.field_11573, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        return (class_2680)blockState.method_11657((class_2769)class_2510.field_11565, (Comparable)Stairs.getStairsShape(blockState, (class_1922)context.method_8045(), blockPos));
    }

    @Override
    public Optional<Boolean> canBeReplaced(class_2680 blockState, class_1750 blockPlaceContext) {
        return Optional.of(false);
    }

    @Override
    public class_3610 getFluidState(class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)class_2510.field_11573)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return null;
    }

    public boolean method_10311(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
        return super.method_10311(levelAccessor, blockPos, blockState, fluidState);
    }

    public boolean method_10310(@Nullable class_1309 livingEntity, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_3611 fluid) {
        return super.method_10310(livingEntity, blockGetter, blockPos, blockState, fluid);
    }

    @Override
    public class_2680 updateShape(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 pos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        if (((Boolean)state.method_11654((class_2769)class_2510.field_11573)).booleanValue()) {
            scheduledTickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return direction.method_10166().method_10179() ? (class_2680)state.method_11657((class_2769)class_2510.field_11565, (Comparable)Stairs.getStairsShape(state, (class_1922)level, pos)) : state;
    }

    @Override
    public Optional<Boolean> isPathfindable(class_2680 blockState, class_10 pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case class_10.field_50, class_10.field_51 -> Optional.of(false);
            case class_10.field_48 -> Optional.of(blockState.method_26227().method_15767(class_3486.field_15517));
        };
    }

    public static BlockModelType getStairs(class_2350 direction, class_2760 blockHalf, class_2778 shape, boolean waterlogged) {
        if (direction.method_10166().method_10178()) {
            throw new IllegalArgumentException("Only horizontal directions are supported!");
        }
        StringBuilder self = new StringBuilder();
        self.append("STAIRS_").append(direction.name()).append("_").append(blockHalf.name()).append("_").append(shape.name());
        if (waterlogged) {
            self.append("_WATERLOGGED");
        }
        return BlockModelType.valueOf((String)self.toString());
    }

    @Override
    public boolean modifyStateMap(Map<class_2680, BlockData.BlockStateMeta> map, AbstractBlockData<? extends BlockProperties> data) {
        for (Map.Entry<String, PolymerBlockModel> entry : data.blockResource().models().entrySet()) {
            class_2259.class_7211 parsed;
            PolymerBlockModel blockModel = entry.getValue();
            String str = String.format("%s[%s]", data.id(), entry.getKey());
            try {
                parsed = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Invalid BlockState value: " + str);
            }
            class_2680 state = parsed.comp_622();
            BlockModelType stairState = Stairs.getStairs((class_2350)state.method_11654((class_2769)class_2510.field_11571), (class_2760)state.method_11654((class_2769)class_2510.field_11572), (class_2778)state.method_11654((class_2769)class_2510.field_11565), false);
            class_2680 requestedState = FilamentBlockResourceUtils.requestBlock(stairState, blockModel, data.virtual());
            map.put(parsed.comp_622(), BlockData.BlockStateMeta.of(requestedState, blockModel));
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            class_2680 blockState = ((BlockData.BlockStateMeta)entry.getValue()).blockState();
            if (!blockState.method_28498((class_2769)class_2510.field_11573) || ((Boolean)blockState.method_11654((class_2769)class_2510.field_11573)).booleanValue()) continue;
            BlockModelType stairStateWet = Stairs.getStairs((class_2350)blockState.method_11654((class_2769)class_2510.field_11571), (class_2760)blockState.method_11654((class_2769)class_2510.field_11572), (class_2778)blockState.method_11654((class_2769)class_2510.field_11565), true);
            class_2680 res = FilamentBlockResourceUtils.requestBlock(stairStateWet, ((BlockData.BlockStateMeta)entry.getValue()).polymerBlockModel(), data.virtual());
            map.put((class_2680)((class_2680)entry.getKey()).method_11657((class_2769)class_2510.field_11573, (Comparable)Boolean.valueOf(true)), BlockData.BlockStateMeta.of(res, ((BlockData.BlockStateMeta)entry.getValue()).polymerBlockModel()));
        }
        return true;
    }

    public static class Config {
    }
}

