/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.ItemPredicateModelProvider;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.generator.ItemAssetGenerator;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_8051;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class GenerateTrimModels
implements ItemBehaviour<Config>,
ItemPredicateModelProvider {
    private final Config config;

    public GenerateTrimModels(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    private class_1304 slot(Data<?> data) {
        if (data.components().method_57832(class_9334.field_54196)) {
            return Objects.requireNonNull((class_10192)data.components().method_58694(class_9334.field_54196)).comp_3174();
        }
        return null;
    }

    @Override
    public void generate(Data<?> data) {
        class_1304 slot = this.slot(data);
        Object armorType = null;
        String namespace = null;
        if (slot != null && this.config.typePrefix == null) {
            for (class_8051 type : class_8051.values()) {
                if (type.method_48399() != slot) continue;
                namespace = "minecraft";
                armorType = "trims/items/" + type.method_48400() + "_trim_";
                break;
            }
        } else if (this.config.typePrefix != null) {
            if (this.config.typePrefix.contains(":")) {
                class_2960 r = class_2960.method_60654((String)this.config.typePrefix);
                armorType = r.method_12832();
                namespace = r.method_12836();
            } else {
                armorType = this.config.typePrefix;
            }
        }
        ItemResource itemResource = data.itemResource();
        if (armorType != null && itemResource != null) {
            ItemAssetGenerator.createItemModels(data.id(), itemResource);
            Object2ObjectArrayMap map = new Object2ObjectArrayMap();
            ArrayList<class_2960> list = new ArrayList<class_2960>();
            list.addAll(this.config.customMaterials);
            list.addAll(this.config.materials);
            for (class_2960 suffix : list) {
                class_2960 layer1 = class_2960.method_60655((String)(namespace == null ? suffix.method_12836() : namespace), (String)String.format("%s%s", armorType, suffix.method_12832()));
                String name = data.id().method_12832() + "_" + suffix.method_12832();
                ModelAsset.Builder modelAsset = ModelAsset.builder();
                modelAsset.parent(itemResource.parent());
                Map<String, class_2960> layer0 = itemResource.textures().get("default");
                modelAsset.texture("layer0", layer0.get("layer0").toString());
                modelAsset.texture("layer1", layer1.toString());
                class_2960 model = class_2960.method_60655((String)data.id().method_12836(), (String)name);
                Map<String, class_2960> models = itemResource.getModels();
                if (models != null) {
                    models.put(suffix.method_12832(), model);
                }
                map.put((Object)model, (Object)modelAsset.build().toBytes());
            }
            PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(resourcePackBuilder -> {
                map.forEach((model, modelAsset) -> resourcePackBuilder.addData(AssetPaths.itemModel((class_2960)model), modelAsset));
                ItemAssetGenerator.createTrimModels(resourcePackBuilder, data.id(), Objects.requireNonNull(data.itemResource()), data.components().method_57832(class_9334.field_49644) || data.vanillaItem().method_57347().method_57832(class_9334.field_49644));
            });
        }
    }

    @Override
    public List<String> requiredModels() {
        return List.of("default");
    }

    @Override
    public boolean canCreateItemModels() {
        return true;
    }

    public static class Config {
        public String typePrefix = null;
        public List<class_2960> customMaterials = List.of();
        public List<class_2960> materials = List.of(class_2960.method_60656((String)"quartz"), class_2960.method_60656((String)"iron"), class_2960.method_60656((String)"netherite"), class_2960.method_60656((String)"redstone"), class_2960.method_60656((String)"copper"), class_2960.method_60656((String)"gold"), class_2960.method_60656((String)"emerald"), class_2960.method_60656((String)"diamond"), class_2960.method_60656((String)"lapis"), class_2960.method_60656((String)"amethyst"), class_2960.method_60656((String)"resin"));
    }
}

