/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.item;

import de.tomalbrc.filament.api.behaviour.ItemBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.item.SimpleItem;
import de.tomalbrc.filament.util.ExecuteUtil;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_9463;
import org.jetbrains.annotations.NotNull;

public class Snowball
implements ItemBehaviour<Config> {
    private final Config config;

    public Snowball(Config config) {
        this.config = config;
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void init(class_1792 item, BehaviourHolder behaviourHolder) {
        ItemBehaviour.super.init(item, behaviourHolder);
        if (this.config.dispenserSupport) {
            class_2315.method_10009((class_1935)item, (class_2357)new SnowballDispenseBehavior(item, class_9463.class_9464.field_50147));
        }
    }

    @Override
    public class_1269 use(class_1792 item, class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_1676.method_61549(class_1680::new, (class_3218)serverLevel, (class_1799)itemStack, (class_1309)player, (float)0.0f, (float)this.config.power, (float)this.config.inaccuracy);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        itemStack.method_57008(1, (class_1309)player);
        return class_1269.field_5812;
    }

    public class_1676 asProjectile(class_1937 level, class_2374 pos, class_1799 stack, class_2350 direction) {
        return new class_1680(level, pos.method_10216(), pos.method_10214(), pos.method_10215(), stack);
    }

    public List<String> commands() {
        return this.config.hitCommands == null ? (this.config.hitCommand == null ? null : List.of(this.config.hitCommand)) : this.config.hitCommands;
    }

    public List<String> entityHitCommands() {
        return this.config.entityHitCommands == null ? (this.config.entityHitCommand == null ? null : List.of(this.config.entityHitCommand)) : this.config.entityHitCommands;
    }

    public void run(class_1680 snowball, class_243 pos) {
        if (this.config.hitCommand == null && this.config.hitCommands == null) {
            return;
        }
        class_1297 owner = snowball.method_24921();
        if (owner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)owner;
            List<String> cmd = this.commands();
            if (cmd != null) {
                ExecuteUtil.asPlayer(serverPlayer, (class_243)(this.config.executeAtHit ? pos : null), cmd.toArray(new String[0]));
            }
        }
    }

    public void runEntity(class_1680 snowball, class_243 pos, class_1297 entity) {
        if (this.config.entityHitCommand == null && this.config.entityHitCommands == null && this.config.hitCommand == null && this.config.hitCommands == null) {
            return;
        }
        class_1297 owner = snowball.method_24921();
        if (owner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)owner;
            List<String> cmd = this.commands();
            List<String> hitCmd = this.entityHitCommands();
            if (hitCmd == null) {
                hitCmd = cmd;
            }
            if (hitCmd == null) {
                return;
            }
            for (int i = 0; i < hitCmd.size(); ++i) {
                hitCmd.set(i, hitCmd.get(i).replace("%target%", entity.method_5845()));
            }
            ExecuteUtil.asPlayer(serverPlayer, (class_243)(this.config.executeAtHit ? pos : null), hitCmd.toArray(new String[0]));
        }
    }

    public static class Config {
        public float inaccuracy = 1.0f;
        public float power = 1.5f;
        public boolean dispenserSupport = false;
        public String hitCommand;
        public List<String> hitCommands;
        public String entityHitCommand;
        public List<String> entityHitCommands;
        public boolean executeAtHit = true;
    }

    public static class SnowballDispenseBehavior
    extends class_2347 {
        private final SimpleItem projectileItem;
        private final class_9463.class_9464 dispenseConfig;

        public SnowballDispenseBehavior(class_1792 projectileItem, class_9463.class_9464 dispenseConfig) {
            this.projectileItem = (SimpleItem)projectileItem;
            this.dispenseConfig = dispenseConfig;
        }

        @NotNull
        public class_1799 method_10135(class_2342 blockSource, class_1799 item) {
            class_3218 serverLevel = blockSource.comp_1967();
            class_2350 direction = (class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918);
            class_2374 position = this.dispenseConfig.comp_2544().getDispensePosition(blockSource, direction);
            class_1676.method_61552((class_1676)((Snowball)this.projectileItem.getOrThrow(Behaviours.SNOWBALL)).asProjectile((class_1937)serverLevel, position, item, direction), (class_3218)serverLevel, (class_1799)item, (double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165(), (float)this.dispenseConfig.comp_2546(), (float)this.dispenseConfig.comp_2545());
            return item;
        }

        protected void method_10136(class_2342 blockSource) {
            blockSource.comp_1967().method_20290(this.dispenseConfig.comp_2547().orElse(1002), blockSource.comp_1968(), 0);
        }
    }
}

